//                                               -*- C++ -*-
/**
 *  @file  NearestPointAlgorithmImplementationResult.cxx
 *  @brief Result stores the result of a NearestPointAlgorithmImplementation
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NearestPointAlgorithmImplementationResult.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "NearestPointAlgorithmImplementation.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(NearestPointAlgorithmImplementation::Result);

      static Base::Common::Factory<NearestPointAlgorithmImplementation::Result> RegisteredFactory("NearestPointAlgorithmImplementation::Result");

      /* Default constructor */
      NearestPointAlgorithmImplementation::Result::Result():
	PersistentObject(),
        minimizer_(NumericalPoint(1)),
        iterationsNumber_(0),
        absoluteError_(0.),
        relativeError_(0.),
        residualError_(0.),
        constraintError_(0.)
      {
	// Nothing to do
      }

      /* Standard constructor */
      NearestPointAlgorithmImplementation::Result::Result(const NumericalPoint & minimizer,
							  const UnsignedLong iterationsNumber,
							  const NumericalScalar absoluteError,
							  const NumericalScalar relativeError,
							  const NumericalScalar residualError,
							  const NumericalScalar constraintError):
	PersistentObject(),
        minimizer_(minimizer),
        iterationsNumber_(iterationsNumber),
        absoluteError_(absoluteError),
        relativeError_(relativeError),
        residualError_(residualError),
        constraintError_(constraintError)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      NearestPointAlgorithmImplementation::Result * NearestPointAlgorithmImplementation::Result::clone() const
      {
	return new Result(*this);
      }

      /* Minimizer accessors */
      NearestPointAlgorithmImplementation::NumericalPoint NearestPointAlgorithmImplementation::Result::getMinimizer() const
      {
	return minimizer_;
      }

      /* Minimizer accessors */
      void NearestPointAlgorithmImplementation::Result::setMinimizer(const NumericalPoint & minimizer)
      {
	minimizer_ = minimizer;
      }

      /* Iterations number accessor */
      UnsignedLong NearestPointAlgorithmImplementation::Result::getIterationsNumber() const
      {
	return iterationsNumber_;
      }

      /* Iterations Number accessor */
      void NearestPointAlgorithmImplementation::Result::setIterationsNumber(const UnsignedLong iterationsNumber)
      {
	iterationsNumber_ = iterationsNumber;
      }

      /* Absolute error accessor */
      NumericalScalar NearestPointAlgorithmImplementation::Result::getAbsoluteError() const
      {
	return absoluteError_;
      }

      /* Absolute error accessor */
      void NearestPointAlgorithmImplementation::Result::setAbsoluteError(const NumericalScalar absoluteError)
      {
	absoluteError_ = absoluteError;
      }

      /* Relative error accessor */
      NumericalScalar NearestPointAlgorithmImplementation::Result::getRelativeError() const
      {
	return relativeError_;
      }

      /* Relative error accessor */
      void NearestPointAlgorithmImplementation::Result::setRelativeError(const NumericalScalar relativeError)
      {
	relativeError_ = relativeError;
      }

      /* Residual error accessor */
      NumericalScalar NearestPointAlgorithmImplementation::Result::getResidualError() const
      {
	return residualError_;
      }

      /* Residual error accessor */
      void NearestPointAlgorithmImplementation::Result::setResidualError(const NumericalScalar residualError)
      {
	residualError_ = residualError;
      }

      /* Constraint error accessor */
      NumericalScalar NearestPointAlgorithmImplementation::Result::getConstraintError() const
      {
	return constraintError_;
      }

      /* Constraint error accessor */
      void NearestPointAlgorithmImplementation::Result::setConstraintError(const NumericalScalar constraintError)
      {
	constraintError_ = constraintError;
      }

      /* String converter */
      String NearestPointAlgorithmImplementation::Result::__repr__() const
      {
	OSS oss;
	oss << "class=" << NearestPointAlgorithmImplementation::Result::GetClassName()
            << " minimizer=" << minimizer_
	    << " iterationsNumber=" << iterationsNumber_
	    << " absoluteError=" << absoluteError_
	    << " relativeError=" << relativeError_
	    << " residualError=" << residualError_
	    << " constraintError=" << constraintError_;
	return oss;
      }

      /* Method save() stores the object through the StorageManager */
      void NearestPointAlgorithmImplementation::Result::save(StorageManager::Advocate & adv) const
      {
	PersistentObject::save(adv);
	adv.saveAttribute( "minimizer_", minimizer_ );
	adv.saveAttribute( "iterationsNumber_", iterationsNumber_ );
 	adv.saveAttribute( "absoluteError_", absoluteError_ );
 	adv.saveAttribute( "relativeError_", relativeError_ );
 	adv.saveAttribute( "residualError_", residualError_ );
 	adv.saveAttribute( "constraintError_", constraintError_ );
      }

      /* Method load() reloads the object from the StorageManager */
      void NearestPointAlgorithmImplementation::Result::load(StorageManager::Advocate & adv)
      {
	PersistentObject::load(adv);
	adv.loadAttribute( "minimizer_", minimizer_ );
	adv.loadAttribute( "iterationsNumber_", iterationsNumber_ );
 	adv.loadAttribute( "absoluteError_", absoluteError_ );
 	adv.loadAttribute( "relativeError_", relativeError_ );
 	adv.loadAttribute( "residualError_", residualError_ );
 	adv.loadAttribute( "constraintError_", constraintError_ );
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */
