//                                               -*- C++ -*-
/**
 *  @file  PersistentObject.cxx
 *  @brief Class PersistentObject saves and reloads the object's internal state
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: PersistentObject.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "PersistentObject.hxx"
#include "OTprivate.hxx"

namespace OpenTURNS
{

  /*
   * The default name of any object
   */
  const String DefaultName = String(
#ifdef OBJECT_DEFAULT_NAME
				    OBJECT_DEFAULT_NAME
#else
				    "Unnamed"
#endif
				    );

  namespace Base
  {

    namespace Common
    {

      CLASSNAMEINIT(PersistentObject);

      /* Method save() stores the object through the StorageManager */
      void PersistentObject::save(StorageManager & mgr, const String & label, bool fromStudy) const
      {
	if (! mgr.isSavedObject(id_)) {
	  Pointer<StorageManager::Advocate> p_adv ( mgr.registerObject(*this, fromStudy) );
	  p_adv->setLabel( label );
	  save(*p_adv);
	  p_adv->saveObject();
	  mgr.markObjectAsSaved(id_);
	}
      }

      /* Method save() stores the object through the StorageManager */
      void PersistentObject::save(StorageManager & mgr, bool fromStudy) const
      {
	if (! mgr.isSavedObject(id_)) {
	  Pointer<StorageManager::Advocate> p_adv ( mgr.registerObject(*this, fromStudy) );
	  save(*p_adv);
	  p_adv->saveObject();
	  mgr.markObjectAsSaved(id_);
	}
      }

      /* Method save() stores the object through the StorageManager */
      void PersistentObject::save(StorageManager::Advocate & adv) const
      {
	adv.saveAttribute( "class", getClassName() );
	adv.saveAttribute( "id", id_ );
	if (hasName()) adv.saveAttribute( "name", getName() );
      }

      /* Method load() reloads the object from the StorageManager */
      void PersistentObject::load(StorageManager::Advocate & adv)
      {
	adv.loadAttribute( "id", shadowedId_);
	String name;
	adv.loadAttribute( "name", name );
	if (name == OT::DefaultName) p_name_.reset();
	else setName(name);
      }


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
