\name{estimateTruncatedNormalParameters}
\alias{estimateTruncatedNormalParameters}
\title{Estimates the underlying truncated normal distribution parameters from a sample.}
\description{
This ROT function, called from a TruncatedNormalFactory C++ object, is given a sample
and returns the estimated parameters of the underlying TruncatedNormal distribution,   
as well as the corresponding confidence intervals of required level.                          
}
\usage{
estimateTruncatedNormalParameters(numericalSample, testLevel = 0.975)
}
\arguments{
  \item{numericalSample}{A vector containing the sample.}
  \item{testLevel}{the test level. (scalar in [0:1])}
}
\value{
A list is returned, containing :
  \item{distribution}{The distribution name.}
  \item{mu}{The estimated mu parameter.}
  \item{sigma}{The sigma parameter.}
  \item{a}{The aParameter parameter.}
  \item{b}{The bParameter parameter.}
  \item{confidenceIntervalmu}{CI for the mu parameter (vector).}
  \item{confidenceIntervalsigma}{CI for the sigma parameter (vector).}
  \item{logLikelihood}{The model loglikelihood.}
}
\author{Pierre-Matthieu Pair, Rgis Lebrun.}
\examples{
# Standard TruncatedNormal distribution example.
numericalSample <- rnorm(1000, 3, 1.5)
numericalSample <- numericalSample[numericalSample > 0.0 &&
numericalSample < 5.0]
print(estimateTruncatedNormalParameters(numericalSample))
}
\keyword{distribution}
