// SWIG file uncertainty_all.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-08-28 17:36:47 +0200 (Thu, 28 Aug 2008) $
// Id : $Id: uncertainty.i 916 2008-08-28 15:36:47Z dutka $

%module(docstring="Uncertainty is the probabilistic part of Open TURNS.") uncertainty_all
%feature("autodoc","1");

%{
#include "OTBase.hxx"
#include "OTUncertainty.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

%import base_common.i
%import base_all.i

/* Uncertainty/Model */
%include DistributionImplementation.i
%include DistributionImplementationFactory.i
%include Distribution.i
%include DistributionFactory.i
%include UsualDistribution.i
%include ContinuousDistribution.i
%include EllipticalDistribution.i
%include NonEllipticalDistribution.i
%include DiscreteDistribution.i
%include CopulaImplementation.i
%include Copula.i
%include ArchimedeanCopula.i
%include SklarCopula.i

/* Uncertainty/Distribution */
%include SpecFunc.i
%include DistFunc.i
%include Beta.i
%include BetaFactory.i
%include ChiSquare.i
%include ChiSquareFactory.i
%include Epanechnikov.i
%include Exponential.i
%include ExponentialFactory.i
%include Gamma.i
%include GammaFactory.i
%include Geometric.i
%include GeometricFactory.i
%include Gumbel.i
%include GumbelFactory.i
%include Histogram.i
%include HistogramFactory.i
%include Laplace.i
%include LaplaceFactory.i
%include LogNormal.i
%include LogNormalFactory.i
%include Logistic.i
%include LogisticFactory.i
%include MultiNomial.i
%include MultiNomialFactory.i
%include NonCentralStudent.i
%include Normal.i
%include NormalFactory.i
%include Poisson.i
%include PoissonFactory.i
%include Rayleigh.i
%include RayleighFactory.i
%include Student.i
%include StudentFactory.i
%include Triangular.i
%include TriangularFactory.i
%include TruncatedDistribution.i
%include TruncatedNormal.i
%include TruncatedNormalFactory.i
%include Uniform.i
%include UniformFactory.i
%include UserDefined.i
%include UserDefinedFactory.i
%include Weibull.i
%include WeibullFactory.i
%include IndependentCopula.i
%include NormalCopula.i
%include NormalCopulaFactory.i
%include FrankCopula.i
%include FrankCopulaFactory.i
%include ClaytonCopula.i
%include ClaytonCopulaFactory.i
%include GumbelCopula.i
%include GumbelCopulaFactory.i
%include ComposedDistribution.i
%include ComposedCopula.i
%include RandomMixture.i
%include Mixture.i
%include KernelMixture.i
%include KernelSmoothing.i

/* Uncertainty/Model */
%include RandomVectorImplementation.i
%include ConstantRandomVector.i
%include CompositeRandomVector.i
%include UsualRandomVector.i
%include EventRandomVectorImplementation.i
%include RandomVector.i
%include Event.i
%include StandardEvent.i

/* Uncertainty/Algorithm/Experiment */
%include ExperimentImplementation.i
%include StratifiedExperiment.i
%include WeightedExperiment.i
%include Experiment.i
%include Axial.i
%include Composite.i
%include Factorial.i
%include Box.i
%include FixedExperiment.i
%include MonteCarloExperiment.i
%include LHSExperiment.i
%include LowDiscrepancyExperiment.i
%include ImportanceSamplingExperiment.i

/* Uncertainty/Algorithm/OrthogonalBasis */
%include EnumerateFunction.i
%include OrthogonalUniVariatePolynomialFactory.i
%include HermiteFactory.i
%include JacobiFactory.i
%include LaguerreFactory.i
%include LegendreFactory.i
%include OrthogonalUniVariatePolynomialFamily.i
%include OrthogonalFunctionFactory.i
%include OrthogonalProductPolynomialFactory.i
%include OrthogonalBasis.i

/* Uncertainty/Algorithm/MetaModel */
%include LinearTaylor.i
%include QuadraticTaylor.i
%include LinearLeastSquares.i
%include QuadraticLeastSquares.i
%include AdaptiveStrategyImplementation.i
%include FixedStrategy.i
%include SequentialStrategy.i
%include CleaningStrategy.i
%include AdaptiveStrategy.i
%include ProjectionStrategyImplementation.i
%include LeastSquaresStrategy.i
%include ProjectionStrategy.i
%include FunctionalChaosResult.i
%include FunctionalChaosAlgorithm.i
%include FunctionalChaosRandomVector.i
%include SVMKernelImplementation.i
%include SVMKernel.i
%include NormalRBF.i
%include ExponentialRBF.i
%include PolynomialKernel.i
%include RationalKernel.i
%include SVMKernelRegressionEvaluation.i
%include SVMKernelRegressionGradient.i
%include SVMKernelRegressionHessian.i
%include MetaModelAlgorithm.i

/* Uncertainty/Algorithm/QuadraticCumul */
%include QuadraticCumul.i

/* Uncertainty/Algorithm/IsoProbabilisticTransformation */
%include MarginalTransformationEvaluation.i
%include MarginalTransformationGradient.i
%include MarginalTransformationHessian.i
%include InverseMarginalTransformationEvaluation.i
%include InverseMarginalTransformationGradient.i
%include InverseMarginalTransformationHessian.i
%include NatafEllipticalCopulaEvaluation.i
%include NatafEllipticalCopulaGradient.i
%include NatafEllipticalCopulaHessian.i
%include InverseNatafEllipticalCopulaEvaluation.i
%include InverseNatafEllipticalCopulaGradient.i
%include InverseNatafEllipticalCopulaHessian.i
%include NatafIndependentCopulaEvaluation.i
%include NatafIndependentCopulaGradient.i
%include NatafIndependentCopulaHessian.i
%include InverseNatafIndependentCopulaEvaluation.i
%include InverseNatafIndependentCopulaGradient.i
%include InverseNatafIndependentCopulaHessian.i
%include NatafEllipticalDistributionEvaluation.i
%include NatafEllipticalDistributionGradient.i
%include NatafEllipticalDistributionHessian.i
%include InverseNatafEllipticalDistributionEvaluation.i
%include InverseNatafEllipticalDistributionGradient.i
%include InverseNatafEllipticalDistributionHessian.i
%include RosenblattEvaluation.i
%include InverseRosenblattEvaluation.i

/* Uncertainty/Algorithm/Analytical */
%include AnalyticalResult.i
%include Analytical.i
%include FORMResult.i
%include FORM.i
%include SORMResult.i
%include SORM.i
%include StrongMaximumTest.i

/* Uncertainty/Algorithm/Simulation */
%include SimulationResultImplementation.i
%include SimulationResult.i
%include Simulation.i
%include PostAnalyticalSimulation.i
%include Wilks.i
%include MonteCarlo.i
%include LHS.i
%include ImportanceSampling.i
%include PostAnalyticalControlledImportanceSampling.i
%include PostAnalyticalImportanceSampling.i
%include RootStrategyImplementation.i
%include RootStrategy.i
%include SamplingStrategyImplementation.i
%include SamplingStrategy.i
%include DirectionalSampling.i
%include OrthogonalDirection.i
%include RandomDirection.i
%include MediumSafe.i
%include RiskyAndFast.i
%include SafeAndSlow.i
%include QuasiMonteCarlo.i
%include QuasiMonteCarloResult.i
%include LowDiscrepancySequenceImplementation.i
%include LowDiscrepancySequence.i
%include SobolSequence.i


/* Uncertainty/StatTests */
%include VisualTest.i
%include FittingTest.i
%include HypothesisTest.i
%include LinearModelTest.i
%include NormalityTest.i

/* At last we include template definitions */
%include UncertaintyTemplateDefs.i
