// SWIG file NumericalPoint.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-10-15 17:56:07 +0200 (mer. 15 oct. 2008) $
// Id : $Id: NumericalPoint.i 972 2008-10-15 15:56:07Z dutka $

%{
#include "NumericalPoint.hxx"
%}

%rename(NumericalPoint_operator___eq__) OpenTURNS::Base::Type::operator ==(const NumericalPoint & lhs, const NumericalPoint & rhs);

%template(NumericalPointImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Type::NumericalPointImplementation>;
%template(NumericalPointImplementationTypedCollectionInterfaceObject) OpenTURNS::Base::Common::TypedCollectionInterfaceObject<OpenTURNS::Base::Type::NumericalPointImplementation>;
%include NumericalPoint.hxx
namespace OpenTURNS{ namespace Base { namespace Type { %extend NumericalPoint { NumericalPoint(const NumericalPoint & other) { return new OpenTURNS::Base::Type::NumericalPoint(other); } } }}}

%template(NumericalPointCollection)                                    OpenTURNS::Base::Type::Collection<OpenTURNS::Base::Type::NumericalPoint>;
%template(NumericalPointPersistentCollection)                          OpenTURNS::Base::Type::PersistentCollection<OpenTURNS::Base::Type::NumericalPoint>;

namespace OpenTURNS { namespace Base { namespace Type {

%extend NumericalPoint {

NumericalPoint(PyObject * pyObj)
{
 if (!PySequence_Check( pyObj )) {
   throw OT::Base::Common::InvalidArgumentException(HERE) << "Argument is not a sequence object (tuple or list)";
 }

 const OpenTURNS::UnsignedLong size = PySequence_Fast_GET_SIZE( pyObj );
 OpenTURNS::Base::Type::NumericalPointImplementation impl(size, 0.0); 

 for(OpenTURNS::UnsignedLong i=0; i<size; ++i) {
   PyObject * elt = PySequence_Fast_GET_ITEM(pyObj, i);
   if (!PyNumber_Check( elt )) {
     throw OT::Base::Common::InvalidArgumentException(HERE) << "Item " << i << " of sequence is not a number";
   }
   PyObject * pyNum = PyNumber_Float(elt);
   
   impl[i] = PyFloat_AsDouble( pyNum );
   Py_XDECREF( pyNum );
 }
 return new OpenTURNS::Base::Type::NumericalPoint( impl );
}

}

}}}
