//                                               -*- C++ -*-
/**
 *  @file  t_SVMKernel_std.cxx
 *  @brief Test file for all kernels used by support vector machines
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-05 08:50:15 +0200 (lun, 05 mai 2008) $
 *  Id:      $Id: t_SVMKernel_std.cxx 805 2008-05-05 06:50:15Z schueller $
 */

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Collection.hxx"
#include "SVMKernel.hxx"
#include "NormalRBF.hxx"
#include "ExponentialRBF.hxx"
#include "PolynomialKernel.hxx"
#include "RationalKernel.hxx"


using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Algorithm;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    // Create all the kernels
    Collection<SVMKernel> kernelCollection;
    kernelCollection.add(NormalRBF(50.0)); // parameters : sigma
    kernelCollection.add(ExponentialRBF(50.0)); // parameters : sigma
    kernelCollection.add(PolynomialKernel(3.0, 2.0, 1.0)); // parameters : degree, linear, constant
    kernelCollection.add(RationalKernel(1.0)); // parameters : constant
    UnsignedLong numberOfKernel = kernelCollection.getSize();

    UnsignedLong dimension = 6;

    // Create two points
    NumericalPoint x1(dimension);
    x1[0] = 4.0;
    x1[1] = 8.0;
    x1[2] = 15.0;
    x1[3] = 16.0;
    x1[4] = 23.0;
    x1[5] = 42.0;
    NumericalPoint x2(dimension);
    x2[0] = 0.1;
    x2[1] = 0.2;
    x2[2] = 0.3;
    x2[3] = 0.4;
    x2[4] = 0.5;
    x2[5] = 0.6;

    // Stream out the first point
    fullprint << x1 << std::endl;

    // for each kernel
    for(UnsignedLong i = 0; i < numberOfKernel; ++ i)
      {
	// Stream out the kernel
	fullprint << kernelCollection[i] << std::endl;

	// Retrieve the parameters
	NumericalPointWithDescription parameters(kernelCollection[i].getParameters());
	fullprint << "parameters=" << parameters << std::endl;

	// Evaluate the kernel
	NumericalScalar kernelEvaluation = kernelCollection[i](x1, x2);
	NumericalPoint kernelGradient = kernelCollection[i].partialGradient(x1, x2);
	SymmetricMatrix kernelHessian = kernelCollection[i].partialHessian(x1, x2);
	
	// Stream out the result
	fullprint << "evaluation=" << kernelEvaluation << std::endl;
	fullprint << "gradient=" << kernelGradient << std::endl;
	fullprint << "hessian=" << kernelHessian << std::endl;
      }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
