//                                               -*- C++ -*-
/**
 *  @file  t_NumericalSample_split.cxx
 *  @brief The test file of class NumericalSample for split method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_NumericalSample_split.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalSample.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;


class TestObject : public NumericalSample
{
public:
  explicit TestObject() : NumericalSample(1, 1) {}
  explicit TestObject(const String & name) : NumericalSample(1, 1) {setName(name);}
  virtual ~TestObject() {}
};


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    // Test basic functionnalities
    checkClassWithClassName<TestObject>();

    // Test some extra functionnalities
    checkNameFeature<TestObject>();

    // We create an empty NumericalSample
    const int N=100;
    NumericalSample sample(N, 2);
    fullprint << "Sample size=" << sample.getSize() << std::endl;

    // We populate the empty sample with numerous data
    for (int i=0; i<N; i++) {
      NumericalPoint point(2);
      point[0] = 1000 + i;
      point[1] = 2000 + i;
      sample[i] = point;
    }
    fullprint << "sample=" << sample << std::endl;


    // We try to split the sample
    NumericalSample sample90 = sample.split(90);
    NumericalSample sample10 = sample.split(10);
    fullprint << "sample  =" << sample   << std::endl;
    fullprint << "sample10=" << sample10 << std::endl;
    fullprint << "sample90=" << sample90 << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
