//                                               -*- C++ -*-
/**
 *  @file  minimal_wrapper.cxx
 *  @brief This is an example of the smallest definition of a wrapper
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-04-29 14:13:58 +0200 (mer. 29 avril 2009) $
 *  Id:      $Id: minimal_wrapper.cxx 1218 2009-04-29 12:13:58Z dutka $
 */
#include "OTconfig.hxx" // Only needed for test wrappers
#include "WrapperInterface.h"
#include "WrapperCommon.h"
#include "WrapperMacros.h"


/*
 *  This is the declaration of function named 'smallest' into the wrapper.
 */
  

extern "C" {


/*
******************************************************************************************
*                                                                                        *
*                                  smallest function                                     *
*                                                                                        *
******************************************************************************************
*/





  /* The wrapper information informs the NumericalMathFunction object that loads the wrapper of the
   * signatures of the wrapper functions. In particular, it hold the size of the input NumericalPoint
   * (inSize_) and of the output NumericalPoint (outSize_).
   * Those information are also used by the gradient and hessian functions to set the correct size
   * of the returned matrix and tensor.
   */

  struct WrapperInformation Static_information = { /* inSize_  = */ 2,
						   /* outSize_ = */ 1 };


  enum WrapperErrorCode func_getInfo_smallest(void * p_state, struct WrapperInformation * p_info)
  {
    dbg_printEntrance("func_getInfo_smallest");
    dbg_printState("func_getInfo_smallest", p_state);

    *p_info = Static_information;

    dbg_printExit("func_getInfo_smallest");

    return WRAPPER_OK;
  }



  /**
   * Execution function
   * This function is called by the platform to do the real work of the wrapper. It may be
   * called concurrently, so be aware of not using shared or global data not protected by
   * a critical section.
   * This function has a mathematical meaning. It operates on one vector (aka point) and
   * returns another vector.
   */
  enum WrapperErrorCode func_exec_smallest(void * p_state, const struct point * inPoint, struct point * outPoint)
  {
    dbg_printEntrance("func_exec_smallest");
    dbg_printState("func_exec_smallest", p_state);
    dbg_printPoint("func_exec_smallest", inPoint);



    /* The real computation is here */
    double & x1 = inPoint->data_[0];
    double & x2 = inPoint->data_[1];

    double & y  = outPoint->data_[0];

    y = x1*x2 + x1+x2;



    dbg_printPoint("func_exec_smallest", outPoint);
    dbg_printExit("func_exec_smallest");

    return WRAPPER_OK;
  }


} /* end extern "C" */
