//                                               -*- C++ -*-
/**
 *  @file  RandomVectorImplementation.cxx
 *  @brief An interface for all implementation class of random vectors
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: RandomVectorImplementation.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "PersistentObjectFactory.hxx"
#include "RandomVectorImplementation.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(RandomVectorImplementation);

      static Base::Common::Factory<RandomVectorImplementation> RegisteredFactory("RandomVectorImplementation");

      typedef Base::Common::NotYetImplementedException NotYetImplementedException;

      /* Default constructor */
      RandomVectorImplementation::RandomVectorImplementation(const String & name)
	: PersistentObject(name),
	  description_()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Virtual constructor */
      RandomVectorImplementation * RandomVectorImplementation::clone() const
      {
	return new RandomVectorImplementation(*this);
      }

      /* String converter */
      String RandomVectorImplementation::__repr__() const {
	OSS oss;
	oss << "class=" << RandomVectorImplementation::GetClassName();
	return oss;
      }
  


      /* Description accessor */
      void RandomVectorImplementation::setDescription(const Description & description)
      {
	description_ = description;
      }

      RandomVectorImplementation::Description RandomVectorImplementation::getDescription() const
      {
	return description_;
      }


      /* Here is the interface that all derived class must implement */


      /* Is the underlying random vector composite ? */
      Bool RandomVectorImplementation::isComposite() const
      {
	return false;
      }

      /* Dimension accessor */
      UnsignedLong RandomVectorImplementation::getDimension() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Realization accessor */
      RandomVectorImplementation::NumericalPoint RandomVectorImplementation::getRealization() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Numerical sample accessor */
      RandomVectorImplementation::NumericalSample RandomVectorImplementation::getNumericalSample(const UnsignedLong size) const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Mean accessor */
      RandomVectorImplementation::NumericalPoint RandomVectorImplementation::getMean() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Covariance accessor */
      RandomVectorImplementation::CovarianceMatrix RandomVectorImplementation::getCovariance() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Get the random vector corresponding to the i-th marginal component */
      RandomVectorImplementation::Implementation RandomVectorImplementation::getMarginal(const UnsignedLong i) const throw(InvalidArgumentException)
      {
	throw NotYetImplementedException(HERE);
      }

      /* Get the marginal random vector corresponding to indices components */
      RandomVectorImplementation::Implementation RandomVectorImplementation::getMarginal(const Indices & indices) const throw(InvalidArgumentException)
      {
	throw NotYetImplementedException(HERE);
      }

      /* Fake method due to pbs with dynamic_cast and Pointer */
      RandomVectorImplementation::Antecedent RandomVectorImplementation::getAntecedent() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Fake method due to pbs with dynamic_cast and Pointer */
      RandomVectorImplementation::NumericalMathFunction RandomVectorImplementation::getFunction() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Fake method due to pbs with dynamic_cast and Pointer */
      Distribution RandomVectorImplementation::getDistribution() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Fake method due to pbs with dynamic_cast and Pointer */
      RandomVectorImplementation::ComparisonOperator RandomVectorImplementation::getOperator() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Fake method due to pbs with dynamic_cast and Pointer */
      NumericalScalar RandomVectorImplementation::getThreshold() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Method save() stores the object through the StorageManager */
      void RandomVectorImplementation::save(const StorageManager::Advocate & adv) const
      {
	PersistentObject::save(adv);
	adv.writeValue(description_, StorageManager::MemberNameAttribute, "description_");
      }

      /* Method load() reloads the object from the StorageManager */
      void RandomVectorImplementation::load(const StorageManager::Advocate & adv)
      {
	PersistentObject::load(adv);
	adv.readValue(description_, StorageManager::MemberNameAttribute, "description_");
      }

    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
