//                                               -*- C++ -*-
/**
 *  @file  DistributionImplementationFactory.hxx
 *  @brief Top-level class for all distribution factories
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: DistributionImplementationFactory.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX
#define OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX

#include "DistributionImplementation.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Exception.hxx"
#include "PersistentObject.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      /**
       * @class DistributionImplementationFactory
       */
      class DistributionImplementationFactory
	: public Base::Common::PersistentObject
      {
	CLASSNAME;
      public:

	typedef Base::Type::NumericalPoint                                  NumericalPoint;
	typedef Base::Stat::NumericalSample                                 NumericalSample;
	typedef Base::Common::InternalException                             InternalException;
	typedef Base::Common::InvalidArgumentException                      InvalidArgumentException;
	typedef Model::DistributionImplementation::NumericalPointCollection NumericalPointCollection;

	/** Default constructor */
	DistributionImplementationFactory(const String & name = OT::DefaultName);

	/** Virtual constructor */
	virtual DistributionImplementationFactory * clone() const;

	/** String converter */
	virtual String __repr__() const;

	/* Here is the interface that all derived class must implement */

	virtual DistributionImplementation * buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException);
	virtual DistributionImplementation * buildImplementation(const NumericalPointCollection & parameters) const throw(InvalidArgumentException, InternalException);
	virtual DistributionImplementation * buildImplementation() const throw(InvalidArgumentException, InternalException);

      protected:
	/** Execute a R script */
	virtual NumericalPoint runRFactory(const NumericalSample & sample,
					   const DistributionImplementation & distribution) const
	  throw(InvalidArgumentException, InternalException);

      private:    

      }; /* class DistributionImplementationFactory */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX */
