//                                               -*- C++ -*-
/**
 *  @file  Tvpack.hxx
 *  @brief This file includes all of the tvpack functions used in the platform
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-04-30 12:04:13 +0200 (jeu. 30 avril 2009) $
 *  Id:      $Id: Tvpack.hxx 1219 2009-04-30 10:04:13Z dutka $
 */
#ifndef OPENTURNS_TVPACK_HXX
#define OPENTURNS_TVPACK_HXX

#include "OTprivate.hxx"

extern "C"
{
  /** Function that evaluates 2-dimensional normal and student CDF. Nu=0 for normal CDF */
#define BVTL_F77 F77_FUNC(bvtl,BVTL)
  double BVTL_F77(int *nu, double *dh, double *dk, double *r);
  /** Function that evaluates 3-dimensional normal and student CDF. Nu=0 for normal CDF */
#define TVTL_F77 F77_FUNC(tvtl,TVTL)
  double TVTL_F77(int *nu, double *h, double *r, double *epsi);
}

#endif /* OPENTURNS_TVPACK_HXX */
