//                                               -*- C++ -*-
/**
 *  @file  ChiSquareFactory.cxx
 *  @brief Factory for ChiSquare distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu. 10 mai 2007) $
 *  Id:      $Id: ChiSquareFactory.cxx 434 2007-05-10 14:43:31Z dutka $
 */
#include "ChiSquareFactory.hxx"
#include "ChiSquare.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /* Default constructor */
      ChiSquareFactory::ChiSquareFactory()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Virtual constructor */
      ChiSquareFactory * ChiSquareFactory::clone() const
      {
	return new ChiSquareFactory(*this);
      }


      /* Here is the interface that all derived class must implement */

      ChiSquareFactory::DistributionImplementation * ChiSquareFactory::buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException)
      {
	if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a ChiSquare distribution from an empty sample";
	if (sample.getDimension() != 1) throw InvalidArgumentException(HERE) << "Error: can build a ChiSquare distribution only from a sample of dimension 1, here dimension=" << sample.getDimension();
	const NumericalScalar mean(sample.computeMean()[0]);
	return ChiSquare(mean).clone();
      }

      ChiSquareFactory::DistributionImplementation * ChiSquareFactory::buildImplementation(const NumericalPointCollection & parameters) const throw(InvalidArgumentException, InternalException)
      {
	try {
	  ChiSquare distribution;
	  distribution.setParametersCollection(parameters);
	  return distribution.clone();
	}
	catch (InvalidArgumentException & ex)
	  {
	    throw InternalException(HERE) << "Error: cannot build a ChiSquare distribution from the given parameters";
	  }
      }

      ChiSquareFactory::DistributionImplementation * ChiSquareFactory::buildImplementation() const throw(InvalidArgumentException, InternalException)
      {
	return ChiSquare().clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
