//                                               -*- C++ -*-
/**
 *  @file  MonteCarlo.cxx
 *  @brief MonteCarlo is an implementation of the hit or miss Monte Carlo simulation method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: MonteCarlo.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "MonteCarlo.hxx"
#include "ComparisonOperatorImplementation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /*
       * @class MonteCarlo
       */

      CLASSNAMEINIT(MonteCarlo);

      /* Constructor with parameters */
      MonteCarlo::MonteCarlo(const Simulation::Event & event):
	Simulation(event)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      MonteCarlo * MonteCarlo::clone() const
      {
	return new MonteCarlo(*this);
      }

      /* Compute the block sample */
      MonteCarlo::NumericalSample MonteCarlo::computeBlockSample()
      {
	NumericalSample inputSample(event_.getImplementation()->getAntecedent()->getDistribution().getNumericalSample(blockSize_));
	NumericalSample blockSample(event_.getImplementation()->getFunction()(inputSample));
	for (UnsignedLong i = 0; i < blockSize_; ++i)
	  {
	    inputStrategy_.store(inputSample[i]);
	    outputStrategy_.store(blockSample[i]);
	    blockSample[i][0] = getEvent().getOperator()(blockSample[i][0], event_.getThreshold());
	  }
	return blockSample;
      }

      /* String converter */
      String MonteCarlo::__repr__() const
      {
	OSS oss;
	oss << "class=" << MonteCarlo::GetClassName()
	    << " derived from " << Simulation::__repr__();
	return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
