//                                               -*- C++ -*-
/**
 *  @file  LegendreFactory.hxx
 *  @brief Legendre polynomial factory
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_LEGENDREFACTORY_HXX
#define OPENTURNS_LEGENDREFACTORY_HXX

#include "OrthogonalUniVariatePolynomialFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class LegendreFactory
       *
       * Legendre polynomial factory
       */

      class LegendreFactory
	: public OrthogonalUniVariatePolynomialFactory
      {
	CLASSNAME;
      public:

	/** Default constructor */
	LegendreFactory();

	/** Virtual constructor */
	LegendreFactory * clone() const;

	/** Determine the coefficients of the first orthogonal Legendre Polynomial (degree = 0) of the family*/
	Coefficients getP0Coefficients() const ;	

	/** Determine the coefficients of the second orthogonal Legendre Polynomial (degree = 1) of the family*/
	Coefficients getP1Coefficients() const ;

	/** Calculate the coefficients of recurrence a0, a1, a2 such that
	    Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
	Coefficients getRecurrenceCoefficients(const UnsignedLong n) const;

	/** String converter */
	String __repr__() const;

      private:

      } ; /* class LegendreFactory */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LEGENDREFACTORY_HXX */
