//                                               -*- C++ -*-
/**
 *  @file  ProjectionStrategy.cxx
 *  @brief This is the interface class for projection strategies
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "ProjectionStrategy.hxx"
#include "OSS.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(ProjectionStrategy);

      /* Default constructor */
      ProjectionStrategy::ProjectionStrategy()
	: Base::Common::TypedInterfaceObject<ProjectionStrategyImplementation>(new ProjectionStrategyImplementation)
      {
	// Nothing to do
      }

      
      /* Parameter constructor */
      ProjectionStrategy::ProjectionStrategy(const Distribution & measure)
	: Base::Common::TypedInterfaceObject<ProjectionStrategyImplementation>(new ProjectionStrategyImplementation(measure))
      {
	// Nothing to do
      }

      
      /* Constructor from implementation */
      ProjectionStrategy::ProjectionStrategy(const ProjectionStrategyImplementation & implementation)
	: Base::Common::TypedInterfaceObject<ProjectionStrategyImplementation>(implementation.clone())
      {
	// Nothing to do
      }


      /* Measure accessor */
      void ProjectionStrategy::setMeasure(const Distribution & measure)
      {
	getImplementation()->setMeasure(measure);
      }

      ProjectionStrategy::Distribution ProjectionStrategy::getMeasure() const
      {
	return getImplementation()->getMeasure();
      }


      /* Compute the components alpha_k_p_ by projecting the model on the partial L2 basis */
      void ProjectionStrategy::computeCoefficients(const NumericalMathFunction & function,
						   const NumericalMathFunctionCollection & partialBasis,
						   const Indices & indices,
						   const Indices & addedIndices,
						   const Indices & removedIndices)
      {
	getImplementation()->computeCoefficients(function, partialBasis, indices, addedIndices, removedIndices);
      }


      /* String converter */
      String ProjectionStrategy::__repr__() const
      {
	return OSS() << "class=" << getClassName()
      		     << " implementation=" << getImplementation()->__repr__();
      }



    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
