//                                               -*- C++ -*-
/**
 *  @file  NatafEllipticalDistributionGradient.cxx
 *  @brief Class for the Nataf transformation gradient for elliptical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: NatafEllipticalDistributionGradient.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "OTprivate.hxx"
#include "NatafEllipticalDistributionGradient.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /*
       * @class NatafEllipticalDistributionGradient
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */

      CLASSNAMEINIT(NatafEllipticalDistributionGradient);

      /* Parameter constructor */
      NatafEllipticalDistributionGradient::NatafEllipticalDistributionGradient(const SquareMatrix & inverseCholesky):
	ConstantNumericalMathGradientImplementation(inverseCholesky.transpose())
      {
	// Nothing to do
      }

      /* String converter */
      String NatafEllipticalDistributionGradient::__repr__() const
      {
	return OSS() << "class=" << NatafEllipticalDistributionGradient::GetClassName()
		     << " inverseCholesky=" << getConstant().transpose();
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
