//                                               -*- C++ -*-
/**
 *  @file  Indices.hxx
 *  @brief Set of indices defined as a Collection of UnsignedLong class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-04-08 18:07:10 +0200 (mer. 08 avril 2009) $
 *  Id:      $Id: Indices.hxx 1211 2009-04-08 16:07:10Z dutka $
 */
#ifndef OPENTURNS_INDICES_HXX
#define OPENTURNS_INDICES_HXX

#include "OTprivate.hxx"
#include "PersistentCollection.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Type {

      /**
       * @class Indices
       *
       * A class that holds a collection of indices
       */
      class Indices :
	public PersistentCollection<UnsignedLong>
      {
      public:
	typedef PersistentCollection<UnsignedLong>             InternalType;
	typedef InternalType::iterator               iterator;
	typedef InternalType::const_iterator         const_iterator;
	typedef InternalType::reverse_iterator       reverse_iterator;
	typedef InternalType::const_reverse_iterator const_reverse_iterator;

	/** Default constructor */
	Indices() : InternalType()
	{
	  // Nothing to do
	}
      
	/** Constructor that pre-allocate size elements */
	explicit Indices(const UnsignedLong size) : InternalType(size)
	{
	  // Nothing to do
	}

	/** Constructor that pre-allocate size elements with value */
	Indices(const UnsignedLong size,
		const UnsignedLong value) : InternalType(size, value)
	{
	  // Nothing to do
	}

	/** Constructor from a range of elements */
	template <typename InputIterator>
	Indices(const InputIterator first,
		const InputIterator last) : InternalType(first, last)
	{
	  // Nothing to do
	}

	/** Check that no value is repeated and no value exceed the given bound */
	Bool check(const UnsignedLong bound) const;

      }; /* class Indices */

    } /* Namespace Type */
  } /* Namespace Base */
} /* Namespace OpenTURNS */

#endif /* OPENTURNS_INDICES_HXX */
