//                                               -*- C++ -*-
/**
 *  @file  LowDiscrepancySequenceImplementation.hxx
 *  @brief This class is a top-level class for low discrepancy sequences
 *  simulation algorithms. It delegates to its children the effective
 *  history strategy.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */
#ifndef OPENTURNS_LOWDISCREPANCYSEQUENCEIMPLEMENTATION_HXX
#define OPENTURNS_LOWDISCREPANCYSEQUENCEIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {
      /**
       * @class LowDiscrepancySequenceImplementation
       */

      class LowDiscrepancySequenceImplementation
	: public Base::Common::PersistentObject
      {

	CLASSNAME;

      public:

	typedef Type::NumericalPoint NumericalPoint;

	/** Default constructor */
	explicit LowDiscrepancySequenceImplementation();

	/** Constructor with parameters */
	explicit LowDiscrepancySequenceImplementation(const UnsignedLong dimension);

	/** Virtual constructor */
	virtual LowDiscrepancySequenceImplementation * clone() const;

	/** initialize the sequence */
	virtual void initialize(const UnsignedLong dimension);

	/** Has the sequence been initialized ? */
	Bool isInitialized() const;

	/** Dimension accessor */
	UnsignedLong getDimension() const;

	/** Generate a quasi-random vector of numbers uniformly distributed over [0, 1) */
	virtual NumericalPoint generate();

	/** Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1) */
	virtual	NumericalSample generate(const UnsignedLong size);

	/** Compute the star discrepancy of a sample uniformly distributed over [0, 1) */
	static NumericalScalar ComputeStarDiscrepancy(const NumericalSample & sample);

	/** String converter */
	virtual String __repr__() const;

      private:
	/** Compute the local discrepancy of a sample, given a multidimensionnal interval */
	static NumericalScalar ComputeLocalDiscrepancy(const NumericalSample & sample,
						       const NumericalPoint & interval);

      protected:
	/** Initialization flag */
	Bool isInitialized_;

	/** Dimension parameter */
	UnsignedLong dimension_;

      } ; /* class LowDiscrepancySequenceImplementation */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LOWDISCREPANCYSEQUENCEIMPLEMENTATION_HXX */
