//                                               -*- C++ -*-
/**
 *  @file  Cobyla.hxx
 *  @brief Cobyla is an actual implementation for
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Cobyla.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_COBYLA_HXX
#define OPENTURNS_COBYLA_HXX

#include "OTprivate.hxx"
#include "NearestPointAlgorithmImplementation.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      /**
       * @class cobyla
       * cobyla is an actual implementation for
       * NearestPointAlgorithm using the cobyla library
       */
      class Cobyla :
	public NearestPointAlgorithmImplementation
      {
	CLASSNAME;
      public:

	typedef NearestPointAlgorithmImplementation::NumericalMathFunction NumericalMathFunction;
	typedef NearestPointAlgorithmImplementation::InternalException     InternalException;

#ifndef SWIG
	/**
	 * @class SpecificParameters
	 * Specific parameters of the cobyla library
	 */
	class SpecificParameters
	  : public Common::PersistentObject
	{
	  static const NumericalScalar DefaultRhoBeg;

	  CLASSNAME;
	public:
	  /** Default constructor */
	  SpecificParameters();

	  /** Parameters constructor */
	  SpecificParameters(const NumericalScalar rhoBeg);

	  /** Virtual constructor */
	  virtual SpecificParameters * clone() const;

	  /** RhoBeg accessor */
	  NumericalScalar getRhoBeg() const;

	  /** RhoBeg accessor */
	  void setRhoBeg(const NumericalScalar rhoBeg);

	  /** String converter */
	  String __repr__() const;

	private:

	  NumericalScalar rhoBeg_;
	}; /* class SpecificParameters */
#else
	typedef OT::Base::Optim::CobylaSpecificParameters SpecificParameters;
#endif

	/** Default constructor */
	Cobyla();

	/** Constructor with parameters */
	Cobyla(const NumericalMathFunction & levelFunction,
	       const Bool verbose = false);


	/** Constructor with parameters */
	Cobyla(const SpecificParameters & specificParameters,
	       const NumericalMathFunction & levelFunction,
	       const Bool verbose = false);


	/** Virtual constructor */
	virtual Cobyla * clone() const;

	/** Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
	void run()
	  throw(InternalException);

	/** Specific parameters accessor */
	SpecificParameters getSpecificParameters() const;

	/** Specific parameters accessor */
	void setSpecificParameters(const SpecificParameters & specificParameters);
	/** String converter */
	String __repr__() const;

      private:

	/**
	 * Function that computes half of the squared of a Vector. It will
	 * become the objective function of the minimisation problem
	 */
	static int ObjectiveAndConstraint(int n, int m, double *x, double *f, double *con, void *state);
	SpecificParameters specificParameters_;
      }; /* class Cobyla */

      typedef OpenTURNS::Base::Optim::Cobyla::SpecificParameters  CobylaSpecificParameters;

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COBYLA_HXX */
