//                                               -*- C++ -*-
/**
 *  @file  OTFunc.hxx
 *  @brief The external header file of Open TURNS for subdir Func
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009) $
 *  Id:      $Id: OTFunc.hxx 1129 2009-02-11 15:49:59Z dutka $
 */

#ifndef OPENTURNS_OTFUNC_HXX
#define OPENTURNS_OTFUNC_HXX

#include "AnalyticalNumericalMathEvaluationImplementation.hxx"
#include "ComposedNumericalMathEvaluationImplementation.hxx"
#include "ComposedNumericalMathFunction.hxx"
#include "ComposedNumericalMathGradientImplementation.hxx"
#include "ComposedNumericalMathHessianImplementation.hxx"
#include "ComputedNumericalMathEvaluationImplementation.hxx"
#include "ComputedNumericalMathEvaluationImplementationFactory.hxx"
#include "ComputedNumericalMathGradientImplementation.hxx"
#include "ComputedNumericalMathGradientImplementationFactory.hxx"
#include "ComputedNumericalMathHessianImplementation.hxx"
#include "ComputedNumericalMathHessianImplementationFactory.hxx"
#include "ConstantNumericalMathGradientImplementation.hxx"
#include "ConstantNumericalMathHessianImplementation.hxx"
#include "IndicatorNumericalMathEvaluationImplementation.hxx"
#include "Library.hxx"
#include "LibraryLoader.hxx"
#include "LinearCombinationEvaluationImplementation.hxx"
#include "LinearCombinationGradientImplementation.hxx"
#include "LinearCombinationHessianImplementation.hxx"
#include "LinearNumericalMathEvaluationImplementation.hxx"
#include "LinearNumericalMathFunction.hxx"
#include "LinearNumericalMathGradientImplementation.hxx"
#include "MethodBoundNumericalMathEvaluationImplementation.hxx"
#include "NoNumericalMathEvaluationImplementation.hxx"
#include "NoNumericalMathGradientImplementation.hxx"
#include "NoNumericalMathHessianImplementation.hxx"
#include "NumericalMathEvaluationImplementation.hxx"
#include "NumericalMathEvaluationImplementationFactory.hxx"
#include "NumericalMathFunction.hxx"
#include "NumericalMathFunctionImplementation.hxx"
#include "NumericalMathGradientImplementation.hxx"
#include "NumericalMathGradientImplementationFactory.hxx"
#include "NumericalMathHessianImplementation.hxx"
#include "NumericalMathHessianImplementationFactory.hxx"
#include "ProductNumericalMathEvaluationImplementation.hxx"
#include "ProductNumericalMathFunction.hxx"
#include "ProductNumericalMathGradientImplementation.hxx"
#include "ProductNumericalMathHessianImplementation.hxx"
#include "ProductPolynomialEvaluationImplementation.hxx"
#include "QuadraticNumericalMathEvaluationImplementation.hxx"
#include "UniVariatePolynomial.hxx"
#include "WrapperData.hxx"
#include "WrapperFile.hxx"
#include "WrapperObject.hxx"
#include "XMLTags.hxx"
#include "OTMuParser.hxx"

#endif /* OPENTURNS_OTFUNC_HXX */
