//                                               -*- C++ -*-
/**
 *  @file  Catalog.hxx
 *  @brief Catalog records all the factories into a dictionnary
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-12 14:29:13 +0100 (jeu. 12 févr. 2009) $
 *  Id:      $Id: Catalog.hxx 1132 2009-02-12 13:29:13Z dutka $
 */
#ifndef OPENTURNS_CATALOG_HXX
#define OPENTURNS_CATALOG_HXX

#include <map>         // for std::map
#include "OTprivate.hxx"
#include "PersistentObjectFactory.hxx"


namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /** Forward declaration */
      class PersistentObjectFactory;

      /**
       * @class Catalog
       *
       * Catalog records all user information to a file or tty
       */

      class Catalog
      {
	friend class PersistentObjectFactory;

      public:

	/** Return the catalog as a singleton */
	static Catalog & GetInstance();

      private:
	static Catalog * P_instance_;
	static void Release();


      public:

	/** Destructor */
	~Catalog();

	/** Get the factory from its name */
	const PersistentObjectFactory & get(const String & factoryName) const;

      private:

	typedef std::map<String, const PersistentObjectFactory *> CatalogType;

	/** The dictionnary of factories */
	CatalogType catalog_;

	/** Default constructor is private so Catalog can not be instanciated */
	Catalog();

	/** Add a new factory to the catalog */
	void add(const String & factoryName, const PersistentObjectFactory * p_factory);

      }; /* end class Catalog */



    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CATALOG_HXX */
