#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#   This file is part of OpenTeacher.
#
#   OpenTeacher is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; version 3 of the License.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

from distutils.core import setup
from distutils.core import Command
import os
import subprocess

def main():
    setup(
        version = "2.0",
        name = "openteacher", # lower case name needed
        description = "Learn words in a foreign language.",
        author = "OpenTeacher Maintainers",
        author_email = "openteachermaintainers@milanboers.nl",
        url = "http://openteacher.sourceforge.net/",
        package_dir = {"openteacher": "src"},
        packages = ["openteacher", "openteacher.api", "openteacher.gui"],
        license='GNU GPL',
        scripts=['bin/openteacher'],
        classifiers=["Development Status :: 5 - Production/Stable", 
            "Intended Audience :: End Users/Desktop",
            "License :: OSI Approved :: GNU General Public License (GPL)",
            "Operating System :: POSIX :: Linux"],
            # a bunch of optional tags, a list of classifiers can be found at http://pypi.python.org/pypi?:action=list_classifiers
        cmdclass={"update":update},
        long_description="""OpenTeacher is an opensource application that helps you learning a foreign language!

Enter a list of words in both a known and a foreign language, and OpenTeacher tests you.

OpenTeacher 2.0 has the following features:
* Smart question asking
* Think answer, shuffle answer and repeat answer input modes
* Easy symbol and Greek input
* Read and write T2K (Teach2000) and wrts files
* Save and open your online WRTS lists
* Support for synonyms
* Printing your word lists
* Available in English, Spanish, German, Dutch and Hungarian
"""
    )

class update(Command):
    description = "Update translation files (*.po, *.ts and *.qm) as well as resource files (*.py) specific to this project"
    user_options = []
    
    def initialize_options(self): pass
    
    def finalize_options(self): pass
    
    def run(self):
        self.execute(subprocess.check_call, [["./compile_all.py"]])


if __name__ == "__main__":
    main()
