/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class GradientBackground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &GradientBackgroundBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 GradientBackgroundBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
GradientBackgroundPtr GradientBackgroundBase::create(void) 
{
    GradientBackgroundPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = GradientBackgroundPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
GradientBackgroundPtr GradientBackgroundBase::createEmpty(void) 
{ 
    GradientBackgroundPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the GradientBackground::_mfColor field.
inline
MFColor3f *GradientBackgroundBase::getMFColor(void)
{
    return &_mfColor;
}

//! Get the GradientBackground::_mfPosition field.
inline
MFReal32 *GradientBackgroundBase::getMFPosition(void)
{
    return &_mfPosition;
}

//! Get the GradientBackground::_sfClearStencilBit field.
inline
SFInt32 *GradientBackgroundBase::getSFClearStencilBit(void)
{
    return &_sfClearStencilBit;
}


//! Get the value of the GradientBackground::_sfClearStencilBit field.
inline
Int32 &GradientBackgroundBase::getClearStencilBit(void)
{
    return _sfClearStencilBit.getValue();
}

//! Get the value of the GradientBackground::_sfClearStencilBit field.
inline
const Int32 &GradientBackgroundBase::getClearStencilBit(void) const
{
    return _sfClearStencilBit.getValue();
}

//! Set the value of the GradientBackground::_sfClearStencilBit field.
inline
void GradientBackgroundBase::setClearStencilBit(const Int32 &value)
{
    _sfClearStencilBit.setValue(value);
}


//! Get the value of the \a index element the GradientBackground::_mfColor field.
inline
Color3f &GradientBackgroundBase::getColor(const UInt32 index)
{
    return _mfColor[index];
}

//! Get the GradientBackground::_mfColor field.
inline
MFColor3f &GradientBackgroundBase::getColor(void)
{
    return _mfColor;
}

//! Get the GradientBackground::_mfColor field.
inline
const MFColor3f &GradientBackgroundBase::getColor(void) const
{
    return _mfColor;
}

//! Get the value of the \a index element the GradientBackground::_mfPosition field.
inline
Real32 &GradientBackgroundBase::getPosition(const UInt32 index)
{
    return _mfPosition[index];
}

//! Get the GradientBackground::_mfPosition field.
inline
MFReal32 &GradientBackgroundBase::getPosition(void)
{
    return _mfPosition;
}

//! Get the GradientBackground::_mfPosition field.
inline
const MFReal32 &GradientBackgroundBase::getPosition(void) const
{
    return _mfPosition;
}

OSG_END_NAMESPACE

#define OSGGRADIENTBACKGROUNDBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

