/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DepthClearBackground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEDEPTHCLEARBACKGROUNDINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGDepthClearBackgroundBase.h"
#include "OSGDepthClearBackground.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  DepthClearBackgroundBase::ClearDepthFieldMask = 
    (TypeTraits<BitVector>::One << DepthClearBackgroundBase::ClearDepthFieldId);

const OSG::BitVector  DepthClearBackgroundBase::DepthFieldMask = 
    (TypeTraits<BitVector>::One << DepthClearBackgroundBase::DepthFieldId);

const OSG::BitVector  DepthClearBackgroundBase::ClearStencilBitFieldMask = 
    (TypeTraits<BitVector>::One << DepthClearBackgroundBase::ClearStencilBitFieldId);

const OSG::BitVector DepthClearBackgroundBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var bool            DepthClearBackgroundBase::_sfClearDepth
    If true, depth buffer is cleared.
*/
/*! \var Real32          DepthClearBackgroundBase::_sfDepth
    Depth value for clear, defaults to 1.
*/
/*! \var Int32           DepthClearBackgroundBase::_sfClearStencilBit
    Usually 0 is used to clear all stencil bitplanes (clear is deactivated if smaller zero).
*/

//! DepthClearBackground description

FieldDescription *DepthClearBackgroundBase::_desc[] = 
{
    new FieldDescription(SFBool::getClassType(), 
                     "clearDepth", 
                     ClearDepthFieldId, ClearDepthFieldMask,
                     false,
                     (FieldAccessMethod) &DepthClearBackgroundBase::getSFClearDepth),
    new FieldDescription(SFReal32::getClassType(), 
                     "depth", 
                     DepthFieldId, DepthFieldMask,
                     false,
                     (FieldAccessMethod) &DepthClearBackgroundBase::getSFDepth),
    new FieldDescription(SFInt32::getClassType(), 
                     "clearStencilBit", 
                     ClearStencilBitFieldId, ClearStencilBitFieldMask,
                     false,
                     (FieldAccessMethod) &DepthClearBackgroundBase::getSFClearStencilBit)
};


FieldContainerType DepthClearBackgroundBase::_type(
    "DepthClearBackground",
    "Background",
    NULL,
    (PrototypeCreateF) &DepthClearBackgroundBase::createEmpty,
    DepthClearBackground::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(DepthClearBackgroundBase, DepthClearBackgroundPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &DepthClearBackgroundBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &DepthClearBackgroundBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr DepthClearBackgroundBase::shallowCopy(void) const 
{ 
    DepthClearBackgroundPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const DepthClearBackground *>(this)); 

    return returnValue; 
}

UInt32 DepthClearBackgroundBase::getContainerSize(void) const 
{ 
    return sizeof(DepthClearBackground); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void DepthClearBackgroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((DepthClearBackgroundBase *) &other, whichField);
}
#else
void DepthClearBackgroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((DepthClearBackgroundBase *) &other, whichField, sInfo);
}
void DepthClearBackgroundBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void DepthClearBackgroundBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

DepthClearBackgroundBase::DepthClearBackgroundBase(void) :
    _sfClearDepth             (bool(true)), 
    _sfDepth                  (Real32(1.f)), 
    _sfClearStencilBit        (Int32(-1)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

DepthClearBackgroundBase::DepthClearBackgroundBase(const DepthClearBackgroundBase &source) :
    _sfClearDepth             (source._sfClearDepth             ), 
    _sfDepth                  (source._sfDepth                  ), 
    _sfClearStencilBit        (source._sfClearStencilBit        ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

DepthClearBackgroundBase::~DepthClearBackgroundBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 DepthClearBackgroundBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ClearDepthFieldMask & whichField))
    {
        returnValue += _sfClearDepth.getBinSize();
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        returnValue += _sfDepth.getBinSize();
    }

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
    {
        returnValue += _sfClearStencilBit.getBinSize();
    }


    return returnValue;
}

void DepthClearBackgroundBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ClearDepthFieldMask & whichField))
    {
        _sfClearDepth.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        _sfDepth.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
    {
        _sfClearStencilBit.copyToBin(pMem);
    }


}

void DepthClearBackgroundBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ClearDepthFieldMask & whichField))
    {
        _sfClearDepth.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DepthFieldMask & whichField))
    {
        _sfDepth.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
    {
        _sfClearStencilBit.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void DepthClearBackgroundBase::executeSyncImpl(      DepthClearBackgroundBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ClearDepthFieldMask & whichField))
        _sfClearDepth.syncWith(pOther->_sfClearDepth);

    if(FieldBits::NoField != (DepthFieldMask & whichField))
        _sfDepth.syncWith(pOther->_sfDepth);

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
        _sfClearStencilBit.syncWith(pOther->_sfClearStencilBit);


}
#else
void DepthClearBackgroundBase::executeSyncImpl(      DepthClearBackgroundBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ClearDepthFieldMask & whichField))
        _sfClearDepth.syncWith(pOther->_sfClearDepth);

    if(FieldBits::NoField != (DepthFieldMask & whichField))
        _sfDepth.syncWith(pOther->_sfDepth);

    if(FieldBits::NoField != (ClearStencilBitFieldMask & whichField))
        _sfClearStencilBit.syncWith(pOther->_sfClearStencilBit);



}

void DepthClearBackgroundBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<DepthClearBackgroundPtr>::_type("DepthClearBackgroundPtr", "BackgroundPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(DepthClearBackgroundPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGDepthClearBackgroundBase.cpp,v 1.9 2007/05/10 15:57:22 yjung Exp $";
    static Char8 cvsid_hpp       [] = OSGDEPTHCLEARBACKGROUNDBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGDEPTHCLEARBACKGROUNDBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGDEPTHCLEARBACKGROUNDFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

