/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include "OSGStatisticsDefaultFont.h"
#include <OSGBaseFunctions.h>
#include <OSGTextTXFFace.h>
#include <iostream>
#ifdef OSG_HAS_SSTREAM
#include <sstream>
#else
#include <strstream>
#endif


OSG_BEGIN_NAMESPACE

// The parameters used to create this TXF font (on Windows XP) are:
// Family: Bitstream Vera Sans Mono
// Style: Plain
// Size: 15
// Gap: 1
// TextureSize: 128x64

/*
Bitstream Vera Fonts Copyright

The fonts have a generous copyright, allowing derivative works (as long as
"Bitstream" or "Vera" are not in the names), and full redistribution (so long
as they are not *sold* by themselves). They can be be bundled, redistributed
and sold with any software. 

The fonts are distributed under the following copyright: 

Copyright

Copyright (c) 2003 by Bitstream, Inc. All Rights Reserved. Bitstream Vera is a
trademark of Bitstream, Inc. 

Permission is hereby granted, free of charge, to any person obtaining a copy of
the fonts accompanying this license ("Fonts") and associated documentation
files (the "Font Software"), to reproduce and distribute the Font Software,
including without limitation the rights to use, copy, merge, publish,
distribute, and/or sell copies of the Font Software, and to permit persons to
whom the Font Software is furnished to do so, subject to the following
conditions: 

The above copyright and trademark notices and this permission notice shall be
included in all copies of one or more of the Font Software typefaces.

The Font Software may be modified, altered, or added to, and in particular the
designs of glyphs or characters in the Fonts may be modified and additional
glyphs or characters may be added to the Fonts, only if the fonts are renamed
to names not containing either the words "Bitstream" or the word "Vera".

This License becomes null and void to the extent applicable to Fonts or Font
Software that has been modified and is distributed under the "Bitstream Vera"
names. 

The Font Software may be sold as part of a larger software package but no copy
of one or more of the Font Software typefaces may be sold by itself. 

THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF COPYRIGHT, PATENT,
TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL BITSTREAM OR THE GNOME FOUNDATION
BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, INCLUDING ANY GENERAL,
SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF THE USE OR INABILITY TO
USE THE FONT SOFTWARE OR FROM OTHER DEALINGS IN THE FONT SOFTWARE. 

Except as contained in this notice, the names of Gnome, the Gnome Foundation,
and Bitstream Inc., shall not be used in advertising or otherwise to promote
the sale, use or other dealings in this Font Software without prior written
authorization from the Gnome Foundation or Bitstream Inc., respectively. For
further information, contact: fonts at gnome dot org. 
*/

UInt32 StatisticsDefaultFontDataSize = 9364;

UChar8 StatisticsDefaultFontData[9364] = {
#ifndef OSG_DO_DOC
    255, 116, 120, 102, 18, 52, 86, 120, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 64,
    0, 0, 0, 12, 255, 255, 255, 253, 0, 0, 0, 95, 0, 32, 1, 1, 0, 255, 8, 0,
    0, 126, 0, 27, 0, 33, 1, 9, 3, 0, 8, 0, 0, 32, 0, 16, 0, 34, 3, 4,
    2, 5, 8, 0, 0, 97, 0, 47, 0, 35, 8, 10, 0, 0, 8, 0, 0, 1, 0, 16,
    0, 36, 7, 11, 1, 254, 8, 0, 0, 36, 0, 1, 0, 37, 8, 9, 0, 0, 8, 0,
    0, 34, 0, 16, 0, 38, 7, 9, 1, 0, 8, 0, 0, 43, 0, 16, 0, 39, 1, 4,
    3, 5, 8, 0, 0, 126, 0, 16, 0, 40, 3, 12, 3, 255, 8, 0, 0, 8, 0, 1,
    0, 41, 3, 12, 2, 255, 8, 0, 0, 12, 0, 1, 0, 42, 7, 6, 1, 3, 8, 0,
    0, 73, 0, 47, 0, 43, 7, 7, 0, 1, 8, 0, 0, 98, 0, 37, 0, 44, 3, 4,
    2, 254, 8, 0, 0, 101, 0, 47, 0, 45, 3, 1, 2, 3, 8, 0, 0, 9, 0, 55,
    0, 46, 2, 2, 3, 0, 8, 0, 0, 121, 0, 47, 0, 47, 6, 11, 1, 254, 8, 0,
    0, 44, 0, 1, 0, 48, 7, 9, 1, 0, 8, 0, 0, 51, 0, 16, 0, 49, 5, 9,
    2, 0, 8, 0, 0, 59, 0, 16, 0, 50, 8, 9, 1, 0, 8, 0, 0, 65, 0, 16,
    0, 51, 7, 9, 1, 0, 8, 0, 0, 74, 0, 16, 0, 52, 7, 9, 1, 0, 8, 0,
    0, 82, 0, 16, 0, 53, 7, 9, 1, 0, 8, 0, 0, 90, 0, 16, 0, 54, 7, 9,
    1, 0, 8, 0, 0, 98, 0, 16, 0, 55, 7, 9, 1, 0, 8, 0, 0, 106, 0, 16,
    0, 56, 7, 9, 1, 0, 8, 0, 0, 114, 0, 16, 0, 57, 7, 9, 1, 0, 8, 0,
    0, 1, 0, 27, 0, 58, 2, 7, 3, 0, 8, 0, 0, 123, 0, 27, 0, 59, 3, 9,
    2, 254, 8, 0, 0, 122, 0, 16, 0, 60, 7, 6, 1, 1, 8, 0, 0, 81, 0, 47,
    0, 61, 7, 4, 1, 2, 8, 0, 0, 105, 0, 47, 0, 62, 7, 6, 1, 1, 8, 0,
    0, 89, 0, 47, 0, 63, 5, 9, 1, 0, 8, 0, 0, 9, 0, 27, 0, 64, 7, 11,
    1, 254, 8, 0, 0, 51, 0, 1, 0, 65, 7, 9, 1, 0, 8, 0, 0, 15, 0, 27,
    0, 66, 7, 9, 1, 0, 8, 0, 0, 23, 0, 27, 0, 67, 7, 9, 1, 0, 8, 0,
    0, 31, 0, 27, 0, 68, 7, 9, 1, 0, 8, 0, 0, 39, 0, 27, 0, 69, 7, 9,
    1, 0, 8, 0, 0, 47, 0, 27, 0, 70, 7, 9, 1, 0, 8, 0, 0, 55, 0, 27,
    0, 71, 7, 9, 1, 0, 8, 0, 0, 63, 0, 27, 0, 72, 7, 9, 1, 0, 8, 0,
    0, 71, 0, 27, 0, 73, 5, 9, 1, 0, 8, 0, 0, 79, 0, 27, 0, 74, 5, 9,
    1, 0, 8, 0, 0, 85, 0, 27, 0, 75, 7, 9, 1, 0, 8, 0, 0, 91, 0, 27,
    0, 76, 7, 9, 1, 0, 8, 0, 0, 99, 0, 27, 0, 77, 7, 9, 1, 0, 8, 0,
    0, 107, 0, 27, 0, 78, 7, 9, 1, 0, 8, 0, 0, 115, 0, 27, 0, 79, 7, 9,
    1, 0, 8, 0, 0, 1, 0, 37, 0, 80, 7, 9, 1, 0, 8, 0, 0, 9, 0, 37,
    0, 81, 7, 11, 1, 254, 8, 0, 0, 59, 0, 1, 0, 82, 8, 9, 1, 0, 8, 0,
    0, 17, 0, 37, 0, 83, 7, 9, 1, 0, 8, 0, 0, 26, 0, 37, 0, 84, 7, 9,
    0, 0, 8, 0, 0, 34, 0, 37, 0, 85, 7, 9, 1, 0, 8, 0, 0, 42, 0, 37,
    0, 86, 7, 9, 1, 0, 8, 0, 0, 50, 0, 37, 0, 87, 8, 9, 0, 0, 8, 0,
    0, 58, 0, 37, 0, 88, 7, 9, 1, 0, 8, 0, 0, 67, 0, 37, 0, 89, 7, 9,
    0, 0, 8, 0, 0, 75, 0, 37, 0, 90, 7, 9, 1, 0, 8, 0, 0, 83, 0, 37,
    0, 91, 3, 12, 3, 255, 8, 0, 0, 16, 0, 1, 0, 92, 6, 11, 1, 254, 8, 0,
    0, 67, 0, 1, 0, 93, 3, 12, 2, 255, 8, 0, 0, 20, 0, 1, 0, 94, 7, 4,
    0, 5, 8, 0, 0, 113, 0, 47, 0, 95, 7, 1, 0, 253, 8, 0, 0, 13, 0, 55,
    0, 96, 3, 2, 2, 8, 8, 0, 0, 124, 0, 47, 0, 97, 6, 7, 1, 0, 8, 0,
    0, 106, 0, 37, 0, 98, 6, 11, 1, 0, 8, 0, 0, 74, 0, 1, 0, 99, 6, 7,
    1, 0, 8, 0, 0, 113, 0, 37, 0, 100, 6, 11, 1, 0, 8, 0, 0, 81, 0, 1,
    0, 101, 6, 7, 1, 0, 8, 0, 0, 120, 0, 37, 0, 102, 5, 11, 1, 0, 8, 0,
    0, 88, 0, 1, 0, 103, 6, 10, 1, 253, 8, 0, 0, 121, 0, 1, 0, 104, 6, 11,
    1, 0, 8, 0, 0, 94, 0, 1, 0, 105, 5, 11, 1, 0, 8, 0, 0, 101, 0, 1,
    0, 106, 4, 14, 1, 253, 8, 0, 0, 1, 0, 1, 0, 107, 6, 11, 1, 0, 8, 0,
    0, 107, 0, 1, 0, 108, 6, 11, 1, 0, 8, 0, 0, 114, 0, 1, 0, 109, 7, 7,
    1, 0, 8, 0, 0, 1, 0, 47, 0, 110, 6, 7, 1, 0, 8, 0, 0, 9, 0, 47,
    0, 111, 6, 7, 1, 0, 8, 0, 0, 16, 0, 47, 0, 112, 6, 10, 1, 253, 8, 0,
    0, 10, 0, 16, 0, 113, 6, 10, 1, 253, 8, 0, 0, 17, 0, 16, 0, 114, 5, 7,
    2, 0, 8, 0, 0, 23, 0, 47, 0, 115, 6, 7, 1, 0, 8, 0, 0, 29, 0, 47,
    0, 116, 6, 9, 1, 0, 8, 0, 0, 91, 0, 37, 0, 117, 6, 7, 1, 0, 8, 0,
    0, 36, 0, 47, 0, 118, 6, 7, 1, 0, 8, 0, 0, 43, 0, 47, 0, 119, 8, 7,
    0, 0, 8, 0, 0, 50, 0, 47, 0, 120, 6, 7, 1, 0, 8, 0, 0, 59, 0, 47,
    0, 121, 7, 10, 1, 253, 8, 0, 0, 24, 0, 16, 0, 122, 6, 7, 1, 0, 8, 0,
    0, 66, 0, 47, 0, 123, 5, 12, 1, 255, 8, 0, 0, 24, 0, 1, 0, 124, 1, 13,
    3, 254, 8, 0, 0, 6, 0, 1, 0, 125, 5, 12, 1, 255, 8, 0, 0, 30, 0, 1,
    0, 126, 7, 2, 1, 3, 8, 0, 0, 1, 0, 55, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 255, 255, 236, 80, 0, 255, 0, 0, 128, 176, 0, 176, 128, 0, 0, 255, 255, 255, 0,
    255, 255, 255, 0, 0, 0, 104, 232, 255, 0, 255, 232, 104, 0, 0, 0, 0, 0, 0, 255,
    0, 0, 0, 0, 200, 60, 0, 0, 0, 0, 0, 0, 8, 128, 224, 255, 212, 0, 0, 0,
    0, 0, 0, 4, 168, 76, 0, 0, 0, 0, 0, 60, 200, 0, 255, 120, 244, 248, 160, 12,
    0, 12, 160, 248, 244, 120, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 255,
    0, 255, 255, 255, 255, 255, 0, 255, 0, 0, 0, 104, 160, 0, 0, 0, 60, 228, 255, 255,
    0, 0, 100, 232, 248, 172, 12, 0, 0, 0, 0, 80, 216, 0, 255, 0, 12, 236, 36, 0,
    36, 236, 12, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 232, 60, 0, 0, 0, 60,
    232, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 80, 176, 0, 0, 0, 0, 0, 4,
    192, 180, 44, 0, 0, 0, 0, 0, 0, 0, 4, 172, 240, 40, 0, 0, 0, 0, 0, 176,
    80, 0, 255, 172, 16, 12, 164, 140, 0, 140, 164, 12, 20, 176, 255, 0, 0, 0, 255, 0,
    0, 0, 255, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 64, 208,
    12, 0, 0, 0, 204, 100, 0, 0, 0, 0, 164, 28, 8, 144, 156, 0, 0, 0, 0, 0,
    255, 0, 255, 0, 100, 176, 0, 0, 0, 180, 100, 0, 255, 0, 0, 0, 0, 0, 255, 0,
    0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 68, 176, 244, 255, 240, 172, 36, 0,
    4, 220, 36, 0, 0, 0, 0, 96, 200, 4, 0, 0, 0, 0, 0, 0, 116, 224, 255, 255,
    196, 8, 0, 0, 0, 0, 36, 220, 4, 0, 255, 32, 0, 0, 32, 232, 0, 232, 32, 0,
    0, 32, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 255, 0, 0, 0, 255,
    0, 0, 0, 255, 12, 36, 224, 44, 0, 0, 0, 0, 255, 4, 0, 0, 0, 0, 0, 0,
    0, 16, 236, 0, 0, 0, 0, 0, 255, 0, 255, 0, 176, 92, 0, 0, 0, 92, 176, 0,
    255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0,
    180, 68, 12, 255, 12, 108, 216, 0, 0, 108, 152, 0, 0, 0, 0, 192, 80, 0, 80, 240,
    184, 255, 0, 92, 208, 44, 0, 44, 208, 124, 0, 0, 0, 0, 152, 108, 0, 0, 255, 0,
    0, 0, 0, 255, 0, 255, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0,
    0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 192, 216, 96, 0, 0, 0, 0, 0,
    255, 0, 0, 0, 0, 12, 156, 248, 240, 108, 255, 0, 0, 0, 0, 0, 255, 0, 255, 0,
    224, 36, 0, 0, 0, 36, 224, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 16, 255, 0,
    0, 0, 0, 0, 255, 16, 0, 0, 0, 0, 0, 255, 0, 16, 244, 0, 0, 8, 228, 24,
    0, 0, 0, 240, 16, 0, 220, 68, 68, 255, 0, 196, 68, 0, 0, 0, 68, 208, 0, 0,
    0, 24, 228, 8, 0, 0, 255, 32, 0, 0, 32, 236, 0, 236, 32, 0, 0, 32, 255, 0,
    0, 0, 255, 0, 0, 0, 255, 20, 0, 0, 4, 255, 0, 0, 0, 255, 0, 0, 0, 255,
    84, 228, 24, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 140, 176, 20, 12, 164, 255, 0,
    0, 0, 0, 0, 255, 0, 255, 0, 255, 0, 0, 0, 0, 0, 255, 0, 255, 0, 0, 0,
    0, 0, 255, 0, 0, 116, 224, 0, 0, 0, 0, 0, 220, 116, 0, 0, 0, 16, 80, 255,
    144, 204, 92, 0, 0, 0, 128, 128, 0, 0, 0, 255, 0, 0, 255, 0, 0, 255, 0, 244,
    12, 0, 0, 0, 12, 248, 0, 0, 0, 128, 128, 0, 0, 0, 255, 172, 16, 12, 164, 144,
    0, 144, 164, 12, 20, 176, 255, 0, 0, 0, 255, 0, 0, 0, 255, 164, 20, 4, 116, 204,
    0, 0, 0, 255, 0, 0, 0, 255, 0, 60, 204, 24, 0, 0, 0, 0, 255, 0, 0, 0,
    0, 232, 32, 0, 0, 32, 255, 0, 0, 0, 0, 0, 255, 0, 255, 0, 255, 0, 0, 0,
    0, 0, 255, 0, 255, 0, 0, 0, 0, 0, 255, 0, 255, 255, 104, 0, 0, 0, 0, 0,
    100, 255, 255, 0, 104, 208, 136, 255, 68, 12, 0, 0, 0, 0, 24, 228, 8, 0, 0, 244,
    12, 0, 220, 68, 68, 255, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 8, 228, 24, 0,
    0, 0, 255, 120, 244, 248, 164, 12, 0, 12, 160, 248, 244, 124, 255, 0, 255, 255, 255, 255,
    255, 0, 255, 88, 224, 255, 212, 60, 0, 255, 255, 255, 0, 0, 0, 255, 0, 0, 40, 208,
    40, 0, 0, 0, 255, 0, 0, 0, 0, 255, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0,
    255, 0, 255, 0, 224, 32, 0, 0, 0, 36, 224, 0, 255, 0, 0, 0, 0, 0, 255, 0,
    0, 76, 232, 0, 0, 0, 0, 0, 232, 76, 0, 0, 244, 16, 0, 255, 0, 0, 0, 0,
    0, 0, 0, 152, 108, 0, 0, 200, 64, 0, 80, 240, 184, 255, 0, 244, 12, 0, 0, 0,
    12, 244, 0, 0, 108, 152, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 232, 32, 0,
    0, 32, 255, 0, 0, 0, 0, 0, 255, 0, 255, 0, 176, 88, 0, 0, 0, 92, 176, 0,
    255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0,
    220, 116, 12, 255, 16, 80, 192, 0, 0, 0, 0, 36, 220, 4, 0, 112, 176, 0, 0, 0,
    32, 236, 0, 196, 68, 0, 0, 0, 68, 196, 0, 4, 220, 36, 0, 0, 0, 0, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 252, 0, 0, 0, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 0, 0, 0, 0, 140, 176, 20, 12, 164, 255, 0, 0, 0, 255, 255, 255, 0, 255, 0,
    100, 172, 0, 0, 0, 176, 100, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0,
    0, 0, 0, 0, 255, 0, 0, 0, 40, 184, 244, 255, 240, 164, 64, 0, 0, 0, 0, 0,
    176, 80, 0, 8, 212, 140, 20, 16, 176, 148, 0, 92, 208, 44, 0, 44, 208, 92, 0, 80,
    176, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0,
    0, 0, 212, 64, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 12, 156, 248, 244, 116, 255, 0,
    0, 0, 0, 0, 0, 0, 255, 0, 12, 236, 36, 0, 36, 236, 12, 0, 255, 0, 0, 0,
    0, 0, 255, 0, 0, 0, 244, 52, 0, 0, 0, 52, 244, 0, 0, 0, 0, 0, 0, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 60, 200, 0, 0, 20, 160, 240, 252, 172, 12, 0, 0,
    116, 224, 255, 224, 116, 0, 0, 200, 60, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 80, 244, 255, 0, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 128, 176, 0,
    176, 128, 0, 0, 255, 255, 255, 0, 255, 255, 255, 0, 0, 0, 116, 240, 255, 0, 255, 236,
    116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 228, 40, 64, 208, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 255, 0, 0, 255, 192, 8, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 84, 236,
    236, 84, 0, 12, 160, 244, 248, 176, 132, 184, 0, 0, 112, 224, 255, 224, 100, 0, 0, 255,
    255, 255, 255, 255, 0, 255, 255, 255, 255, 255, 255, 255, 32, 0, 76, 184, 244, 255, 224, 152,
    20, 0, 0, 0, 0, 0, 0, 255, 0, 0, 88, 204, 252, 255, 212, 108, 4, 0, 0, 116,
    224, 255, 240, 156, 12, 0, 0, 184, 104, 0, 0, 0, 0, 0, 32, 172, 240, 255, 240, 172,
    32, 0, 204, 96, 0, 0, 255, 0, 0, 0, 168, 100, 8, 248, 12, 0, 0, 0, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 4, 192, 96, 0, 0, 0, 0,
    255, 0, 0, 0, 0, 0, 236, 48, 48, 236, 0, 160, 196, 28, 12, 124, 255, 60, 0, 88,
    220, 52, 0, 52, 220, 88, 0, 0, 0, 255, 0, 0, 0, 92, 240, 128, 0, 0, 0, 0,
    0, 0, 188, 76, 12, 0, 32, 152, 200, 0, 0, 0, 0, 0, 0, 255, 0, 0, 180, 68,
    12, 0, 52, 188, 144, 0, 96, 176, 36, 0, 28, 164, 168, 0, 0, 40, 232, 16, 0, 0,
    0, 0, 200, 144, 24, 0, 24, 140, 200, 0, 108, 248, 48, 0, 255, 0, 0, 0, 112, 156,
    0, 200, 64, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0,
    0, 0, 92, 180, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 236, 48, 48, 236, 0, 248,
    28, 0, 4, 204, 200, 148, 0, 196, 80, 0, 0, 0, 80, 192, 0, 0, 0, 255, 0, 0,
    0, 0, 32, 204, 184, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 255, 0, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 20, 244, 0, 200, 20, 0, 0, 0, 16,
    248, 0, 0, 0, 148, 144, 0, 0, 0, 0, 255, 8, 0, 0, 0, 8, 255, 0, 16, 255,
    220, 0, 255, 0, 0, 255, 255, 255, 255, 255, 255, 255, 64, 0, 255, 124, 244, 248, 164, 12,
    0, 12, 164, 248, 244, 116, 255, 0, 0, 0, 108, 248, 8, 0, 0, 0, 200, 0, 80, 192,
    120, 24, 84, 236, 236, 76, 0, 244, 8, 0, 148, 176, 16, 228, 0, 244, 16, 0, 8, 0,
    16, 244, 0, 0, 0, 255, 0, 0, 0, 0, 0, 4, 140, 228, 56, 0, 0, 0, 0, 0,
    0, 0, 32, 152, 180, 0, 188, 120, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 24,
    244, 0, 244, 20, 0, 0, 0, 12, 248, 0, 0, 0, 16, 236, 40, 0, 0, 0, 180, 140,
    24, 0, 24, 140, 180, 0, 0, 255, 255, 0, 255, 0, 0, 0, 0, 236, 32, 72, 196, 0,
    0, 0, 255, 172, 16, 12, 164, 144, 0, 144, 164, 12, 16, 172, 255, 0, 0, 0, 208, 232,
    76, 0, 0, 0, 255, 0, 0, 0, 72, 168, 164, 64, 0, 0, 0, 156, 104, 88, 220, 12,
    0, 255, 0, 255, 0, 0, 164, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0,
    0, 88, 232, 36, 0, 0, 0, 0, 255, 255, 255, 224, 24, 0, 28, 232, 60, 0, 0, 255,
    0, 0, 0, 0, 0, 8, 60, 200, 128, 0, 255, 172, 36, 0, 28, 164, 164, 0, 0, 0,
    0, 108, 184, 0, 0, 0, 16, 212, 255, 255, 255, 212, 16, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 168, 100, 12, 244, 12, 0, 0, 255, 32, 0, 0, 32, 236, 0, 236, 32, 0,
    0, 32, 255, 0, 0, 52, 220, 96, 164, 0, 0, 0, 255, 0, 84, 236, 236, 84, 24, 120,
    188, 92, 0, 12, 196, 232, 44, 0, 0, 0, 0, 244, 16, 0, 0, 0, 16, 244, 0, 0,
    0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 88, 188, 0, 0, 0, 0, 0, 0, 28, 148,
    180, 0, 0, 72, 228, 20, 0, 255, 0, 0, 255, 236, 255, 244, 196, 92, 0, 0, 240, 92,
    216, 255, 236, 152, 12, 0, 0, 0, 0, 4, 216, 72, 0, 0, 168, 132, 24, 0, 24, 132,
    168, 0, 0, 0, 0, 0, 0, 0, 0, 64, 255, 255, 255, 255, 255, 255, 255, 0, 255, 0,
    0, 0, 0, 255, 0, 255, 0, 0, 0, 0, 255, 0, 0, 152, 120, 12, 236, 8, 0, 0,
    255, 0, 236, 48, 48, 236, 0, 0, 4, 28, 0, 0, 204, 76, 0, 0, 0, 0, 0, 196,
    80, 0, 0, 0, 80, 192, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 4, 252,
    0, 0, 0, 0, 0, 0, 0, 8, 255, 0, 0, 0, 136, 184, 0, 255, 0, 0, 255, 0,
    0, 0, 0, 0, 0, 0, 172, 104, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 216,
    4, 0, 252, 8, 0, 0, 0, 8, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44,
    224, 0, 136, 136, 0, 0, 255, 32, 0, 0, 32, 232, 0, 232, 32, 0, 0, 32, 255, 0,
    12, 240, 24, 0, 176, 92, 0, 0, 255, 0, 236, 48, 48, 236, 0, 0, 0, 0, 0, 0,
    248, 48, 0, 0, 0, 0, 0, 88, 220, 52, 0, 52, 220, 88, 0, 0, 0, 255, 0, 0,
    0, 196, 92, 28, 0, 24, 152, 180, 0, 0, 192, 92, 20, 0, 24, 140, 180, 0, 0, 0,
    4, 200, 116, 255, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 40, 232, 108, 20, 0, 44,
    168, 0, 0, 0, 0, 0, 0, 184, 108, 0, 200, 140, 24, 0, 24, 136, 200, 0, 0, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 240, 28, 76, 192, 0, 0, 255, 172, 16, 12, 164, 140,
    0, 140, 164, 12, 16, 172, 255, 0, 104, 172, 0, 0, 80, 184, 0, 0, 255, 0, 84, 236,
    236, 84, 0, 0, 0, 0, 0, 0, 104, 232, 255, 255, 0, 0, 0, 0, 112, 224, 255, 224,
    100, 0, 0, 255, 255, 255, 0, 0, 0, 72, 180, 244, 255, 220, 140, 12, 0, 0, 64, 164,
    240, 255, 220, 140, 12, 0, 0, 0, 0, 32, 236, 255, 0, 0, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 40, 164, 236, 255, 220, 92, 0, 255, 255, 255, 255, 255, 255, 240, 0, 24, 164,
    240, 255, 240, 164, 24, 0, 0, 255, 255, 0, 0, 0, 0, 0, 0, 0, 180, 88, 16, 244,
    4, 0, 255, 120, 244, 248, 164, 12, 0, 12, 164, 248, 244, 120, 255, 0, 204, 72, 0, 0,
    8, 240, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 92, 220, 255, 236, 164, 40, 0, 0, 0, 0, 255,
    0, 0, 0, 220, 52, 0, 0, 0, 52, 220, 0, 255, 255, 255, 255, 236, 172, 36, 0, 0,
    36, 164, 236, 255, 216, 92, 0, 255, 255, 255, 224, 156, 36, 0, 0, 255, 255, 255, 255, 255,
    255, 255, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 52, 184, 244, 255, 212, 104, 0, 255,
    0, 0, 0, 0, 0, 255, 0, 255, 255, 255, 255, 255, 0, 92, 224, 255, 196, 36, 0, 255,
    0, 0, 0, 32, 236, 48, 0, 255, 255, 255, 255, 255, 255, 255, 0, 255, 0, 0, 0, 0,
    0, 255, 0, 255, 0, 0, 0, 0, 156, 255, 0, 255, 255, 0, 0, 0, 0, 168, 44, 0,
    20, 108, 232, 40, 0, 0, 0, 255, 0, 0, 0, 136, 128, 0, 0, 0, 128, 136, 0, 255,
    0, 0, 0, 20, 128, 216, 0, 36, 232, 96, 16, 0, 52, 172, 0, 255, 0, 0, 32, 108,
    232, 44, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 48,
    232, 96, 12, 0, 52, 255, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0,
    0, 244, 76, 4, 132, 168, 0, 255, 0, 0, 0, 192, 116, 0, 0, 255, 0, 0, 0, 0,
    0, 0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 255, 0, 0, 0, 60, 224, 255, 0, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 172, 0, 0, 0, 0, 0, 0, 0, 60,
    255, 255, 255, 255, 255, 60, 0, 255, 0, 0, 0, 0, 4, 255, 0, 168, 104, 0, 0, 0,
    0, 0, 0, 255, 0, 0, 0, 0, 100, 176, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255,
    0, 0, 0, 0, 0, 0, 0, 176, 100, 0, 0, 0, 0, 255, 0, 255, 0, 0, 0, 0,
    0, 255, 0, 0, 0, 255, 0, 0, 0, 76, 0, 0, 24, 232, 0, 255, 0, 0, 116, 196,
    4, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 255,
    0, 0, 4, 216, 80, 255, 0, 0, 0, 0, 0, 0, 0, 12, 148, 236, 255, 216, 92, 240,
    0, 0, 0, 255, 0, 0, 0, 0, 236, 28, 0, 28, 236, 0, 0, 255, 0, 0, 0, 24,
    132, 188, 0, 236, 20, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 16, 240, 0, 255,
    0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 240, 20, 0, 0, 0,
    0, 255, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0,
    0, 255, 0, 255, 24, 40, 236, 32, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255,
    0, 72, 255, 72, 0, 255, 0, 255, 0, 0, 120, 176, 0, 255, 0, 0, 0, 0, 0, 0,
    0, 164, 164, 28, 0, 32, 172, 255, 0, 0, 0, 216, 84, 0, 0, 0, 156, 108, 0, 108,
    156, 0, 0, 255, 255, 255, 255, 255, 236, 40, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255,
    0, 0, 0, 0, 0, 255, 0, 255, 255, 255, 255, 255, 255, 255, 0, 255, 255, 255, 255, 255,
    255, 255, 0, 255, 0, 0, 0, 0, 255, 255, 0, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 255, 204, 208, 104, 0, 0, 0, 0, 255,
    0, 0, 0, 0, 0, 0, 0, 255, 0, 172, 200, 172, 0, 255, 0, 255, 0, 32, 236, 32,
    0, 255, 0, 0, 0, 0, 0, 0, 0, 248, 12, 0, 0, 0, 20, 244, 0, 0, 0, 40,
    228, 100, 0, 0, 80, 188, 0, 188, 80, 0, 0, 255, 0, 0, 0, 24, 136, 200, 0, 236,
    20, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 16, 240, 0, 255, 0, 0, 0, 0,
    0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 236, 20, 0, 0, 0, 0, 0, 0, 255,
    0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 255,
    60, 236, 40, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 24, 240, 24, 240,
    24, 255, 0, 255, 0, 184, 116, 0, 0, 255, 0, 255, 255, 0, 0, 0, 0, 248, 16, 0,
    0, 0, 20, 200, 0, 0, 0, 0, 52, 236, 0, 0, 8, 244, 24, 244, 8, 0, 0, 255,
    0, 0, 0, 0, 4, 255, 0, 164, 104, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0,
    100, 176, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 168,
    100, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0,
    0, 0, 0, 0, 0, 255, 0, 255, 0, 60, 220, 40, 0, 0, 0, 255, 0, 0, 0, 0,
    0, 0, 0, 255, 120, 152, 0, 152, 120, 255, 0, 255, 88, 212, 4, 0, 0, 255, 0, 255,
    255, 0, 0, 0, 0, 172, 164, 28, 0, 32, 176, 96, 0, 172, 44, 0, 48, 236, 0, 0,
    0, 176, 184, 176, 0, 0, 0, 255, 0, 0, 0, 20, 128, 200, 0, 32, 220, 96, 16, 0,
    52, 172, 0, 255, 0, 0, 32, 104, 232, 44, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255,
    0, 0, 0, 0, 0, 0, 0, 36, 232, 96, 12, 0, 52, 172, 0, 255, 0, 0, 0, 0,
    0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 255, 0, 0, 60, 220,
    40, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 224, 52, 0, 52, 224, 255, 0, 255,
    232, 56, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 12, 156, 240, 255, 224, 116, 0,
    0, 92, 220, 255, 212, 72, 0, 0, 0, 100, 255, 100, 0, 0, 0, 255, 255, 255, 255, 236,
    160, 24, 0, 0, 32, 164, 236, 255, 216, 92, 0, 255, 255, 255, 224, 156, 36, 0, 0, 255,
    255, 255, 255, 255, 255, 255, 0, 255, 255, 255, 255, 255, 255, 255, 0, 0, 36, 172, 240, 255,
    212, 88, 0, 255, 0, 0, 0, 0, 0, 255, 0, 255, 255, 255, 255, 255, 0, 0, 0, 255,
    255, 255, 0, 255, 0, 0, 0, 60, 220, 40, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255,
    204, 0, 0, 0, 204, 255, 0, 255, 156, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 224, 255, 224, 116, 0, 0, 255, 0, 0,
    0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 80, 200, 0, 72, 184, 244, 255, 228, 156,
    24, 0, 0, 0, 0, 255, 0, 0, 0, 0, 20, 156, 236, 255, 236, 156, 20, 0, 0, 0,
    104, 255, 104, 0, 0, 0, 0, 160, 212, 0, 0, 212, 160, 0, 0, 184, 116, 0, 0, 0,
    120, 184, 0, 0, 0, 0, 255, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 96, 232, 255, 255, 0, 0, 0, 0, 255, 0, 0, 0, 0, 80, 220, 255, 224, 96, 255,
    0, 0, 104, 212, 255, 228, 100, 0, 4, 124, 228, 255, 208, 84, 0, 0, 0, 96, 208, 44,
    0, 44, 208, 92, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 204,
    80, 0, 192, 84, 16, 0, 28, 144, 200, 0, 0, 0, 0, 255, 0, 0, 0, 0, 180, 132,
    24, 0, 24, 136, 180, 0, 0, 0, 188, 168, 188, 0, 0, 0, 0, 204, 255, 24, 24, 255,
    204, 0, 0, 36, 236, 20, 0, 28, 236, 36, 0, 0, 0, 0, 255, 0, 0, 0, 0, 140,
    180, 0, 0, 0, 0, 0, 0, 0, 0, 236, 72, 0, 0, 0, 0, 0, 0, 255, 0, 0,
    0, 0, 240, 76, 0, 24, 156, 255, 0, 116, 204, 48, 0, 24, 148, 0, 124, 164, 28, 0,
    56, 180, 0, 0, 0, 200, 68, 0, 0, 0, 68, 196, 0, 255, 0, 0, 0, 0, 0, 0,
    0, 255, 0, 0, 0, 0, 64, 220, 4, 0, 0, 0, 0, 0, 0, 8, 255, 0, 0, 0,
    0, 255, 0, 0, 0, 0, 244, 4, 0, 0, 0, 4, 244, 0, 0, 12, 240, 24, 240, 12,
    0, 0, 0, 244, 192, 92, 92, 192, 244, 0, 0, 0, 140, 156, 0, 168, 132, 0, 0, 0,
    0, 0, 255, 0, 0, 0, 0, 4, 188, 128, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0,
    0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 232, 88, 12, 0, 12, 255, 0, 224, 44, 0,
    0, 0, 0, 0, 228, 12, 0, 0, 0, 0, 0, 0, 0, 244, 12, 0, 0, 0, 12, 244,
    0, 255, 255, 255, 255, 228, 144, 12, 0, 255, 0, 0, 0, 36, 220, 80, 0, 0, 0, 0,
    0, 0, 44, 156, 180, 0, 0, 0, 0, 255, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0,
    255, 0, 0, 84, 184, 0, 184, 84, 0, 0, 24, 232, 104, 160, 160, 104, 232, 24, 0, 0,
    16, 228, 116, 224, 8, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 20, 224, 84, 0,
    0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 0, 56, 196,
    248, 255, 255, 255, 0, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0,
    0, 255, 0, 0, 0, 0, 0, 255, 0, 255, 0, 0, 0, 52, 188, 164, 0, 255, 255, 244,
    236, 255, 180, 12, 0, 0, 16, 136, 212, 252, 220, 132, 12, 0, 0, 0, 0, 255, 0, 0,
    0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 0, 164, 104, 0, 104, 164, 0, 0, 72, 192,
    36, 228, 228, 36, 188, 72, 0, 0, 0, 108, 255, 88, 0, 0, 0, 0, 0, 72, 255, 72,
    0, 0, 0, 0, 0, 48, 232, 44, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0,
    0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 4, 252, 0, 224, 44, 0, 0, 0, 0, 0,
    228, 28, 0, 0, 12, 240, 0, 0, 0, 244, 12, 0, 0, 0, 12, 244, 0, 255, 0, 0,
    0, 0, 20, 248, 0, 255, 0, 0, 0, 28, 144, 184, 0, 0, 196, 168, 60, 8, 0, 0,
    0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 4, 236,
    28, 0, 28, 236, 4, 0, 112, 148, 0, 224, 224, 0, 148, 112, 0, 0, 0, 180, 216, 160,
    0, 0, 0, 0, 8, 220, 144, 220, 8, 0, 0, 0, 0, 0, 92, 220, 16, 0, 0, 0,
    0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 164, 32, 4, 108, 192,
    0, 116, 204, 48, 0, 28, 156, 0, 128, 180, 20, 8, 152, 156, 0, 0, 0, 196, 68, 0,
    0, 0, 68, 196, 0, 255, 0, 0, 0, 0, 20, 248, 0, 255, 0, 0, 0, 0, 8, 255,
    0, 0, 255, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 255, 0,
    0, 0, 0, 0, 255, 0, 60, 208, 0, 0, 0, 208, 60, 0, 152, 108, 0, 0, 0, 0,
    108, 152, 0, 0, 96, 204, 16, 224, 80, 0, 0, 0, 124, 176, 0, 176, 124, 0, 0, 0,
    0, 0, 0, 140, 188, 4, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 255, 0, 0,
    0, 0, 0, 92, 224, 255, 192, 40, 0, 0, 104, 212, 255, 228, 100, 0, 4, 140, 240, 252,
    172, 12, 0, 0, 0, 92, 208, 44, 0, 44, 208, 92, 0, 255, 0, 0, 0, 48, 184, 164,
    0, 255, 0, 0, 0, 36, 152, 196, 0, 0, 176, 152, 32, 0, 16, 76, 188, 0, 0, 0,
    0, 255, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 255, 0, 140, 128, 0, 0, 0, 128,
    140, 0, 192, 64, 0, 0, 0, 0, 64, 192, 0, 20, 236, 48, 0, 56, 232, 20, 0, 32,
    240, 32, 0, 32, 240, 32, 0, 0, 0, 0, 0, 4, 188, 140, 0, 0, 0, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 224, 255, 224, 116, 0,
    0, 255, 255, 255, 255, 228, 140, 12, 0, 255, 255, 255, 255, 228, 152, 24, 0, 0, 12, 128,
    216, 255, 244, 184, 64, 0, 255, 255, 255, 255, 255, 255, 255, 0, 255, 0, 0, 0, 0, 0,
    255, 0, 220, 52, 0, 0, 0, 52, 220, 0, 236, 24, 0, 0, 0, 0, 24, 236, 0, 172,
    128, 0, 0, 0, 140, 172, 0, 176, 120, 0, 0, 0, 120, 176, 0, 255, 255, 255, 255, 255,
    255, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 255, 0, 0, 255, 0, 255, 0, 0,
    0, 0, 255, 0, 12, 168, 248, 248, 168, 12, 0, 255, 0, 0, 0, 0, 0, 76, 196, 252,
    248, 188, 52, 0, 60, 212, 255, 224, 88, 255, 0, 0, 0, 220, 220, 0, 0, 0, 0, 20,
    252, 20, 12, 248, 20, 0, 0, 172, 140, 0, 0, 140, 172, 0, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 28, 120, 208, 0, 208, 120, 28,
    0, 0, 0, 0, 0, 255, 0, 255, 0, 204, 96, 0, 0, 255, 255, 255, 255, 255, 255, 255,
    0, 160, 144, 0, 0, 0, 144, 160, 0, 255, 255, 0, 0, 112, 144, 0, 0, 255, 0, 0,
    255, 0, 0, 255, 0, 255, 0, 0, 0, 0, 255, 0, 156, 172, 16, 16, 172, 156, 0, 255,
    0, 0, 0, 0, 0, 184, 72, 8, 8, 92, 232, 0, 204, 116, 4, 20, 164, 255, 0, 0,
    48, 220, 220, 48, 0, 0, 0, 92, 216, 100, 100, 216, 92, 0, 0, 20, 232, 48, 48, 232,
    20, 0, 144, 112, 0, 0, 0, 0, 0, 168, 108, 4, 255, 4, 108, 168, 0, 0, 16, 100,
    192, 236, 156, 68, 0, 68, 156, 236, 192, 100, 16, 0, 0, 255, 0, 255, 0, 108, 248, 48,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 220, 96, 0, 96, 220, 12, 0, 255, 255, 0,
    112, 172, 0, 0, 0, 255, 0, 0, 255, 0, 0, 255, 0, 255, 0, 0, 0, 0, 255, 0,
    236, 32, 0, 0, 32, 236, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 4, 84, 244, 0,
    255, 4, 0, 0, 20, 255, 0, 0, 132, 132, 132, 132, 0, 0, 0, 168, 88, 188, 188, 88,
    168, 0, 0, 0, 92, 208, 208, 92, 0, 0, 0, 144, 112, 0, 0, 0, 0, 8, 100, 184,
    255, 184, 100, 8, 0, 176, 228, 156, 68, 4, 0, 0, 0, 0, 0, 4, 68, 156, 228, 176,
    0, 255, 0, 255, 0, 16, 255, 220, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 244,
    112, 244, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 255, 0, 0, 255,
    0, 255, 0, 0, 0, 0, 255, 0, 255, 0, 0, 0, 0, 255, 0, 255, 0, 0, 0, 0,
    0, 44, 160, 208, 244, 240, 96, 0, 255, 0, 0, 0, 0, 255, 0, 0, 220, 48, 48, 220,
    0, 0, 4, 212, 0, 236, 232, 0, 212, 4, 0, 0, 0, 200, 200, 0, 0, 0, 0, 0,
    144, 112, 0, 0, 0, 8, 100, 184, 255, 184, 100, 8, 0, 176, 228, 156, 68, 4, 0, 0,
    0, 0, 0, 4, 68, 156, 228, 176, 0, 255, 0, 255, 0, 0, 255, 255, 0, 255, 255, 255,
    255, 255, 255, 255, 0, 0, 0, 112, 255, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 255, 0, 0, 255, 0, 0, 255, 0, 255, 20, 0, 0, 4, 255, 0, 236, 32, 0, 0,
    32, 236, 0, 255, 24, 0, 0, 0, 0, 232, 128, 64, 28, 0, 0, 0, 255, 0, 0, 0,
    0, 255, 0, 48, 228, 0, 0, 228, 48, 0, 68, 160, 0, 168, 164, 0, 160, 68, 0, 0,
    56, 236, 236, 56, 0, 0, 0, 0, 0, 112, 144, 0, 0, 168, 108, 4, 255, 4, 108, 168,
    0, 0, 16, 100, 192, 236, 156, 68, 0, 68, 156, 236, 192, 100, 16, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 60, 56, 255, 64, 52, 224, 0, 255, 164, 20,
    4, 116, 204, 0, 156, 172, 16, 16, 172, 156, 0, 255, 180, 28, 16, 192, 0, 232, 84, 8,
    4, 60, 180, 0, 255, 0, 0, 0, 0, 255, 0, 132, 144, 0, 0, 144, 132, 0, 140, 104,
    0, 0, 0, 0, 104, 140, 0, 12, 224, 80, 80, 224, 12, 0, 0, 0, 0, 0, 112, 144,
    0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 28, 120, 208, 0, 208, 120, 28,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 184, 252,
    140, 204, 252, 116, 0, 255, 88, 224, 255, 212, 60, 0, 12, 168, 248, 248, 168, 12, 0, 255,
    124, 232, 252, 120, 0, 56, 196, 248, 255, 204, 84, 0, 255, 0, 0, 0, 0, 255, 0, 220,
    60, 0, 0, 60, 220, 0, 220, 40, 0, 0, 0, 0, 40, 220, 0, 164, 152, 0, 0, 152,
    164, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 16, 20, 128, 236, 244, 124,
    0, 255, 255, 255, 0, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 120, 236, 244, 144, 28, 12, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
#endif
};

std::string StatisticsDefaultFontString((char *) StatisticsDefaultFontData, 
                                        StatisticsDefaultFontDataSize     );

class DefaultFontInitializer
{
public:

    DefaultFontInitializer():
        _face(0),
        _texchunk(NullFC)
    {
        #ifdef OSG_HAS_SSTREAM
        std::istringstream is(StatisticsDefaultFontString);
#else
        std::istrstream is(
            (char *) StatisticsDefaultFontData,
                     StatisticsDefaultFontDataSize);
#endif
        _face = TextTXFFace::createFromStream(is, "Bitstream Vera Sans Mono", TextFace::STYLE_PLAIN);
        addRefP(_face);

        _texchunk = TextureChunk::create();
        addRefCP(_texchunk);
        beginEditCP(_texchunk);
        {
            getFont();
            ImagePtr texture = _face->getTexture();
            _texchunk->setImage(texture);
            _texchunk->setWrapS(GL_CLAMP);
            _texchunk->setWrapT(GL_CLAMP);
            _texchunk->setMinFilter(GL_NEAREST);
            _texchunk->setMagFilter(GL_NEAREST);
            _texchunk->setEnvMode(GL_MODULATE);
        }
        endEditCP(_texchunk);
    }

    ~DefaultFontInitializer()
    {
        if (_texchunk != NullFC)
            subRefCP(_texchunk);
        if (_face != 0)
        {
            subRefP(_face);
            _face = 0;
        }
    }

    inline TextTXFFace *getFont()
    {
        return _face;
    }

    inline TextureChunkPtr getTexture()
    {
        return _texchunk;
    }

    static DefaultFontInitializer *the(void)
    {
        if(_the == NULL)
            _the = new DefaultFontInitializer;
        return _the;
    }

    static void destroy(void)
    {
        delete _the;
        _the = NULL;
    }

private:

    TextTXFFace *_face;
    TextureChunkPtr _texchunk;

    static DefaultFontInitializer *_the;
};

// we have to use a pointer here without it the compiler would create
// some atexit() code for destruction and this would conflict with
// osgExit() which is also called via atexit()!
DefaultFontInitializer *DefaultFontInitializer::_the = NULL;

TextTXFFace *getStatisticsDefaultFont()
{
    return DefaultFontInitializer::the()->getFont();
}

TextureChunkPtr getStatisticsDefaultFontTexture()
{
    return DefaultFontInitializer::the()->getTexture();
}

static bool terminateStatisticsDefaultFont()
{
    DefaultFontInitializer::destroy();
    return true;
}


class DefaultFontRegister
{
public:
    DefaultFontRegister()
    {
        addSystemExitFunction(&terminateStatisticsDefaultFont);
    }
};

static DefaultFontRegister _register;

OSG_END_NAMESPACE
