/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class LogicOpChunk!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILELOGICOPCHUNKINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGLogicOpChunkBase.h"
#include "OSGLogicOpChunk.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  LogicOpChunkBase::LogicOpFieldMask = 
    (TypeTraits<BitVector>::One << LogicOpChunkBase::LogicOpFieldId);

const OSG::BitVector LogicOpChunkBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var GLenum          LogicOpChunkBase::_sfLogicOp
    The logic operation applied to fragments.
*/

//! LogicOpChunk description

FieldDescription *LogicOpChunkBase::_desc[] = 
{
    new FieldDescription(SFGLenum::getClassType(), 
                     "LogicOp", 
                     LogicOpFieldId, LogicOpFieldMask,
                     false,
                     (FieldAccessMethod) &LogicOpChunkBase::getSFLogicOp)
};


FieldContainerType LogicOpChunkBase::_type(
    "LogicOpChunk",
    "StateChunk",
    NULL,
    (PrototypeCreateF) &LogicOpChunkBase::createEmpty,
    LogicOpChunk::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(LogicOpChunkBase, LogicOpChunkPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &LogicOpChunkBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &LogicOpChunkBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr LogicOpChunkBase::shallowCopy(void) const 
{ 
    LogicOpChunkPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const LogicOpChunk *>(this)); 

    return returnValue; 
}

UInt32 LogicOpChunkBase::getContainerSize(void) const 
{ 
    return sizeof(LogicOpChunk); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void LogicOpChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((LogicOpChunkBase *) &other, whichField);
}
#else
void LogicOpChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((LogicOpChunkBase *) &other, whichField, sInfo);
}
void LogicOpChunkBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void LogicOpChunkBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

LogicOpChunkBase::LogicOpChunkBase(void) :
    _sfLogicOp                (GLenum(GL_COPY)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

LogicOpChunkBase::LogicOpChunkBase(const LogicOpChunkBase &source) :
    _sfLogicOp                (source._sfLogicOp                ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

LogicOpChunkBase::~LogicOpChunkBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 LogicOpChunkBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (LogicOpFieldMask & whichField))
    {
        returnValue += _sfLogicOp.getBinSize();
    }


    return returnValue;
}

void LogicOpChunkBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (LogicOpFieldMask & whichField))
    {
        _sfLogicOp.copyToBin(pMem);
    }


}

void LogicOpChunkBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (LogicOpFieldMask & whichField))
    {
        _sfLogicOp.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void LogicOpChunkBase::executeSyncImpl(      LogicOpChunkBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (LogicOpFieldMask & whichField))
        _sfLogicOp.syncWith(pOther->_sfLogicOp);


}
#else
void LogicOpChunkBase::executeSyncImpl(      LogicOpChunkBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (LogicOpFieldMask & whichField))
        _sfLogicOp.syncWith(pOther->_sfLogicOp);



}

void LogicOpChunkBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<LogicOpChunkPtr>::_type("LogicOpChunkPtr", "StateChunkPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(LogicOpChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(LogicOpChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGLogicOpChunkBase.cpp,v 1.1 2007/06/25 14:32:45 neumannc Exp $";
    static Char8 cvsid_hpp       [] = OSGLOGICOPCHUNKBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGLOGICOPCHUNKBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGLOGICOPCHUNKFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

