/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CubeTextureChunk
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGCUBETEXTURECHUNKBASE_H_
#define _OSGCUBETEXTURECHUNKBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGTextureChunk.h> // Parent

#include <OSGImageFields.h> // PosZImage type
#include <OSGImageFields.h> // PosXImage type
#include <OSGImageFields.h> // NegXImage type
#include <OSGImageFields.h> // PosYImage type
#include <OSGImageFields.h> // NegYImage type
#include <OSGBoolFields.h> // IsReflectionMap type

#include <OSGCubeTextureChunkFields.h>

OSG_BEGIN_NAMESPACE

class CubeTextureChunk;
class BinaryDataHandler;

//! \brief CubeTextureChunk Base Class.

class OSG_SYSTEMLIB_DLLMAPPING CubeTextureChunkBase : public TextureChunk
{
  private:

    typedef TextureChunk    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef CubeTextureChunkPtr  Ptr;

    enum
    {
        PosZImageFieldId       = Inherited::NextFieldId,
        PosXImageFieldId       = PosZImageFieldId       + 1,
        NegXImageFieldId       = PosXImageFieldId       + 1,
        PosYImageFieldId       = NegXImageFieldId       + 1,
        NegYImageFieldId       = PosYImageFieldId       + 1,
        IsReflectionMapFieldId = NegYImageFieldId       + 1,
        NextFieldId            = IsReflectionMapFieldId + 1
    };

    static const OSG::BitVector PosZImageFieldMask;
    static const OSG::BitVector PosXImageFieldMask;
    static const OSG::BitVector NegXImageFieldMask;
    static const OSG::BitVector PosYImageFieldMask;
    static const OSG::BitVector NegYImageFieldMask;
    static const OSG::BitVector IsReflectionMapFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFImagePtr          *getSFPosZImage      (void);
           SFImagePtr          *getSFPosXImage      (void);
           SFImagePtr          *getSFNegXImage      (void);
           SFImagePtr          *getSFPosYImage      (void);
           SFImagePtr          *getSFNegYImage      (void);
           SFBool              *getSFIsReflectionMap(void);

           ImagePtr            &getPosZImage      (void);
     const ImagePtr            &getPosZImage      (void) const;
           ImagePtr            &getPosXImage      (void);
     const ImagePtr            &getPosXImage      (void) const;
           ImagePtr            &getNegXImage      (void);
     const ImagePtr            &getNegXImage      (void) const;
           ImagePtr            &getPosYImage      (void);
     const ImagePtr            &getPosYImage      (void) const;
           ImagePtr            &getNegYImage      (void);
     const ImagePtr            &getNegYImage      (void) const;
           bool                &getIsReflectionMap(void);
     const bool                &getIsReflectionMap(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setPosZImage      ( const ImagePtr &value );
     void setPosXImage      ( const ImagePtr &value );
     void setNegXImage      ( const ImagePtr &value );
     void setPosYImage      ( const ImagePtr &value );
     void setNegYImage      ( const ImagePtr &value );
     void setIsReflectionMap( const bool &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  CubeTextureChunkPtr      create          (void); 
    static  CubeTextureChunkPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFImagePtr          _sfPosZImage;
    SFImagePtr          _sfPosXImage;
    SFImagePtr          _sfNegXImage;
    SFImagePtr          _sfPosYImage;
    SFImagePtr          _sfNegYImage;
    SFBool              _sfIsReflectionMap;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    CubeTextureChunkBase(void);
    CubeTextureChunkBase(const CubeTextureChunkBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~CubeTextureChunkBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      CubeTextureChunkBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      CubeTextureChunkBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const CubeTextureChunkBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef CubeTextureChunkBase *CubeTextureChunkBaseP;

typedef osgIF<CubeTextureChunkBase::isNodeCore,
              CoredNodePtr<CubeTextureChunk>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet CubeTextureChunkNodePtr;

typedef RefPtr<CubeTextureChunkPtr> CubeTextureChunkRefPtr;

OSG_END_NAMESPACE

#define OSGCUBETEXTURECHUNKBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGCUBETEXTURECHUNKBASE_H_ */
