/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Surface!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESURFACEINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGSurfaceBase.h"
#include "OSGSurface.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  SurfaceBase::DimUFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::DimUFieldId);

const OSG::BitVector  SurfaceBase::DimVFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::DimVFieldId);

const OSG::BitVector  SurfaceBase::KnotsUFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::KnotsUFieldId);

const OSG::BitVector  SurfaceBase::KnotsVFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::KnotsVFieldId);

const OSG::BitVector  SurfaceBase::ControlPointsFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::ControlPointsFieldId);

const OSG::BitVector  SurfaceBase::ErrorFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::ErrorFieldId);

const OSG::BitVector  SurfaceBase::NumCurvesFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::NumCurvesFieldId);

const OSG::BitVector  SurfaceBase::KnotLengthsFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::KnotLengthsFieldId);

const OSG::BitVector  SurfaceBase::DimensionsFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::DimensionsFieldId);

const OSG::BitVector  SurfaceBase::CurveControlPointsFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::CurveControlPointsFieldId);

const OSG::BitVector  SurfaceBase::KnotsFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::KnotsFieldId);

const OSG::BitVector  SurfaceBase::CurvesPerLoopFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::CurvesPerLoopFieldId);

const OSG::BitVector  SurfaceBase::IsDelaunayFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::IsDelaunayFieldId);

const OSG::BitVector  SurfaceBase::TextureControlPointsFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::TextureControlPointsFieldId);

const OSG::BitVector  SurfaceBase::DirtyMaskFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::DirtyMaskFieldId);

const OSG::BitVector  SurfaceBase::SurfaceGLIdFieldMask = 
    (TypeTraits<BitVector>::One << SurfaceBase::SurfaceGLIdFieldId);

const OSG::BitVector SurfaceBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var UInt32          SurfaceBase::_sfDimU
    The surface dimension in U
*/
/*! \var UInt32          SurfaceBase::_sfDimV
    The surface dimension in V
*/
/*! \var Real32          SurfaceBase::_mfKnotsU
    The surface knots in U direction
*/
/*! \var Real32          SurfaceBase::_mfKnotsV
    The surface knots in V direction
*/
/*! \var GeoPositionsPtr SurfaceBase::_sfControlPoints
    The control points for the surface
*/
/*! \var Real32          SurfaceBase::_sfError
    The approximation error for the tessellation
*/
/*! \var UInt32          SurfaceBase::_sfNumCurves
    The number of trimming curves
*/
/*! \var UInt32          SurfaceBase::_mfKnotLengths
    The knotlengths for the trimming curves
*/
/*! \var UInt32          SurfaceBase::_mfDimensions
    The dimensions for the trimming curves
*/
/*! \var Pnt3f           SurfaceBase::_mfCurveControlPoints
    The control points for the trimming curves
*/
/*! \var Real32          SurfaceBase::_mfKnots
    The knotvectors for the trimming curves
*/
/*! \var UInt32          SurfaceBase::_mfCurvesPerLoop
    Specifies the number of trimming curves in each trimming curve loop
*/
/*! \var bool            SurfaceBase::_sfIsDelaunay
    Whether to use Delaunay triangulation. Default is no, because it's faster and slightly more robust numerically, but produces a somewhat less "nice" triangulation. Set to true, if you want Delaunay triangulation. The number of triangles generated is the same in both modes.
*/
/*! \var GeoTexCoordsPtr SurfaceBase::_sfTextureControlPoints
    The control points for textures (always 2D)
*/
/*! \var UInt32          SurfaceBase::_sfDirtyMask
    
*/
/*! \var Int32           SurfaceBase::_sfSurfaceGLId
    Surface GL Id, internal use.
*/

//! Surface description

FieldDescription *SurfaceBase::_desc[] = 
{
    new FieldDescription(SFUInt32::getClassType(), 
                     "dimU", 
                     DimUFieldId, DimUFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getSFDimU),
    new FieldDescription(SFUInt32::getClassType(), 
                     "dimV", 
                     DimVFieldId, DimVFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getSFDimV),
    new FieldDescription(MFReal32::getClassType(), 
                     "knotsU", 
                     KnotsUFieldId, KnotsUFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getMFKnotsU),
    new FieldDescription(MFReal32::getClassType(), 
                     "knotsV", 
                     KnotsVFieldId, KnotsVFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getMFKnotsV),
    new FieldDescription(SFGeoPositionsPtr::getClassType(), 
                     "controlPoints", 
                     ControlPointsFieldId, ControlPointsFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getSFControlPoints),
    new FieldDescription(SFReal32::getClassType(), 
                     "error", 
                     ErrorFieldId, ErrorFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getSFError),
    new FieldDescription(SFUInt32::getClassType(), 
                     "numCurves", 
                     NumCurvesFieldId, NumCurvesFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getSFNumCurves),
    new FieldDescription(MFUInt32::getClassType(), 
                     "knotLengths", 
                     KnotLengthsFieldId, KnotLengthsFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getMFKnotLengths),
    new FieldDescription(MFUInt32::getClassType(), 
                     "dimensions", 
                     DimensionsFieldId, DimensionsFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getMFDimensions),
    new FieldDescription(MFPnt3f::getClassType(), 
                     "curveControlPoints", 
                     CurveControlPointsFieldId, CurveControlPointsFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getMFCurveControlPoints),
    new FieldDescription(MFReal32::getClassType(), 
                     "knots", 
                     KnotsFieldId, KnotsFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getMFKnots),
    new FieldDescription(MFUInt32::getClassType(), 
                     "curvesPerLoop", 
                     CurvesPerLoopFieldId, CurvesPerLoopFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getMFCurvesPerLoop),
    new FieldDescription(SFBool::getClassType(), 
                     "isDelaunay", 
                     IsDelaunayFieldId, IsDelaunayFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getSFIsDelaunay),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "textureControlPoints", 
                     TextureControlPointsFieldId, TextureControlPointsFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getSFTextureControlPoints),
    new FieldDescription(SFUInt32::getClassType(), 
                     "dirtyMask", 
                     DirtyMaskFieldId, DirtyMaskFieldMask,
                     false,
                     (FieldAccessMethod) &SurfaceBase::getSFDirtyMask),
    new FieldDescription(SFInt32::getClassType(), 
                     "SurfaceGLId", 
                     SurfaceGLIdFieldId, SurfaceGLIdFieldMask,
                     true,
                     (FieldAccessMethod) &SurfaceBase::getSFSurfaceGLId)
};


FieldContainerType SurfaceBase::_type(
    "Surface",
    "Geometry",
    NULL,
    (PrototypeCreateF) &SurfaceBase::createEmpty,
    Surface::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(SurfaceBase, SurfacePtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &SurfaceBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &SurfaceBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr SurfaceBase::shallowCopy(void) const 
{ 
    SurfacePtr returnValue; 

    newPtr(returnValue, dynamic_cast<const Surface *>(this)); 

    return returnValue; 
}

UInt32 SurfaceBase::getContainerSize(void) const 
{ 
    return sizeof(Surface); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void SurfaceBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((SurfaceBase *) &other, whichField);
}
#else
void SurfaceBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((SurfaceBase *) &other, whichField, sInfo);
}
void SurfaceBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void SurfaceBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfKnotsU.terminateShare(uiAspect, this->getContainerSize());
    _mfKnotsV.terminateShare(uiAspect, this->getContainerSize());
    _mfKnotLengths.terminateShare(uiAspect, this->getContainerSize());
    _mfDimensions.terminateShare(uiAspect, this->getContainerSize());
    _mfCurveControlPoints.terminateShare(uiAspect, this->getContainerSize());
    _mfKnots.terminateShare(uiAspect, this->getContainerSize());
    _mfCurvesPerLoop.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

SurfaceBase::SurfaceBase(void) :
    _sfDimU                   (UInt32(0)), 
    _sfDimV                   (UInt32(0)), 
    _mfKnotsU                 (), 
    _mfKnotsV                 (), 
    _sfControlPoints          (), 
    _sfError                  (Real32(0.5)), 
    _sfNumCurves              (UInt32(0)), 
    _mfKnotLengths            (), 
    _mfDimensions             (), 
    _mfCurveControlPoints     (), 
    _mfKnots                  (), 
    _mfCurvesPerLoop          (), 
    _sfIsDelaunay             (bool(false)), 
    _sfTextureControlPoints   (), 
    _sfDirtyMask              (UInt32(0)), 
    _sfSurfaceGLId            (Int32(0)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

SurfaceBase::SurfaceBase(const SurfaceBase &source) :
    _sfDimU                   (source._sfDimU                   ), 
    _sfDimV                   (source._sfDimV                   ), 
    _mfKnotsU                 (source._mfKnotsU                 ), 
    _mfKnotsV                 (source._mfKnotsV                 ), 
    _sfControlPoints          (source._sfControlPoints          ), 
    _sfError                  (source._sfError                  ), 
    _sfNumCurves              (source._sfNumCurves              ), 
    _mfKnotLengths            (source._mfKnotLengths            ), 
    _mfDimensions             (source._mfDimensions             ), 
    _mfCurveControlPoints     (source._mfCurveControlPoints     ), 
    _mfKnots                  (source._mfKnots                  ), 
    _mfCurvesPerLoop          (source._mfCurvesPerLoop          ), 
    _sfIsDelaunay             (source._sfIsDelaunay             ), 
    _sfTextureControlPoints   (source._sfTextureControlPoints   ), 
    _sfDirtyMask              (source._sfDirtyMask              ), 
    _sfSurfaceGLId            (source._sfSurfaceGLId            ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

SurfaceBase::~SurfaceBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 SurfaceBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (DimUFieldMask & whichField))
    {
        returnValue += _sfDimU.getBinSize();
    }

    if(FieldBits::NoField != (DimVFieldMask & whichField))
    {
        returnValue += _sfDimV.getBinSize();
    }

    if(FieldBits::NoField != (KnotsUFieldMask & whichField))
    {
        returnValue += _mfKnotsU.getBinSize();
    }

    if(FieldBits::NoField != (KnotsVFieldMask & whichField))
    {
        returnValue += _mfKnotsV.getBinSize();
    }

    if(FieldBits::NoField != (ControlPointsFieldMask & whichField))
    {
        returnValue += _sfControlPoints.getBinSize();
    }

    if(FieldBits::NoField != (ErrorFieldMask & whichField))
    {
        returnValue += _sfError.getBinSize();
    }

    if(FieldBits::NoField != (NumCurvesFieldMask & whichField))
    {
        returnValue += _sfNumCurves.getBinSize();
    }

    if(FieldBits::NoField != (KnotLengthsFieldMask & whichField))
    {
        returnValue += _mfKnotLengths.getBinSize();
    }

    if(FieldBits::NoField != (DimensionsFieldMask & whichField))
    {
        returnValue += _mfDimensions.getBinSize();
    }

    if(FieldBits::NoField != (CurveControlPointsFieldMask & whichField))
    {
        returnValue += _mfCurveControlPoints.getBinSize();
    }

    if(FieldBits::NoField != (KnotsFieldMask & whichField))
    {
        returnValue += _mfKnots.getBinSize();
    }

    if(FieldBits::NoField != (CurvesPerLoopFieldMask & whichField))
    {
        returnValue += _mfCurvesPerLoop.getBinSize();
    }

    if(FieldBits::NoField != (IsDelaunayFieldMask & whichField))
    {
        returnValue += _sfIsDelaunay.getBinSize();
    }

    if(FieldBits::NoField != (TextureControlPointsFieldMask & whichField))
    {
        returnValue += _sfTextureControlPoints.getBinSize();
    }

    if(FieldBits::NoField != (DirtyMaskFieldMask & whichField))
    {
        returnValue += _sfDirtyMask.getBinSize();
    }

    if(FieldBits::NoField != (SurfaceGLIdFieldMask & whichField))
    {
        returnValue += _sfSurfaceGLId.getBinSize();
    }


    return returnValue;
}

void SurfaceBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (DimUFieldMask & whichField))
    {
        _sfDimU.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DimVFieldMask & whichField))
    {
        _sfDimV.copyToBin(pMem);
    }

    if(FieldBits::NoField != (KnotsUFieldMask & whichField))
    {
        _mfKnotsU.copyToBin(pMem);
    }

    if(FieldBits::NoField != (KnotsVFieldMask & whichField))
    {
        _mfKnotsV.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ControlPointsFieldMask & whichField))
    {
        _sfControlPoints.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ErrorFieldMask & whichField))
    {
        _sfError.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NumCurvesFieldMask & whichField))
    {
        _sfNumCurves.copyToBin(pMem);
    }

    if(FieldBits::NoField != (KnotLengthsFieldMask & whichField))
    {
        _mfKnotLengths.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DimensionsFieldMask & whichField))
    {
        _mfDimensions.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CurveControlPointsFieldMask & whichField))
    {
        _mfCurveControlPoints.copyToBin(pMem);
    }

    if(FieldBits::NoField != (KnotsFieldMask & whichField))
    {
        _mfKnots.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CurvesPerLoopFieldMask & whichField))
    {
        _mfCurvesPerLoop.copyToBin(pMem);
    }

    if(FieldBits::NoField != (IsDelaunayFieldMask & whichField))
    {
        _sfIsDelaunay.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TextureControlPointsFieldMask & whichField))
    {
        _sfTextureControlPoints.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMaskFieldMask & whichField))
    {
        _sfDirtyMask.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SurfaceGLIdFieldMask & whichField))
    {
        _sfSurfaceGLId.copyToBin(pMem);
    }


}

void SurfaceBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (DimUFieldMask & whichField))
    {
        _sfDimU.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DimVFieldMask & whichField))
    {
        _sfDimV.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (KnotsUFieldMask & whichField))
    {
        _mfKnotsU.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (KnotsVFieldMask & whichField))
    {
        _mfKnotsV.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ControlPointsFieldMask & whichField))
    {
        _sfControlPoints.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ErrorFieldMask & whichField))
    {
        _sfError.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NumCurvesFieldMask & whichField))
    {
        _sfNumCurves.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (KnotLengthsFieldMask & whichField))
    {
        _mfKnotLengths.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DimensionsFieldMask & whichField))
    {
        _mfDimensions.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CurveControlPointsFieldMask & whichField))
    {
        _mfCurveControlPoints.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (KnotsFieldMask & whichField))
    {
        _mfKnots.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CurvesPerLoopFieldMask & whichField))
    {
        _mfCurvesPerLoop.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (IsDelaunayFieldMask & whichField))
    {
        _sfIsDelaunay.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TextureControlPointsFieldMask & whichField))
    {
        _sfTextureControlPoints.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DirtyMaskFieldMask & whichField))
    {
        _sfDirtyMask.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SurfaceGLIdFieldMask & whichField))
    {
        _sfSurfaceGLId.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void SurfaceBase::executeSyncImpl(      SurfaceBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (DimUFieldMask & whichField))
        _sfDimU.syncWith(pOther->_sfDimU);

    if(FieldBits::NoField != (DimVFieldMask & whichField))
        _sfDimV.syncWith(pOther->_sfDimV);

    if(FieldBits::NoField != (KnotsUFieldMask & whichField))
        _mfKnotsU.syncWith(pOther->_mfKnotsU);

    if(FieldBits::NoField != (KnotsVFieldMask & whichField))
        _mfKnotsV.syncWith(pOther->_mfKnotsV);

    if(FieldBits::NoField != (ControlPointsFieldMask & whichField))
        _sfControlPoints.syncWith(pOther->_sfControlPoints);

    if(FieldBits::NoField != (ErrorFieldMask & whichField))
        _sfError.syncWith(pOther->_sfError);

    if(FieldBits::NoField != (NumCurvesFieldMask & whichField))
        _sfNumCurves.syncWith(pOther->_sfNumCurves);

    if(FieldBits::NoField != (KnotLengthsFieldMask & whichField))
        _mfKnotLengths.syncWith(pOther->_mfKnotLengths);

    if(FieldBits::NoField != (DimensionsFieldMask & whichField))
        _mfDimensions.syncWith(pOther->_mfDimensions);

    if(FieldBits::NoField != (CurveControlPointsFieldMask & whichField))
        _mfCurveControlPoints.syncWith(pOther->_mfCurveControlPoints);

    if(FieldBits::NoField != (KnotsFieldMask & whichField))
        _mfKnots.syncWith(pOther->_mfKnots);

    if(FieldBits::NoField != (CurvesPerLoopFieldMask & whichField))
        _mfCurvesPerLoop.syncWith(pOther->_mfCurvesPerLoop);

    if(FieldBits::NoField != (IsDelaunayFieldMask & whichField))
        _sfIsDelaunay.syncWith(pOther->_sfIsDelaunay);

    if(FieldBits::NoField != (TextureControlPointsFieldMask & whichField))
        _sfTextureControlPoints.syncWith(pOther->_sfTextureControlPoints);

    if(FieldBits::NoField != (DirtyMaskFieldMask & whichField))
        _sfDirtyMask.syncWith(pOther->_sfDirtyMask);

    if(FieldBits::NoField != (SurfaceGLIdFieldMask & whichField))
        _sfSurfaceGLId.syncWith(pOther->_sfSurfaceGLId);


}
#else
void SurfaceBase::executeSyncImpl(      SurfaceBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (DimUFieldMask & whichField))
        _sfDimU.syncWith(pOther->_sfDimU);

    if(FieldBits::NoField != (DimVFieldMask & whichField))
        _sfDimV.syncWith(pOther->_sfDimV);

    if(FieldBits::NoField != (ControlPointsFieldMask & whichField))
        _sfControlPoints.syncWith(pOther->_sfControlPoints);

    if(FieldBits::NoField != (ErrorFieldMask & whichField))
        _sfError.syncWith(pOther->_sfError);

    if(FieldBits::NoField != (NumCurvesFieldMask & whichField))
        _sfNumCurves.syncWith(pOther->_sfNumCurves);

    if(FieldBits::NoField != (IsDelaunayFieldMask & whichField))
        _sfIsDelaunay.syncWith(pOther->_sfIsDelaunay);

    if(FieldBits::NoField != (TextureControlPointsFieldMask & whichField))
        _sfTextureControlPoints.syncWith(pOther->_sfTextureControlPoints);

    if(FieldBits::NoField != (DirtyMaskFieldMask & whichField))
        _sfDirtyMask.syncWith(pOther->_sfDirtyMask);

    if(FieldBits::NoField != (SurfaceGLIdFieldMask & whichField))
        _sfSurfaceGLId.syncWith(pOther->_sfSurfaceGLId);


    if(FieldBits::NoField != (KnotsUFieldMask & whichField))
        _mfKnotsU.syncWith(pOther->_mfKnotsU, sInfo);

    if(FieldBits::NoField != (KnotsVFieldMask & whichField))
        _mfKnotsV.syncWith(pOther->_mfKnotsV, sInfo);

    if(FieldBits::NoField != (KnotLengthsFieldMask & whichField))
        _mfKnotLengths.syncWith(pOther->_mfKnotLengths, sInfo);

    if(FieldBits::NoField != (DimensionsFieldMask & whichField))
        _mfDimensions.syncWith(pOther->_mfDimensions, sInfo);

    if(FieldBits::NoField != (CurveControlPointsFieldMask & whichField))
        _mfCurveControlPoints.syncWith(pOther->_mfCurveControlPoints, sInfo);

    if(FieldBits::NoField != (KnotsFieldMask & whichField))
        _mfKnots.syncWith(pOther->_mfKnots, sInfo);

    if(FieldBits::NoField != (CurvesPerLoopFieldMask & whichField))
        _mfCurvesPerLoop.syncWith(pOther->_mfCurvesPerLoop, sInfo);


}

void SurfaceBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (KnotsUFieldMask & whichField))
        _mfKnotsU.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (KnotsVFieldMask & whichField))
        _mfKnotsV.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (KnotLengthsFieldMask & whichField))
        _mfKnotLengths.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (DimensionsFieldMask & whichField))
        _mfDimensions.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (CurveControlPointsFieldMask & whichField))
        _mfCurveControlPoints.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (KnotsFieldMask & whichField))
        _mfKnots.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (CurvesPerLoopFieldMask & whichField))
        _mfCurvesPerLoop.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<SurfacePtr>::_type("SurfacePtr", "GeometryPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(SurfacePtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(SurfacePtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.47 2006/03/17 17:03:19 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGSURFACEBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSURFACEBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSURFACEFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

