/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class MultiPassMaterial!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEMULTIPASSMATERIALINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGMultiPassMaterialBase.h"
#include "OSGMultiPassMaterial.h"


OSG_USING_NAMESPACE

const OSG::BitVector  MultiPassMaterialBase::MaterialsFieldMask = 
    (TypeTraits<BitVector>::One << MultiPassMaterialBase::MaterialsFieldId);

const OSG::BitVector MultiPassMaterialBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var MaterialPtr     MultiPassMaterialBase::_mfMaterials
    
*/

//! MultiPassMaterial description

FieldDescription *MultiPassMaterialBase::_desc[] = 
{
    new FieldDescription(MFMaterialPtr::getClassType(), 
                     "materials", 
                     MaterialsFieldId, MaterialsFieldMask,
                     false,
                     (FieldAccessMethod) &MultiPassMaterialBase::getMFMaterials)
};


FieldContainerType MultiPassMaterialBase::_type(
    "MultiPassMaterial",
    "Material",
    NULL,
    (PrototypeCreateF) &MultiPassMaterialBase::createEmpty,
    MultiPassMaterial::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(MultiPassMaterialBase, MultiPassMaterialPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &MultiPassMaterialBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &MultiPassMaterialBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr MultiPassMaterialBase::shallowCopy(void) const 
{ 
    MultiPassMaterialPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const MultiPassMaterial *>(this)); 

    return returnValue; 
}

UInt32 MultiPassMaterialBase::getContainerSize(void) const 
{ 
    return sizeof(MultiPassMaterial); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void MultiPassMaterialBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((MultiPassMaterialBase *) &other, whichField);
}
#else
void MultiPassMaterialBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((MultiPassMaterialBase *) &other, whichField, sInfo);
}
void MultiPassMaterialBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void MultiPassMaterialBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfMaterials.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

MultiPassMaterialBase::MultiPassMaterialBase(void) :
    _mfMaterials              (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

MultiPassMaterialBase::MultiPassMaterialBase(const MultiPassMaterialBase &source) :
    _mfMaterials              (source._mfMaterials              ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

MultiPassMaterialBase::~MultiPassMaterialBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 MultiPassMaterialBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
    {
        returnValue += _mfMaterials.getBinSize();
    }


    return returnValue;
}

void MultiPassMaterialBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
    {
        _mfMaterials.copyToBin(pMem);
    }


}

void MultiPassMaterialBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
    {
        _mfMaterials.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void MultiPassMaterialBase::executeSyncImpl(      MultiPassMaterialBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
        _mfMaterials.syncWith(pOther->_mfMaterials);


}
#else
void MultiPassMaterialBase::executeSyncImpl(      MultiPassMaterialBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);


    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
        _mfMaterials.syncWith(pOther->_mfMaterials, sInfo);


}

void MultiPassMaterialBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
        _mfMaterials.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<MultiPassMaterialPtr>::_type("MultiPassMaterialPtr", "MaterialPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(MultiPassMaterialPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(MultiPassMaterialPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGMultiPassMaterialBase.cpp,v 1.6 2006/02/20 17:04:43 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGMULTIPASSMATERIALBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGMULTIPASSMATERIALBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGMULTIPASSMATERIALFIELDS_HEADER_CVSID;
}

