/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ImageComposer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEIMAGECOMPOSERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGImageComposerBase.h"
#include "OSGImageComposer.h"


OSG_USING_NAMESPACE

const OSG::BitVector  ImageComposerBase::EnabledFieldMask = 
    (TypeTraits<BitVector>::One << ImageComposerBase::EnabledFieldId);

const OSG::BitVector  ImageComposerBase::StatisticsFieldMask = 
    (TypeTraits<BitVector>::One << ImageComposerBase::StatisticsFieldId);

const OSG::BitVector ImageComposerBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var bool            ImageComposerBase::_sfEnabled
    Do composition if value is true
*/
/*! \var bool            ImageComposerBase::_sfStatistics
    
*/

//! ImageComposer description

FieldDescription *ImageComposerBase::_desc[] = 
{
    new FieldDescription(SFBool::getClassType(), 
                     "enabled", 
                     EnabledFieldId, EnabledFieldMask,
                     false,
                     (FieldAccessMethod) &ImageComposerBase::getSFEnabled),
    new FieldDescription(SFBool::getClassType(), 
                     "statistics", 
                     StatisticsFieldId, StatisticsFieldMask,
                     false,
                     (FieldAccessMethod) &ImageComposerBase::getSFStatistics)
};


FieldContainerType ImageComposerBase::_type(
    "ImageComposer",
    "AttachmentContainer",
    NULL,
    NULL, 
    ImageComposer::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ImageComposerBase, ImageComposerPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ImageComposerBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ImageComposerBase::getType(void) const 
{
    return _type;
} 


UInt32 ImageComposerBase::getContainerSize(void) const 
{ 
    return sizeof(ImageComposer); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ImageComposerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ImageComposerBase *) &other, whichField);
}
#else
void ImageComposerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ImageComposerBase *) &other, whichField, sInfo);
}
void ImageComposerBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ImageComposerBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ImageComposerBase::ImageComposerBase(void) :
    _sfEnabled                (bool(true)), 
    _sfStatistics             (bool(false)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ImageComposerBase::ImageComposerBase(const ImageComposerBase &source) :
    _sfEnabled                (source._sfEnabled                ), 
    _sfStatistics             (source._sfStatistics             ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ImageComposerBase::~ImageComposerBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ImageComposerBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (EnabledFieldMask & whichField))
    {
        returnValue += _sfEnabled.getBinSize();
    }

    if(FieldBits::NoField != (StatisticsFieldMask & whichField))
    {
        returnValue += _sfStatistics.getBinSize();
    }


    return returnValue;
}

void ImageComposerBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (EnabledFieldMask & whichField))
    {
        _sfEnabled.copyToBin(pMem);
    }

    if(FieldBits::NoField != (StatisticsFieldMask & whichField))
    {
        _sfStatistics.copyToBin(pMem);
    }


}

void ImageComposerBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (EnabledFieldMask & whichField))
    {
        _sfEnabled.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (StatisticsFieldMask & whichField))
    {
        _sfStatistics.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ImageComposerBase::executeSyncImpl(      ImageComposerBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (EnabledFieldMask & whichField))
        _sfEnabled.syncWith(pOther->_sfEnabled);

    if(FieldBits::NoField != (StatisticsFieldMask & whichField))
        _sfStatistics.syncWith(pOther->_sfStatistics);


}
#else
void ImageComposerBase::executeSyncImpl(      ImageComposerBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (EnabledFieldMask & whichField))
        _sfEnabled.syncWith(pOther->_sfEnabled);

    if(FieldBits::NoField != (StatisticsFieldMask & whichField))
        _sfStatistics.syncWith(pOther->_sfStatistics);



}

void ImageComposerBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ImageComposerPtr>::_type("ImageComposerPtr", "AttachmentContainerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ImageComposerPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ImageComposerPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGIMAGECOMPOSERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGIMAGECOMPOSERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGIMAGECOMPOSERFIELDS_HEADER_CVSID;
}

