/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class TestingExtendActor
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#ifndef _OSGTESTINGEXTENDACTORBASE_H_
#define _OSGTESTINGEXTENDACTORBASE_H_
#ifdef __sgi
#pragma once
#endif

#include <OSGConfig.h>

#include <OSGSystemDef.h>

#include <OSGNewActionTypes.h>
#include <OSGExtendActorBase.h>               // Parent
#include <OSGMultiFunctorStore.h>      // EnterStore
#include <OSGMultiFunctorStore.h>      // LeaveStore

#include <OSGBaseTypes.h>   // TreeLevel type
#include <OSGMatrix.h>   // WorldMatrix type

OSG_BEGIN_NAMESPACE

class OSG_SYSTEMLIB_DLLMAPPING TestingExtendActorBase : public ExtendActorBase
{
    /*====  PUBLIC  =========================================================*/
  public:
    /*---------------------------------------- ------------------------------*/
    /*! \name    Types                                                       */
    /*! \{                                                                   */

    typedef ExtendActorBase::ResultE ResultE;
    typedef ExtendActorBase::Functor Functor;

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Destructor                                                  */
    /*! \{                                                                   */

    virtual ~TestingExtendActorBase(void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Start/Stop                                                  */
    /*! \{                                                                   */

    virtual ResultE start(void);
    virtual ResultE stop (void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Enter/Leave                                                 */
    /*! \{                                                                   */

    virtual ResultE enterNode(FunctorArgumentType &funcArg);
    virtual ResultE leaveNode(FunctorArgumentType &funcArg);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Enter Registration                                          */
    /*! \{                                                                   */

    static void regClassEnter         (const Functor            &refFunc,
                                       const FieldContainerType &refType );
           void regEnter              (const Functor            &refFunc,
                                       const FieldContainerType &refType );
    static void regDefaultClassEnter  (const Functor            &refFunc );
           void regDefaultEnter       (const Functor            &refFunc );

    static void unregClassEnter       (const FieldContainerType &refType );
           void unregEnter            (const FieldContainerType &refType );
    static void unregDefaultClassEnter(      void                        );
           void unregDefaultEnter     (      void                        );
    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Leave Registration                                          */
    /*! \{                                                                   */

    static void regClassLeave         (const Functor            &refFunc,
                                       const FieldContainerType &refType );
           void regLeave              (const Functor            &refFunc,
                                       const FieldContainerType &refType );
    static void regDefaultClassLeave  (const Functor            &refFunc );
           void regDefaultLeave       (const Functor            &refFunc );

    static void unregClassLeave       (const FieldContainerType &refType );
           void unregLeave            (const FieldContainerType &refType );
    static void unregDefaultClassLeave(      void                        );
           void unregDefaultLeave     (      void                        );

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Public State Access                                         */
    /*! \{                                                                   */

    inline const UInt32 &getTreeLevel(void                             ) const;
    inline       UInt32 &getTreeLevel(void                             );
    inline       void               setTreeLevel(const UInt32 &stateVal);
    inline const Matrix &getWorldMatrix(void                             ) const;
    inline       Matrix &getWorldMatrix(void                             );
    inline       void               setWorldMatrix(const Matrix &stateVal);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Management                                            */
    /*! \{                                                                   */

#ifdef OSG_NEWACTION_STATESLOTINTERFACE
    virtual UInt32          createStateClone  (void                       );
    virtual void            destroyStateClone (UInt32          slotId     );
#else
    virtual ActorBaseState *createStateClone  (void                       );
    virtual void            destroyStateClone (ActorBaseState *pStateClone);
#endif

    virtual void            createInitialState(void                       );
    virtual void            deleteInitialState(void                       );

    /*! \}                                                                   */
    /*====  PROTECTED  ======================================================*/
  protected:
    /*-----------------------------------------------------------------------*/
    /*! \name    Types & Friends                                             */
    /*! \{                                                                   */

    class   TestingExtendActorBaseState;
    friend  class OSG::TestingExtendActorBase::TestingExtendActorBaseState;

    typedef TestingExtendActorBaseState     StateType;
    typedef ExtendActorBase::StateType  ParentStateType;
    typedef MultiFunctorStore EnterStoreType;
    typedef MultiFunctorStore LeaveStoreType;

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Class                                                 */
    /*! \{                                                                   */

    class OSG_SYSTEMLIB_DLLMAPPING TestingExtendActorBaseState : public ParentStateType
    {
      public:
        inline   TestingExtendActorBaseState(void                                );
        inline   TestingExtendActorBaseState(const TestingExtendActorBaseState &source);

        virtual ~TestingExtendActorBaseState(void                                );

        inline const UInt32 &getTreeLevel(void) const;
        inline       UInt32 &getTreeLevel(void);
        inline const Matrix &getWorldMatrix(void) const;
        inline       Matrix &getWorldMatrix(void);

      private:
        UInt32 _stateTreeLevel;
        Matrix _stateWorldMatrix;
    };

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Constructor                                                 */
    /*! \{                                                                   */

    TestingExtendActorBase(void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Event Notification                                          */
    /*! \{                                                                   */

    virtual void addEvent(NewActionBase *pAction, UInt32 actorId);
    virtual void subEvent(NewActionBase *pAction, UInt32 actorId);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Access                                                */
    /*! \{                                                                   */

    inline const TestingExtendActorBaseState *getCastState(void) const;
    inline       TestingExtendActorBaseState *getCastState(void);


    /*! \}                                                                   */
    /*====  PRIVATE  ========================================================*/
  private:
    typedef ExtendActorBase Inherited;

    static EnterStoreType *_pClassEnterStore;
    static LeaveStoreType *_pClassLeaveStore;


    EnterStoreType         _instanceEnterStore;
    LeaveStoreType         _instanceLeaveStore;
};

OSG_END_NAMESPACE

#include <OSGTestingExtendActorBase.inl>

#define OSGTESTINGEXTENDACTORBASE_HEADER_CVSID "@(#)$Id:"

#endif /* _OSGTESTINGEXTENDACTORBASE_H_ */
