/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class AVCodecGrabForeground
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGAVCODECGRABFOREGROUNDBASE_H_
#define _OSGAVCODECGRABFOREGROUNDBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGContribDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGGrabForeground.h> // Parent

#include <OSGBoolFields.h> // Active type
#include <OSGStringFields.h> // Name type
#include <OSGUInt32Fields.h> // Kbit type
#include <OSGUInt32Fields.h> // Fps type
#include <OSGUInt32Fields.h> // Codecid type
#include <OSGBoolFields.h> // Flip type
#include <OSGBoolFields.h> // AutoWrite type

#include <OSGAVCodecGrabForegroundFields.h>

OSG_BEGIN_NAMESPACE

class AVCodecGrabForeground;
class BinaryDataHandler;

//! \brief AVCodecGrabForeground Base Class.

class OSG_CONTRIBLIB_DLLMAPPING AVCodecGrabForegroundBase : public GrabForeground
{
  private:

    typedef GrabForeground    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef AVCodecGrabForegroundPtr  Ptr;

    enum
    {
        ActiveFieldId    = Inherited::NextFieldId,
        NameFieldId      = ActiveFieldId    + 1,
        KbitFieldId      = NameFieldId      + 1,
        FpsFieldId       = KbitFieldId      + 1,
        CodecidFieldId   = FpsFieldId       + 1,
        FlipFieldId      = CodecidFieldId   + 1,
        AutoWriteFieldId = FlipFieldId      + 1,
        NextFieldId      = AutoWriteFieldId + 1
    };

    static const OSG::BitVector ActiveFieldMask;
    static const OSG::BitVector NameFieldMask;
    static const OSG::BitVector KbitFieldMask;
    static const OSG::BitVector FpsFieldMask;
    static const OSG::BitVector CodecidFieldMask;
    static const OSG::BitVector FlipFieldMask;
    static const OSG::BitVector AutoWriteFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFBool              *getSFActive         (void);
           SFString            *getSFName           (void);
           SFUInt32            *getSFKbit           (void);
           SFUInt32            *getSFFps            (void);
           SFUInt32            *getSFCodecid        (void);
           SFBool              *getSFFlip           (void);
           SFBool              *getSFAutoWrite      (void);

           bool                &getActive         (void);
     const bool                &getActive         (void) const;
           std::string         &getName           (void);
     const std::string         &getName           (void) const;
           UInt32              &getKbit           (void);
     const UInt32              &getKbit           (void) const;
           UInt32              &getFps            (void);
     const UInt32              &getFps            (void) const;
           UInt32              &getCodecid        (void);
     const UInt32              &getCodecid        (void) const;
           bool                &getFlip           (void);
     const bool                &getFlip           (void) const;
           bool                &getAutoWrite      (void);
     const bool                &getAutoWrite      (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setActive         ( const bool &value );
     void setName           ( const std::string &value );
     void setKbit           ( const UInt32 &value );
     void setFps            ( const UInt32 &value );
     void setCodecid        ( const UInt32 &value );
     void setFlip           ( const bool &value );
     void setAutoWrite      ( const bool &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  AVCodecGrabForegroundPtr      create          (void); 
    static  AVCodecGrabForegroundPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFBool              _sfActive;
    SFString            _sfName;
    SFUInt32            _sfKbit;
    SFUInt32            _sfFps;
    SFUInt32            _sfCodecid;
    SFBool              _sfFlip;
    SFBool              _sfAutoWrite;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    AVCodecGrabForegroundBase(void);
    AVCodecGrabForegroundBase(const AVCodecGrabForegroundBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~AVCodecGrabForegroundBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      AVCodecGrabForegroundBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      AVCodecGrabForegroundBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const AVCodecGrabForegroundBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef AVCodecGrabForegroundBase *AVCodecGrabForegroundBaseP;

typedef osgIF<AVCodecGrabForegroundBase::isNodeCore,
              CoredNodePtr<AVCodecGrabForeground>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet AVCodecGrabForegroundNodePtr;

typedef RefPtr<AVCodecGrabForegroundPtr> AVCodecGrabForegroundRefPtr;

OSG_END_NAMESPACE

#define OSGAVCODECGRABFOREGROUNDBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGAVCODECGRABFOREGROUNDBASE_H_ */
