/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class TiledTerrain!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILETILEDTERRAININST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGTiledTerrainBase.h"
#include "OSGTiledTerrain.h"


OSG_USING_NAMESPACE

const OSG::BitVector  TiledTerrainBase::HeightTilesFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::HeightTilesFieldId);

const OSG::BitVector  TiledTerrainBase::HeightTexturesFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::HeightTexturesFieldId);

const OSG::BitVector  TiledTerrainBase::SizeXFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::SizeXFieldId);

const OSG::BitVector  TiledTerrainBase::SizeYFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::SizeYFieldId);

const OSG::BitVector  TiledTerrainBase::HeightScaleFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::HeightScaleFieldId);

const OSG::BitVector  TiledTerrainBase::VertexSpacingFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::VertexSpacingFieldId);

const OSG::BitVector  TiledTerrainBase::GeoMorphingFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::GeoMorphingFieldId);

const OSG::BitVector  TiledTerrainBase::DetailFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::DetailFieldId);

const OSG::BitVector  TiledTerrainBase::CurrentXFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::CurrentXFieldId);

const OSG::BitVector  TiledTerrainBase::CurrentYFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::CurrentYFieldId);

const OSG::BitVector  TiledTerrainBase::SizeROIFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::SizeROIFieldId);

const OSG::BitVector  TiledTerrainBase::UpdateFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::UpdateFieldId);

const OSG::BitVector  TiledTerrainBase::UpdateTerrainFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::UpdateTerrainFieldId);

const OSG::BitVector  TiledTerrainBase::PerPixelLightingFieldMask = 
    (TypeTraits<BitVector>::One << TiledTerrainBase::PerPixelLightingFieldId);

const OSG::BitVector TiledTerrainBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var ImagePtr        TiledTerrainBase::_mfHeightTiles
    Terrain tile array
*/
/*! \var MaterialPtr     TiledTerrainBase::_mfHeightTextures
    Terrain textures
*/
/*! \var UInt32          TiledTerrainBase::_sfSizeX
    x-size of 2-dimensional tile array
*/
/*! \var UInt32          TiledTerrainBase::_sfSizeY
    y-size of 2-dimensional tile array
*/
/*! \var Real32          TiledTerrainBase::_sfHeightScale
    
*/
/*! \var Real32          TiledTerrainBase::_sfVertexSpacing
    
*/
/*! \var bool            TiledTerrainBase::_sfGeoMorphing
    
*/
/*! \var Real32          TiledTerrainBase::_sfDetail
    detail of terrain tesselation
*/
/*! \var Int32           TiledTerrainBase::_sfCurrentX
    
*/
/*! \var Int32           TiledTerrainBase::_sfCurrentY
    
*/
/*! \var Int32           TiledTerrainBase::_sfSizeROI
    number of tiles (0, 1, 2, 3) around current eye point
*/
/*! \var bool            TiledTerrainBase::_sfUpdate
    perform any updates (tiling, terrain tiles)
*/
/*! \var bool            TiledTerrainBase::_sfUpdateTerrain
    update terrain tiles in the next frame
*/
/*! \var bool            TiledTerrainBase::_sfPerPixelLighting
    Do per-pixel lighting with normalmap; otherwise generate per-vertex normals
*/

//! TiledTerrain description

FieldDescription *TiledTerrainBase::_desc[] = 
{
    new FieldDescription(MFImagePtr::getClassType(), 
                     "heightTiles", 
                     HeightTilesFieldId, HeightTilesFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getMFHeightTiles),
    new FieldDescription(MFMaterialPtr::getClassType(), 
                     "heightTextures", 
                     HeightTexturesFieldId, HeightTexturesFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getMFHeightTextures),
    new FieldDescription(SFUInt32::getClassType(), 
                     "sizeX", 
                     SizeXFieldId, SizeXFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFSizeX),
    new FieldDescription(SFUInt32::getClassType(), 
                     "sizeY", 
                     SizeYFieldId, SizeYFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFSizeY),
    new FieldDescription(SFReal32::getClassType(), 
                     "heightScale", 
                     HeightScaleFieldId, HeightScaleFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFHeightScale),
    new FieldDescription(SFReal32::getClassType(), 
                     "vertexSpacing", 
                     VertexSpacingFieldId, VertexSpacingFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFVertexSpacing),
    new FieldDescription(SFBool::getClassType(), 
                     "geoMorphing", 
                     GeoMorphingFieldId, GeoMorphingFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFGeoMorphing),
    new FieldDescription(SFReal32::getClassType(), 
                     "detail", 
                     DetailFieldId, DetailFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFDetail),
    new FieldDescription(SFInt32::getClassType(), 
                     "currentX", 
                     CurrentXFieldId, CurrentXFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFCurrentX),
    new FieldDescription(SFInt32::getClassType(), 
                     "currentY", 
                     CurrentYFieldId, CurrentYFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFCurrentY),
    new FieldDescription(SFInt32::getClassType(), 
                     "sizeROI", 
                     SizeROIFieldId, SizeROIFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFSizeROI),
    new FieldDescription(SFBool::getClassType(), 
                     "update", 
                     UpdateFieldId, UpdateFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFUpdate),
    new FieldDescription(SFBool::getClassType(), 
                     "updateTerrain", 
                     UpdateTerrainFieldId, UpdateTerrainFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFUpdateTerrain),
    new FieldDescription(SFBool::getClassType(), 
                     "perPixelLighting", 
                     PerPixelLightingFieldId, PerPixelLightingFieldMask,
                     false,
                     (FieldAccessMethod) &TiledTerrainBase::getSFPerPixelLighting)
};


FieldContainerType TiledTerrainBase::_type(
    "TiledTerrain",
    "MaterialGroup",
    NULL,
    (PrototypeCreateF) &TiledTerrainBase::createEmpty,
    TiledTerrain::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(TiledTerrainBase, TiledTerrainPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &TiledTerrainBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &TiledTerrainBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr TiledTerrainBase::shallowCopy(void) const 
{ 
    TiledTerrainPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const TiledTerrain *>(this)); 

    return returnValue; 
}

UInt32 TiledTerrainBase::getContainerSize(void) const 
{ 
    return sizeof(TiledTerrain); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void TiledTerrainBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((TiledTerrainBase *) &other, whichField);
}
#else
void TiledTerrainBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((TiledTerrainBase *) &other, whichField, sInfo);
}
void TiledTerrainBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void TiledTerrainBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfHeightTiles.terminateShare(uiAspect, this->getContainerSize());
    _mfHeightTextures.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

TiledTerrainBase::TiledTerrainBase(void) :
    _mfHeightTiles            (), 
    _mfHeightTextures         (), 
    _sfSizeX                  (UInt32(1)), 
    _sfSizeY                  (UInt32(1)), 
    _sfHeightScale            (Real32(1.0f)), 
    _sfVertexSpacing          (Real32(0.1f)), 
    _sfGeoMorphing            (bool(false)), 
    _sfDetail                 (Real32(22.0f)), 
    _sfCurrentX               (Int32(0)), 
    _sfCurrentY               (Int32(0)), 
    _sfSizeROI                (Int32(1)), 
    _sfUpdate                 (bool(true)), 
    _sfUpdateTerrain          (bool(false)), 
    _sfPerPixelLighting       (bool(true)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

TiledTerrainBase::TiledTerrainBase(const TiledTerrainBase &source) :
    _mfHeightTiles            (source._mfHeightTiles            ), 
    _mfHeightTextures         (source._mfHeightTextures         ), 
    _sfSizeX                  (source._sfSizeX                  ), 
    _sfSizeY                  (source._sfSizeY                  ), 
    _sfHeightScale            (source._sfHeightScale            ), 
    _sfVertexSpacing          (source._sfVertexSpacing          ), 
    _sfGeoMorphing            (source._sfGeoMorphing            ), 
    _sfDetail                 (source._sfDetail                 ), 
    _sfCurrentX               (source._sfCurrentX               ), 
    _sfCurrentY               (source._sfCurrentY               ), 
    _sfSizeROI                (source._sfSizeROI                ), 
    _sfUpdate                 (source._sfUpdate                 ), 
    _sfUpdateTerrain          (source._sfUpdateTerrain          ), 
    _sfPerPixelLighting       (source._sfPerPixelLighting       ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

TiledTerrainBase::~TiledTerrainBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 TiledTerrainBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (HeightTilesFieldMask & whichField))
    {
        returnValue += _mfHeightTiles.getBinSize();
    }

    if(FieldBits::NoField != (HeightTexturesFieldMask & whichField))
    {
        returnValue += _mfHeightTextures.getBinSize();
    }

    if(FieldBits::NoField != (SizeXFieldMask & whichField))
    {
        returnValue += _sfSizeX.getBinSize();
    }

    if(FieldBits::NoField != (SizeYFieldMask & whichField))
    {
        returnValue += _sfSizeY.getBinSize();
    }

    if(FieldBits::NoField != (HeightScaleFieldMask & whichField))
    {
        returnValue += _sfHeightScale.getBinSize();
    }

    if(FieldBits::NoField != (VertexSpacingFieldMask & whichField))
    {
        returnValue += _sfVertexSpacing.getBinSize();
    }

    if(FieldBits::NoField != (GeoMorphingFieldMask & whichField))
    {
        returnValue += _sfGeoMorphing.getBinSize();
    }

    if(FieldBits::NoField != (DetailFieldMask & whichField))
    {
        returnValue += _sfDetail.getBinSize();
    }

    if(FieldBits::NoField != (CurrentXFieldMask & whichField))
    {
        returnValue += _sfCurrentX.getBinSize();
    }

    if(FieldBits::NoField != (CurrentYFieldMask & whichField))
    {
        returnValue += _sfCurrentY.getBinSize();
    }

    if(FieldBits::NoField != (SizeROIFieldMask & whichField))
    {
        returnValue += _sfSizeROI.getBinSize();
    }

    if(FieldBits::NoField != (UpdateFieldMask & whichField))
    {
        returnValue += _sfUpdate.getBinSize();
    }

    if(FieldBits::NoField != (UpdateTerrainFieldMask & whichField))
    {
        returnValue += _sfUpdateTerrain.getBinSize();
    }

    if(FieldBits::NoField != (PerPixelLightingFieldMask & whichField))
    {
        returnValue += _sfPerPixelLighting.getBinSize();
    }


    return returnValue;
}

void TiledTerrainBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (HeightTilesFieldMask & whichField))
    {
        _mfHeightTiles.copyToBin(pMem);
    }

    if(FieldBits::NoField != (HeightTexturesFieldMask & whichField))
    {
        _mfHeightTextures.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SizeXFieldMask & whichField))
    {
        _sfSizeX.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SizeYFieldMask & whichField))
    {
        _sfSizeY.copyToBin(pMem);
    }

    if(FieldBits::NoField != (HeightScaleFieldMask & whichField))
    {
        _sfHeightScale.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VertexSpacingFieldMask & whichField))
    {
        _sfVertexSpacing.copyToBin(pMem);
    }

    if(FieldBits::NoField != (GeoMorphingFieldMask & whichField))
    {
        _sfGeoMorphing.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DetailFieldMask & whichField))
    {
        _sfDetail.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CurrentXFieldMask & whichField))
    {
        _sfCurrentX.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CurrentYFieldMask & whichField))
    {
        _sfCurrentY.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SizeROIFieldMask & whichField))
    {
        _sfSizeROI.copyToBin(pMem);
    }

    if(FieldBits::NoField != (UpdateFieldMask & whichField))
    {
        _sfUpdate.copyToBin(pMem);
    }

    if(FieldBits::NoField != (UpdateTerrainFieldMask & whichField))
    {
        _sfUpdateTerrain.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PerPixelLightingFieldMask & whichField))
    {
        _sfPerPixelLighting.copyToBin(pMem);
    }


}

void TiledTerrainBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (HeightTilesFieldMask & whichField))
    {
        _mfHeightTiles.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (HeightTexturesFieldMask & whichField))
    {
        _mfHeightTextures.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SizeXFieldMask & whichField))
    {
        _sfSizeX.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SizeYFieldMask & whichField))
    {
        _sfSizeY.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (HeightScaleFieldMask & whichField))
    {
        _sfHeightScale.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VertexSpacingFieldMask & whichField))
    {
        _sfVertexSpacing.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (GeoMorphingFieldMask & whichField))
    {
        _sfGeoMorphing.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DetailFieldMask & whichField))
    {
        _sfDetail.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CurrentXFieldMask & whichField))
    {
        _sfCurrentX.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CurrentYFieldMask & whichField))
    {
        _sfCurrentY.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SizeROIFieldMask & whichField))
    {
        _sfSizeROI.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (UpdateFieldMask & whichField))
    {
        _sfUpdate.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (UpdateTerrainFieldMask & whichField))
    {
        _sfUpdateTerrain.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PerPixelLightingFieldMask & whichField))
    {
        _sfPerPixelLighting.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void TiledTerrainBase::executeSyncImpl(      TiledTerrainBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (HeightTilesFieldMask & whichField))
        _mfHeightTiles.syncWith(pOther->_mfHeightTiles);

    if(FieldBits::NoField != (HeightTexturesFieldMask & whichField))
        _mfHeightTextures.syncWith(pOther->_mfHeightTextures);

    if(FieldBits::NoField != (SizeXFieldMask & whichField))
        _sfSizeX.syncWith(pOther->_sfSizeX);

    if(FieldBits::NoField != (SizeYFieldMask & whichField))
        _sfSizeY.syncWith(pOther->_sfSizeY);

    if(FieldBits::NoField != (HeightScaleFieldMask & whichField))
        _sfHeightScale.syncWith(pOther->_sfHeightScale);

    if(FieldBits::NoField != (VertexSpacingFieldMask & whichField))
        _sfVertexSpacing.syncWith(pOther->_sfVertexSpacing);

    if(FieldBits::NoField != (GeoMorphingFieldMask & whichField))
        _sfGeoMorphing.syncWith(pOther->_sfGeoMorphing);

    if(FieldBits::NoField != (DetailFieldMask & whichField))
        _sfDetail.syncWith(pOther->_sfDetail);

    if(FieldBits::NoField != (CurrentXFieldMask & whichField))
        _sfCurrentX.syncWith(pOther->_sfCurrentX);

    if(FieldBits::NoField != (CurrentYFieldMask & whichField))
        _sfCurrentY.syncWith(pOther->_sfCurrentY);

    if(FieldBits::NoField != (SizeROIFieldMask & whichField))
        _sfSizeROI.syncWith(pOther->_sfSizeROI);

    if(FieldBits::NoField != (UpdateFieldMask & whichField))
        _sfUpdate.syncWith(pOther->_sfUpdate);

    if(FieldBits::NoField != (UpdateTerrainFieldMask & whichField))
        _sfUpdateTerrain.syncWith(pOther->_sfUpdateTerrain);

    if(FieldBits::NoField != (PerPixelLightingFieldMask & whichField))
        _sfPerPixelLighting.syncWith(pOther->_sfPerPixelLighting);


}
#else
void TiledTerrainBase::executeSyncImpl(      TiledTerrainBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (SizeXFieldMask & whichField))
        _sfSizeX.syncWith(pOther->_sfSizeX);

    if(FieldBits::NoField != (SizeYFieldMask & whichField))
        _sfSizeY.syncWith(pOther->_sfSizeY);

    if(FieldBits::NoField != (HeightScaleFieldMask & whichField))
        _sfHeightScale.syncWith(pOther->_sfHeightScale);

    if(FieldBits::NoField != (VertexSpacingFieldMask & whichField))
        _sfVertexSpacing.syncWith(pOther->_sfVertexSpacing);

    if(FieldBits::NoField != (GeoMorphingFieldMask & whichField))
        _sfGeoMorphing.syncWith(pOther->_sfGeoMorphing);

    if(FieldBits::NoField != (DetailFieldMask & whichField))
        _sfDetail.syncWith(pOther->_sfDetail);

    if(FieldBits::NoField != (CurrentXFieldMask & whichField))
        _sfCurrentX.syncWith(pOther->_sfCurrentX);

    if(FieldBits::NoField != (CurrentYFieldMask & whichField))
        _sfCurrentY.syncWith(pOther->_sfCurrentY);

    if(FieldBits::NoField != (SizeROIFieldMask & whichField))
        _sfSizeROI.syncWith(pOther->_sfSizeROI);

    if(FieldBits::NoField != (UpdateFieldMask & whichField))
        _sfUpdate.syncWith(pOther->_sfUpdate);

    if(FieldBits::NoField != (UpdateTerrainFieldMask & whichField))
        _sfUpdateTerrain.syncWith(pOther->_sfUpdateTerrain);

    if(FieldBits::NoField != (PerPixelLightingFieldMask & whichField))
        _sfPerPixelLighting.syncWith(pOther->_sfPerPixelLighting);


    if(FieldBits::NoField != (HeightTilesFieldMask & whichField))
        _mfHeightTiles.syncWith(pOther->_mfHeightTiles, sInfo);

    if(FieldBits::NoField != (HeightTexturesFieldMask & whichField))
        _mfHeightTextures.syncWith(pOther->_mfHeightTextures, sInfo);


}

void TiledTerrainBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (HeightTilesFieldMask & whichField))
        _mfHeightTiles.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (HeightTexturesFieldMask & whichField))
        _mfHeightTextures.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<TiledTerrainPtr>::_type("TiledTerrainPtr", "MaterialGroupPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(TiledTerrainPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(TiledTerrainPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGTiledTerrainBase.cpp,v 1.7 2006/02/20 17:04:33 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGTILEDTERRAINBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGTILEDTERRAINBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGTILEDTERRAINFIELDS_HEADER_CVSID;
}

