/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsHinge2Joint!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEPHYSICSHINGE2JOINTINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGPhysicsHinge2JointBase.h"
#include "OSGPhysicsHinge2Joint.h"


OSG_USING_NAMESPACE

const OSG::BitVector  PhysicsHinge2JointBase::AnchorFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsHinge2JointBase::AnchorFieldId);

const OSG::BitVector  PhysicsHinge2JointBase::Axis1FieldMask = 
    (TypeTraits<BitVector>::One << PhysicsHinge2JointBase::Axis1FieldId);

const OSG::BitVector  PhysicsHinge2JointBase::Axis2FieldMask = 
    (TypeTraits<BitVector>::One << PhysicsHinge2JointBase::Axis2FieldId);

const OSG::BitVector PhysicsHinge2JointBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec3f           PhysicsHinge2JointBase::_sfAnchor
    
*/
/*! \var Vec3f           PhysicsHinge2JointBase::_sfAxis1
    
*/
/*! \var Vec3f           PhysicsHinge2JointBase::_sfAxis2
    
*/

//! PhysicsHinge2Joint description

FieldDescription *PhysicsHinge2JointBase::_desc[] = 
{
    new FieldDescription(SFVec3f::getClassType(), 
                     "anchor", 
                     AnchorFieldId, AnchorFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsHinge2JointBase::getSFAnchor),
    new FieldDescription(SFVec3f::getClassType(), 
                     "axis1", 
                     Axis1FieldId, Axis1FieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsHinge2JointBase::getSFAxis1),
    new FieldDescription(SFVec3f::getClassType(), 
                     "axis2", 
                     Axis2FieldId, Axis2FieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsHinge2JointBase::getSFAxis2)
};


FieldContainerType PhysicsHinge2JointBase::_type(
    "PhysicsHinge2Joint",
    "PhysicsJoint",
    NULL,
    (PrototypeCreateF) &PhysicsHinge2JointBase::createEmpty,
    PhysicsHinge2Joint::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(PhysicsHinge2JointBase, PhysicsHinge2JointPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &PhysicsHinge2JointBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &PhysicsHinge2JointBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr PhysicsHinge2JointBase::shallowCopy(void) const 
{ 
    PhysicsHinge2JointPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const PhysicsHinge2Joint *>(this)); 

    return returnValue; 
}

UInt32 PhysicsHinge2JointBase::getContainerSize(void) const 
{ 
    return sizeof(PhysicsHinge2Joint); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsHinge2JointBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((PhysicsHinge2JointBase *) &other, whichField);
}
#else
void PhysicsHinge2JointBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((PhysicsHinge2JointBase *) &other, whichField, sInfo);
}
void PhysicsHinge2JointBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void PhysicsHinge2JointBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

PhysicsHinge2JointBase::PhysicsHinge2JointBase(void) :
    _sfAnchor                 (), 
    _sfAxis1                  (), 
    _sfAxis2                  (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

PhysicsHinge2JointBase::PhysicsHinge2JointBase(const PhysicsHinge2JointBase &source) :
    _sfAnchor                 (source._sfAnchor                 ), 
    _sfAxis1                  (source._sfAxis1                  ), 
    _sfAxis2                  (source._sfAxis2                  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

PhysicsHinge2JointBase::~PhysicsHinge2JointBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 PhysicsHinge2JointBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
    {
        returnValue += _sfAnchor.getBinSize();
    }

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
    {
        returnValue += _sfAxis1.getBinSize();
    }

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
    {
        returnValue += _sfAxis2.getBinSize();
    }


    return returnValue;
}

void PhysicsHinge2JointBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
    {
        _sfAnchor.copyToBin(pMem);
    }

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
    {
        _sfAxis1.copyToBin(pMem);
    }

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
    {
        _sfAxis2.copyToBin(pMem);
    }


}

void PhysicsHinge2JointBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
    {
        _sfAnchor.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
    {
        _sfAxis1.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
    {
        _sfAxis2.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsHinge2JointBase::executeSyncImpl(      PhysicsHinge2JointBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
        _sfAnchor.syncWith(pOther->_sfAnchor);

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
        _sfAxis1.syncWith(pOther->_sfAxis1);

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
        _sfAxis2.syncWith(pOther->_sfAxis2);


}
#else
void PhysicsHinge2JointBase::executeSyncImpl(      PhysicsHinge2JointBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
        _sfAnchor.syncWith(pOther->_sfAnchor);

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
        _sfAxis1.syncWith(pOther->_sfAxis1);

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
        _sfAxis2.syncWith(pOther->_sfAxis2);



}

void PhysicsHinge2JointBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<PhysicsHinge2JointPtr>::_type("PhysicsHinge2JointPtr", "PhysicsJointPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(PhysicsHinge2JointPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(PhysicsHinge2JointPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGPhysicsHinge2JointBase.cpp,v 1.2 2006/02/20 17:04:21 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGPHYSICSHINGE2JOINTBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPHYSICSHINGE2JOINTBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPHYSICSHINGE2JOINTFIELDS_HEADER_CVSID;
}

