/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CharacterModel!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECHARACTERMODELINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGCharacterModelBase.h"
#include "OSGCharacterModel.h"


OSG_USING_NAMESPACE

const OSG::BitVector  CharacterModelBase::ConfigFileFieldMask = 
    (TypeTraits<BitVector>::One << CharacterModelBase::ConfigFileFieldId);

const OSG::BitVector  CharacterModelBase::NumAnimationsFieldMask = 
    (TypeTraits<BitVector>::One << CharacterModelBase::NumAnimationsFieldId);

const OSG::BitVector  CharacterModelBase::ShaderFieldMask = 
    (TypeTraits<BitVector>::One << CharacterModelBase::ShaderFieldId);

const OSG::BitVector  CharacterModelBase::MaterialsFieldMask = 
    (TypeTraits<BitVector>::One << CharacterModelBase::MaterialsFieldId);

const OSG::BitVector CharacterModelBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var std::string     CharacterModelBase::_sfConfigFile
    File name for the model configuration file (.cfg).
*/
/*! \var UInt32          CharacterModelBase::_sfNumAnimations
    Number of loaded animations (valid only after endEdit for loading model configuration file).
*/
/*! \var SHLChunkPtr     CharacterModelBase::_sfShader
    The shader to use for skinning. Has to be set before the configFile.
*/
/*! \var ChunkMaterialPtr CharacterModelBase::_mfMaterials
    The different materials used in the model.
*/

//! CharacterModel description

FieldDescription *CharacterModelBase::_desc[] = 
{
    new FieldDescription(SFString::getClassType(), 
                     "configFile", 
                     ConfigFileFieldId, ConfigFileFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterModelBase::getSFConfigFile),
    new FieldDescription(SFUInt32::getClassType(), 
                     "numAnimations", 
                     NumAnimationsFieldId, NumAnimationsFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterModelBase::getSFNumAnimations),
    new FieldDescription(SFSHLChunkPtr::getClassType(), 
                     "shader", 
                     ShaderFieldId, ShaderFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterModelBase::getSFShader),
    new FieldDescription(MFChunkMaterialPtr::getClassType(), 
                     "materials", 
                     MaterialsFieldId, MaterialsFieldMask,
                     true,
                     (FieldAccessMethod) &CharacterModelBase::getMFMaterials)
};


FieldContainerType CharacterModelBase::_type(
    "CharacterModel",
    "AttachmentContainer",
    NULL,
    (PrototypeCreateF) &CharacterModelBase::createEmpty,
    CharacterModel::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(CharacterModelBase, CharacterModelPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &CharacterModelBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &CharacterModelBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr CharacterModelBase::shallowCopy(void) const 
{ 
    CharacterModelPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const CharacterModel *>(this)); 

    return returnValue; 
}

UInt32 CharacterModelBase::getContainerSize(void) const 
{ 
    return sizeof(CharacterModel); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void CharacterModelBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((CharacterModelBase *) &other, whichField);
}
#else
void CharacterModelBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((CharacterModelBase *) &other, whichField, sInfo);
}
void CharacterModelBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void CharacterModelBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfMaterials.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

CharacterModelBase::CharacterModelBase(void) :
    _sfConfigFile             (), 
    _sfNumAnimations          (), 
    _sfShader                 (), 
    _mfMaterials              (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

CharacterModelBase::CharacterModelBase(const CharacterModelBase &source) :
    _sfConfigFile             (source._sfConfigFile             ), 
    _sfNumAnimations          (source._sfNumAnimations          ), 
    _sfShader                 (source._sfShader                 ), 
    _mfMaterials              (source._mfMaterials              ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

CharacterModelBase::~CharacterModelBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 CharacterModelBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ConfigFileFieldMask & whichField))
    {
        returnValue += _sfConfigFile.getBinSize();
    }

    if(FieldBits::NoField != (NumAnimationsFieldMask & whichField))
    {
        returnValue += _sfNumAnimations.getBinSize();
    }

    if(FieldBits::NoField != (ShaderFieldMask & whichField))
    {
        returnValue += _sfShader.getBinSize();
    }

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
    {
        returnValue += _mfMaterials.getBinSize();
    }


    return returnValue;
}

void CharacterModelBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ConfigFileFieldMask & whichField))
    {
        _sfConfigFile.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NumAnimationsFieldMask & whichField))
    {
        _sfNumAnimations.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ShaderFieldMask & whichField))
    {
        _sfShader.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
    {
        _mfMaterials.copyToBin(pMem);
    }


}

void CharacterModelBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ConfigFileFieldMask & whichField))
    {
        _sfConfigFile.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NumAnimationsFieldMask & whichField))
    {
        _sfNumAnimations.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ShaderFieldMask & whichField))
    {
        _sfShader.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
    {
        _mfMaterials.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void CharacterModelBase::executeSyncImpl(      CharacterModelBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ConfigFileFieldMask & whichField))
        _sfConfigFile.syncWith(pOther->_sfConfigFile);

    if(FieldBits::NoField != (NumAnimationsFieldMask & whichField))
        _sfNumAnimations.syncWith(pOther->_sfNumAnimations);

    if(FieldBits::NoField != (ShaderFieldMask & whichField))
        _sfShader.syncWith(pOther->_sfShader);

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
        _mfMaterials.syncWith(pOther->_mfMaterials);


}
#else
void CharacterModelBase::executeSyncImpl(      CharacterModelBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ConfigFileFieldMask & whichField))
        _sfConfigFile.syncWith(pOther->_sfConfigFile);

    if(FieldBits::NoField != (NumAnimationsFieldMask & whichField))
        _sfNumAnimations.syncWith(pOther->_sfNumAnimations);

    if(FieldBits::NoField != (ShaderFieldMask & whichField))
        _sfShader.syncWith(pOther->_sfShader);


    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
        _mfMaterials.syncWith(pOther->_mfMaterials, sInfo);


}

void CharacterModelBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (MaterialsFieldMask & whichField))
        _mfMaterials.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<CharacterModelPtr>::_type("CharacterModelPtr", "AttachmentContainerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(CharacterModelPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGCharacterModelBase.cpp,v 1.2 2006/02/20 17:04:12 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGCHARACTERMODELBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCHARACTERMODELBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCHARACTERMODELFIELDS_HEADER_CVSID;
}

