/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CGChunk!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &CGChunkBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 CGChunkBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
CGChunkPtr CGChunkBase::create(void) 
{
    CGChunkPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = CGChunkPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
CGChunkPtr CGChunkBase::createEmpty(void) 
{ 
    CGChunkPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the CGChunk::_sfVertexProfile field.
inline
SFUInt32 *CGChunkBase::getSFVertexProfile(void)
{
    return &_sfVertexProfile;
}

//! Get the CGChunk::_sfFragmentProfile field.
inline
SFUInt32 *CGChunkBase::getSFFragmentProfile(void)
{
    return &_sfFragmentProfile;
}

//! Get the CGChunk::_sfVertexEntryPoint field.
inline
SFString *CGChunkBase::getSFVertexEntryPoint(void)
{
    return &_sfVertexEntryPoint;
}

//! Get the CGChunk::_mfVertexArguments field.
inline
MFString *CGChunkBase::getMFVertexArguments(void)
{
    return &_mfVertexArguments;
}

//! Get the CGChunk::_sfFragmentEntryPoint field.
inline
SFString *CGChunkBase::getSFFragmentEntryPoint(void)
{
    return &_sfFragmentEntryPoint;
}

//! Get the CGChunk::_mfFragmentArguments field.
inline
MFString *CGChunkBase::getMFFragmentArguments(void)
{
    return &_mfFragmentArguments;
}

//! Get the CGChunk::_sfGLId field.
inline
SFUInt32 *CGChunkBase::getSFGLId(void)
{
    return &_sfGLId;
}


//! Get the value of the CGChunk::_sfVertexProfile field.
inline
UInt32 &CGChunkBase::getVertexProfile(void)
{
    return _sfVertexProfile.getValue();
}

//! Get the value of the CGChunk::_sfVertexProfile field.
inline
const UInt32 &CGChunkBase::getVertexProfile(void) const
{
    return _sfVertexProfile.getValue();
}

//! Set the value of the CGChunk::_sfVertexProfile field.
inline
void CGChunkBase::setVertexProfile(const UInt32 &value)
{
    _sfVertexProfile.setValue(value);
}

//! Get the value of the CGChunk::_sfFragmentProfile field.
inline
UInt32 &CGChunkBase::getFragmentProfile(void)
{
    return _sfFragmentProfile.getValue();
}

//! Get the value of the CGChunk::_sfFragmentProfile field.
inline
const UInt32 &CGChunkBase::getFragmentProfile(void) const
{
    return _sfFragmentProfile.getValue();
}

//! Set the value of the CGChunk::_sfFragmentProfile field.
inline
void CGChunkBase::setFragmentProfile(const UInt32 &value)
{
    _sfFragmentProfile.setValue(value);
}

//! Get the value of the CGChunk::_sfVertexEntryPoint field.
inline
std::string &CGChunkBase::getVertexEntryPoint(void)
{
    return _sfVertexEntryPoint.getValue();
}

//! Get the value of the CGChunk::_sfVertexEntryPoint field.
inline
const std::string &CGChunkBase::getVertexEntryPoint(void) const
{
    return _sfVertexEntryPoint.getValue();
}

//! Set the value of the CGChunk::_sfVertexEntryPoint field.
inline
void CGChunkBase::setVertexEntryPoint(const std::string &value)
{
    _sfVertexEntryPoint.setValue(value);
}

//! Get the value of the CGChunk::_sfFragmentEntryPoint field.
inline
std::string &CGChunkBase::getFragmentEntryPoint(void)
{
    return _sfFragmentEntryPoint.getValue();
}

//! Get the value of the CGChunk::_sfFragmentEntryPoint field.
inline
const std::string &CGChunkBase::getFragmentEntryPoint(void) const
{
    return _sfFragmentEntryPoint.getValue();
}

//! Set the value of the CGChunk::_sfFragmentEntryPoint field.
inline
void CGChunkBase::setFragmentEntryPoint(const std::string &value)
{
    _sfFragmentEntryPoint.setValue(value);
}

//! Get the value of the CGChunk::_sfGLId field.
inline
UInt32 &CGChunkBase::getGLId(void)
{
    return _sfGLId.getValue();
}

//! Get the value of the CGChunk::_sfGLId field.
inline
const UInt32 &CGChunkBase::getGLId(void) const
{
    return _sfGLId.getValue();
}

//! Set the value of the CGChunk::_sfGLId field.
inline
void CGChunkBase::setGLId(const UInt32 &value)
{
    _sfGLId.setValue(value);
}


//! Get the value of the \a index element the CGChunk::_mfVertexArguments field.
inline
std::string &CGChunkBase::getVertexArguments(const UInt32 index)
{
    return _mfVertexArguments[index];
}

//! Get the CGChunk::_mfVertexArguments field.
inline
MFString &CGChunkBase::getVertexArguments(void)
{
    return _mfVertexArguments;
}

//! Get the CGChunk::_mfVertexArguments field.
inline
const MFString &CGChunkBase::getVertexArguments(void) const
{
    return _mfVertexArguments;
}

//! Get the value of the \a index element the CGChunk::_mfFragmentArguments field.
inline
std::string &CGChunkBase::getFragmentArguments(const UInt32 index)
{
    return _mfFragmentArguments[index];
}

//! Get the CGChunk::_mfFragmentArguments field.
inline
MFString &CGChunkBase::getFragmentArguments(void)
{
    return _mfFragmentArguments;
}

//! Get the CGChunk::_mfFragmentArguments field.
inline
const MFString &CGChunkBase::getFragmentArguments(void) const
{
    return _mfFragmentArguments;
}

OSG_END_NAMESPACE

#define OSGCGCHUNKBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

