from orpg.orpgCore import *
from orpg.orpg_wx import *

#----------------------------------------------------------------------

class StaticText(wx.StaticText):
    """
    A StaticText that only updates the label if it has changed, to
    help reduce potential flicker since these controls would be
    updated very frequently otherwise.
    """
    def SetLabel(self, label):
        if label <> self.GetLabel():
            wx.StaticText.SetLabel(self, label)

#----------------------------------------------------------------------

class orpgSound(wx.Panel):
    def __init__(self, parent, openrpg):
        wx.Panel.__init__(self, parent, -1)

        self.openrpg = openrpg
        self.settings = openrpg.get_component('settings')
        # Create some controls
        try:
            self.mc = wx.media.MediaCtrl(self, style=wx.SIMPLE_BORDER)
            self.mc.Hide()
            self.OldPlayer = False
            self.Bind(wx.media.EVT_MEDIA_LOADED, self.OnMediaLoaded)
        except NotImplementedError:
            self.OldPlayer = True


        btn2 = wx.Button(self, -1, "Play")
        self.Bind(wx.EVT_BUTTON, self.OnPlay, btn2)
        self.playBtn = btn2
        self.playBtn.Disable()

        btn3 = wx.Button(self, -1, "stop")
        self.Bind(wx.EVT_BUTTON, self.OnStop, btn3)
        self.stopBtn = btn3

        self.st_name = StaticText(self, -1, size=(100,-1))

        self.loopSound = False

        # setup the layout
        sizer = wx.GridBagSizer(hgap=1, vgap=1)
        sizer.Add(self.st_name, (0,0), flag=wx.EXPAND)
        sizer.Add(btn2, (0,1))
        sizer.Add(btn3, (0,2))
        sizer.AddGrowableCol(0)
        self.SetSizer(sizer)
        self.SetAutoLayout(True)
        self.Fit()

        self.Bind(wx.EVT_CLOSE, self.OnClose)
        self.timer = wx.Timer(self, wx.NewId())
        self.Bind(wx.EVT_TIMER, self.OnTimer)
        self.timer.Start(100)

    def play(self, sound_file, type="local", loop_sound=False):
        if self.OldPlayer:
            if wx.Platform == '__WXMSW__':
                import winsound
                self.play_windows(sound_file)
            elif wx.Platform == '__WXGTK__':
                self.play_unix(sound_file)
        else:
            self.loopSound = loop_sound
            self.LoadSound(sound_file, type)

    def play_windows(self,sound_file):
        winsound.PlaySound(sound_file, winsound.SND_FILENAME)

    def play_unix(self, sound_file):
        unix_player = self.settings.get_setting('UnixSoundPlayer')
        if unix_player != '':
            os.system(unix_player + " " + sound_file)

    def LoadSound(self, sound_file, type="local"):
        (path, name) = os.path.split(sound_file)
        if type == 'remote':
            self.mc.LoadFromURI(sound_file)
        else:
            self.mc.Load(sound_file)

        self.st_name.SetLabel(name)
        return

    def OnMediaLoaded(self, evt):
        self.mc.Play()
        self.playBtn.Enable()

    def OnPlay(self, evt):
        self.mc.Play()

    def OnStop(self, evt):
        self.loopSound = False
        self.mc.Stop()

    def OnClose(self, evt):
        self.timer.Stop()
        del self.timer

    def __del__(self):
        self.timer.Stop()

    def OnTimer(self, args):
        if not self.OldPlayer:
            if self.mc.GetState() == wx.media.MEDIASTATE_PLAYING and not self.stopBtn.IsEnabled():
                self.stopBtn.Enable()
            elif self.mc.GetState() != wx.media.MEDIASTATE_PLAYING and self.stopBtn.IsEnabled():
                self.stopBtn.Disable()

            if self.mc.GetState() != wx.media.MEDIASTATE_PLAYING and self.loopSound:
                self.mc.Play()
        elif self.stopBtn.IsShown():
            self.playBtn.Hide()
            self.stopBtn.Hide()
            self.Layout()
        return

class SoundFrame(wx.Frame):
    def __init__(self, openrpg):
        wx.Frame.__init__(self, None, title="Sound Control Toolbar", style=wx.CAPTION | wx.SYSTEM_MENU | wx.STAY_ON_TOP)

        self.soundCtrl = orpgSound(self, openrpg)

        sizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer.Add(self.soundCtrl, 1, wx.EXPAND)
        self.SetSizer(sizer)
        self.SetSizer(sizer)
        self.SetAutoLayout(True)
        self.Fit()



class BlankApp(wx.App):
    def OnInit(self):
        self.frame = SoundFrame()
        self.frame.Show()
        self.SetTopWindow(self.frame)
        return True

    def OnChar(self, event):
        #Not sure how to determin if only Tab or Shift Tab was used to initiate
        self.tabgroup.GoNext( self.frame1.FindFocus() )

if __name__ == "__main__":
    app = BlankApp(0)
    app.MainLoop()