name="URL to Link Converter v2"#
author="tdb30_, mDuo13"
help="""Converts text links in chat to HTML links using a regular expression
that is more reliable than the method in the old version. Links from all
protocols, links without a given protocol, and e-mail links are supported."""
#These give the patch some information about your plugin.
#'name' should contain your plugin's long name.
#       Make sure it's not the same as another plugin's name.
#'author' is the author of the plugin. It will be listed in the plugin info.
#'help' is the help text that will be displayed when the user clicks the
#       'Plugin Info' button.
#--------------------------------------
import os
import re

chat=None
session=None
tree=None
openrpg=None

#This is a new feature, the plugin database. You can store settings in it, and
#it will keep things in a single XML file for all plugins, instead of having to
#create and read text files for each plugin.
#Experiment with the following functions, or look at examples from other
#plugins, to see how to use them:
#These must be called in one of the functions.
#openrpg.plugindb.SetString(plugin_filename, variable_name, variable_value)
#openrpg.plugindb.GetString(plugin_filename, variable_name, default_value)
#openrpg.plugindb.SetList(plugin_filename, variable_name, list_value)
#openrpg.plugindb.GetList(plugin_filename, variable_name, default_list)
#openrpg.plugindb.SetDict(plugin_filename, variable_name, dictionary_value)
#openrpg.plugindb.GetDict(plugin_filename, variable_name, default_dictionary)

##Now we have the functions. These are called from within OpenRPG at various
##times. You can reference and change the variables, and do other things too.
##The more you know about python and OpenRPG, the more you can do. The
##possibilities are larger than you'd think.
##Note that when I say "formatted" I mean that it has HTML tags like font colors
##and names already added.

#definition of a url: at least one word character, followed by many characters
#that are valid in a url. It breaks as soon as a character not valid in a URL
#appears, such as a space, a quote, etc. OR it can be a subdomain,
#followed by a period, followed by a legitimate domain name and then all that junk.
url_regex = re.compile(r"""\w{3,}://[A-Za-z0-9.=,:/&;?_%~+!$#-]{2,63}\.[A-Za-z0-9.=,:/&;?_%~+!$#-]{2,63}|[\w-]{2,63}\.[\w-]{2,63}\.[A-Za-z]{2,6}(/[A-Za-z0-9.=,:/&;?_%~+!$#-]+)?|[0-9]{2,3}\.[0-9]{2,3}\.[0-9]{1,3}\.[0-9]{1,3}""", re.I)
#                       the split is right here --------------------------------------------------------^

#for mailto: links. Underscores aren't allowed in domain names so the second
#half of the e-mail tag can't contain them.
mailto_regex = re.compile(r"""(mailto:)?[\w._-]+@[A-Za-z0-9.-]+""", re.I)

def link_urls(text):
    #The modified text accumulates into text2 so that the indices of the regex matches
    #in the original text variable don't get screwed up by the replacement.
    text2 = ""
    url = url_regex.search(text)
    if not url:#so that it doesn't accidentally delete the message
        text2 = text
        textafterurl = ""
    while url:
        urltext = url.group()
        if urltext.find("://")<0:#it might not load the web browser but is usable. For example, "maps.google.com"
            urltext = "http://"+urltext
        textbeforeurl = text[:url.start()]
        textafterurl = text[url.end():]
        if not (len(re.findall("<",textbeforeurl)) > len(re.findall(">",textbeforeurl))) and text[url.start()-1]!="@":
            text2 += textbeforeurl + "<a href='" + urltext + "'>" + url.group() + "</a>"
        else:
            text2 += textbeforeurl + url.group()#not urltext, because we don't wanna screw with it
        text = textafterurl
        url = url_regex.search(text)
    else:#once it's done -- this happens whether or not it found a URL to begin with
        text2 += textafterurl
    return text2

def link_emails(text):
    #The modified text accumulates into text2 so that the indices of the regex matches
    #in the original text variable don't get screwed up by the replacement.
    #the main differences between this and the link_urls function are:
    #  (a) this one uses the mailto_regex instead of url_regex
    #  (b) this one doesn't append http:// but rather mailto:
    text2 = ""
    url = mailto_regex.search(text)
    if not url:#so that it doesn't accidentally delete the message
        text2 = text
        textafterurl = ""
    while url:
        urltext = url.group()
        if urltext.find("mailto:")<0:#it's just a plain e-mail like mduo13@yahoo.com instead of a mailto URL
            urltext = "mailto:"+urltext
        textbeforeurl = text[:url.start()]
        textafterurl = text[url.end():]
        if not (len(re.findall("<",textbeforeurl)) > len(re.findall(">",textbeforeurl))):
            #here it doesn't use urltext, but rather the "prettier" version (without mailto:) in the displayed text
            #even though the href URL is actually a mailto.
            text2 += textbeforeurl + "<a href='" + urltext + "'>" + url.group() + "</a>"
        else:
            text2 += textbeforeurl + url.group()#not urltext, because we don't wanna screw with it
        text = textafterurl
        url = mailto_regex.search(text)
    else:#once it's done -- this happens whether or not it found a URL to begin with
        text2 += textafterurl
    return text2

def message(self, text):
    #This is called whenever the user types something and hits enter.
    #It covers all messages, before they are formatted.
    return text

def send_msg(self, text, send):
    #This is called when a message is about to be sent out.
    #It covers all messages sent by the user, before they have been formatted.
    #If send is set to 0, the message will not be sent out to other
    #users, but it will still be posted to the user's chat normally.
    #Otherwise, send defaults to 1. (The message is sent as normal)
    text = link_emails(text)
    text = link_urls(text)
    return text, send

def receive_msg(self, text, type, name, player):
    #This is called whenever a message from someone else is received, no matter
    #what type of message it is.
    #The text variable is the text of the message. If the type is a regular
    #message, it is already formatted. Otherwise, it's not.
    #The type variable is an integer which tells you the type: 1=chat, 2=whisper
    #3=emote, 4=info, and 5=system.
    #The name variable is the name of the player who sent you the message.
    #The player variable contains lots of info about the player sending the
    #message, including name, ID#, and currently-set role.
    #Uncomment the following line to see the format for the player variable.
    #print player
    posted = 0#If posted is set to 1 then the chat module will stop processing
    #the incoming message. Use this if you post the incoming message elsewhere,
    #for example in a special tab or window.
    text = link_emails(text)
    text = link_urls(text)
    return text, type, name, posted

def post_msg(self, text, myself):
    #This is called whenever a message from anyone is about to be posted
    #to chat; it doesn't affect the copy of the message that gets sent to others
    #Be careful; system and info messages trigger this too.
    return text

def docmd(self, text, cmdlist):
    #This is called when the user enters a / command that OpenRPG doesn't
    #recognize. Thus, you can create new / commands. The text variable
    #is the text that the user inputted. If it is your custom command,
    #return 1. If it is not, return 0.
    return 0

def refresh_counter(self):
    #This is called once per second. That's all you need to know.
    pass

def close_module(self):
    #This is called when OpenRPG shuts down
    pass
