'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_stylist.inc,v $
'*
'*  $Revision: 1.25 $
'*
'*  last change: $Author: hde $ $Date: 2005/10/27 09:03:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test common stylist functions
'*
'************************************************************************
'*
' #1 tFormatStylist1
' #1 tFormatStylist2
' #1 tFormatStylist3
' #1 tFormatStylist4
' #1 tFormatStylist5
' #1 tFormatStylist6
' #1 tKeyboardShortcutToStyles
'*
'\***********************************************************************

sub w_stylist
   printLog Chr(13) + "---------   Level 1 - Format / Stylist   ----------"

   Call tFormatStylist1                ' all methods on stylist
   Call tFormatStylist2                ' interacting between documents
   Call tFormatStylist3                ' show all templates
   Call tFormatStylist4                ' search/create templates
   Call tFormatStylist5                ' select templet in stylist
   Call tFormatStylist6                ' new template from selection
   Call tKeyboardShortcutToStyles

   
end sub

' **********************************************************************

testcase tFormatStylist1
  	Dim xPos as long : Dim yPos as long : Dim xSize% : Dim ySize%

	printlog "- Format / Stylist : all methods with Navigator as window"
	'/// New writerdocument ///
	Call hNewDocument
	printlog "  - Call Stylist with F11"
	'/// Call stylist with <F11> aand proof all windowmethods at stylist ///
	Call wDokSchreiben "<F11>"
	Kontext "Stylist"
	if Stylist.NotExists then
      	Warnlog "No Stylist with <F11>"
		FormatStylist
	end if
	xPos = Stylist.GetPosX
	yPos = Stylist.GetPosY
	xSize% = Stylist.GetSizeX
	ySize% = Stylist.GetSizeY

	printlog "  - move Stylist"
	Stylist.Move 10, 10
	Sleep 1
	Stylist.Move 300, 400
	Sleep 1
	Stylist.Move 590, 790
	Sleep 1
	Stylist.Move xPos, yPos
	Sleep 1

	printlog "  - size Stylist"
	try
		Stylist.Size 300, 400
	catch
		Warnlog "Sizen Stylist doesn't work.. see #i32449"
	endcatch	
	Sleep 1
	try
		Stylist.Size xSize%, ySize%
	catch
		Warnlog "Sizen Stylist doesn't work.. see #i32449"
	endcatch
	Sleep 1

	printlog "  - close Stylist and reopen ( has to be the same size )"
	xPos = Stylist.GetPosX
	yPos = Stylist.GetPosY
	xSize% = Stylist.GetSizeX
	ySize% = Stylist.GetSizeY
	FormatStylist
	Sleep 1
	FormatStylist
	if xPos <> Stylist.GetPosX then Warnlog "x-Pos. has been changed : Not -> "+ xPos + "  but -> "+ Stylist.GetPosX
	if yPos <> Stylist.GetPosY then Warnlog "y-Pos. has been changed : Not -> "+ yPos + "  but -> "+ Stylist.GetPosY
	if xSize% <> Stylist.GetSizeX then Warnlog "x-Size has been changed : Not -> "+ xSize% + "  but -> "+ Stylist.GetSizeX
	if ySize% <> Stylist.GetSizeY then Warnlog "y-Size has been changed : Not -> "+ ySize% + "  but -> "+ Stylist.GetSizeY

	printlog "  - dock Stylist"
	Stylist.Dock
	Sleep 1
	if NOT Stylist.IsDocked then Warnlog "Stylist has not been docked in"
	Stylist.Undock
	Sleep 1

	Stylist.Close
	'/// Close document ///
	Call hCloseDocument
	
endcase

' **********************************************************************

testcase tFormatStylist2
	Dim xPos% : Dim yPos% : Dim xSize% : Dim ySize%
	
	printlog "- Format/Stylist : Methods from Stylist as Window between more than one document"
	'/// New document ///
	Call hNewDocument
	'/// check all methods of Stylist as Window between more than one document ///
	Call wDokSchreiben "Test the stylist functions"
	printlog "  - Call Stylist in first document and check in a second document"
	Sleep 2
	Kontext "Stylist"
	If Not Stylist.Exists then FormatStylist
	Sleep 2
	Call hNewDocument
	Call wDokSchreiben "Test the stylist functions"
	Sleep 2
	Kontext "Stylist"
	if Stylist.NotExists then Warnlog "No Stylist in new document"
	
	printlog "  - Close all documents and reopen"
	Sleep 2
	Call hCloseDocument
	Sleep 2
	Call hCloseDocument
	Sleep 2
	Call hNewDocument
	Sleep 2
	Call wDokSchreiben "Test the stylist functions"
	Kontext "Stylist"
	if Stylist.NotExists then Warnlog "No Stylist in a new document"
	
	printlog "  - Dock Stylist in first document and check in a new if docked"
	Sleep 2
	Stylist.Dock
	Sleep 1
	Call hNewDocument
	Call wDokSchreiben "Test the stylist functions"
	Kontext "Stylist"
	if NOT Stylist.IsDocked then Warnlog "Stylist is not docked in new document"
	
	printlog "  - Close all documents, reopen one and check docked Stylist"
	Call hCloseDocument
	Sleep 2
	Call hCloseDocument
	Sleep 2
	Call hNewDocument
	Kontext "Stylist"
	if NOT Stylist.IsDocked then Warnlog "Stylist is not docked in new document"
	
	printlog "  - Close Stylist with <F11>"
	Stylist.Undock
	Sleep 1
	Call wDokSchreiben "<F11>"
	Kontext "Stylist"
	if NOT Stylist.NotExists then
		Warnlog "Stylist is still open"
		Stylist.Close
	end if
	'/// Close document ///
	Call hCloseDocument
	
endcase
' **********************************************************************

testcase tFormatStylist3
    Dim i as Integer, AllStyles as integer
    Dim j as integer, RemString as string
    printlog "- Format / Stylist : select all Style properties"

    Call hNewDocument
    '/// New writerdocument ///
    FormatStylist
    '/// Select all style properties in stylist ///
    Kontext "Stylist"
    if Stylist.NotExists then FormatStylist
    printlog "   - Paragraph Styles"
    Absatzvorlagen.Click

    for i=1 to Gruppenliste.GetItemCount
        Gruppenliste.Select i
        wait 500
        if i = 2 then  ' All Styles
            Vorlagenliste.TypeKeys "<Home>"
            AllStyles = 1
            For j = 1 to 200
                RemString = Vorlagenliste.Gettext
                'Include this, if you want to see the styles in writerdocument
                'SetClipboard Vorlagenliste.Gettext
                'Kontext "DocumentWriter"
                'DocumentWriter.TypeKeys GetClipboardtext + "<Return>"
                'Kontext "Stylist"
                Vorlagenliste.TypeKeys "<Down>"
                if Vorlagenliste.Gettext <> RemString then
                    AllStyles = AllStyles + 1
                else
                    j = 202
                    if AllStyles <> "122" then
                        Select Case iSprache
                            Case 55
                                QAErrorlog "#i48359#Missing Style in Stylist"
                            Case 31
                                QAErrorlog "#i55810#Missing Style in Stylist"
                            Case else
                                Warnlog "There are " + AllStyles + " styles in this category and not 122!"
                        end select
                    else
                        printlog "There are " + AllStyles + " styles in this category!"
                    endif
                endif
            next j
        endif
        Sleep 1
    next i

    Zeichenvorlagen.Click
    Sleep 2
    printlog "   - Chapter Styles"
    for i=1 to Gruppenliste.GetItemCount
        Gruppenliste.Select i
        AllStyles = AllStyles + 1
        Sleep 1
    next i

    Rahmenvorlagen.Click
    Sleep 2
    printlog "   - Frame Styles"
    for i=1 to Gruppenliste.GetItemCount
        Gruppenliste.Select i
        AllStyles = AllStyles + 1
        Sleep 1
    next i

    Seitenvorlagen.Click
    Sleep 2
    printlog "   - Page Styles"
    for i=1 to Gruppenliste.GetItemCount
        Gruppenliste.Select i
        AllStyles = AllStyles + 1
        Sleep 1
    next i
    Stylist.Close
    '/// Close document ///
    Call hCloseDocument
endcase

' **********************************************************************

testcase tFormatStylist4
  	Dim i as Integer : Dim AlterWert$ : Dim NeuerWert$
	printlog "- Format / Stylist : check created Styles"

	'/// New writerdocument ///
	Call hNewDocument
	printlog "   - create Paragraph Style in Stylist"
	'/// create Paragraph Style in Stylist
	Call wStyleCreate ( "ATesttool", "Paragraph", true )
	Kontext "Stylist"
    '/// Check if Style has been added in stylist
    if wStyleSelect ( "ATesttool", "Paragraph" ) = false then Warnlog "Paragraph Style has not been found"

	printlog "   - Create Character Style in Stylist"
	'/// create Character Style in Stylist ///
	Call wStyleCreate ( "BTesttool", "Character", true )
	if wStyleSelect ( "BTesttool", "Character" ) = false then Warnlog "Character Style has not been found!"
    
	printlog "   - Create Frame Style in Stylist"
	'/// create Frame Style in Stylist ///
    Call wStyleCreate ( "CTesttool", "Frame", true )
    if wStyleSelect ( "CTesttool", "Frame" ) = false then Warnlog "Frame Style has not been found!"

	printlog "   - Create Page Style in Stylist"
	'/// create Page Style in Stylist ///
	Call wStyleCreate ( "DTesttool", "Page", true )
	if wStyleSelect ( "DTesttool", "Page" ) = false then Warnlog "Page Style has not been found"

	printlog "   - creating Styles should not have been affecting to new documents"
	'/// check if creating Styles affects to new documents ///
    ' To avoid focus problems on unix first close stylist
   	Kontext "Stylist"
    if Stylist.Exists then FormatStylist   
	Call hNewDocument
   	Kontext "Stylist"
    if Not Stylist.Exists then FormatStylist

    if wStyleSelect ( "ATesttool", "Paragraph" ) = true then Warnlog "Paragraph Style has been found in new document"
    if wStyleSelect ( "BTesttool", "Character" ) = true then Warnlog "Character Style has been found in new document"
	'if wStyleSelect ( "CTesttool", "Frame" ) = true then Warnlog "Frame Style has been found in new document"
    if wStyleSelect ( "DTesttool", "Page" ) = true then Warnlog "Page Style has been found in new document"

    Call hCloseDocument
    
	'/// Close document ///
	Call hCloseDocument
endcase

' **********************************************************************

testcase tFormatStylist5
   	Dim SuchMal as string
	printlog "- Format / Stylist : select Style"
	'/// New writerdocument ///
	if bAsianLan = True then
    	printlog "- Not in Asian languages!"
		goto endsub
	endif
	Call hNewDocument
	Call wDokSchreiben "Dies ist ein formatierter Text <Shift Home>"
	printlog "  - format Text"
	FormatCharacter
	Kontext
	Active.SetPage TabFontEffects
	Kontext "TabFontEffects"
	StrikeThrough.Select 2
  	Outline.Check
	TabFontEffects.OK

	printlog "  - adjust to Standard-Format through the Stylist"
	'/// adjust to Standard-Format through the Stylist ///
	FormatStylist
	Kontext "Stylist"
	if Stylist.NotExists then FormatStylist
  	'Get name for 'default' template
	Kontext "TextObjectbar"
	SuchMal = Vorlage.GetSelText
	printlog "Using " & SuchMal & " as 'default'" 
	Kontext "Stylist"
   

	Call hDoubleClickInList ( Vorlagenliste, SuchMal )
	Stylist.Close

	printlog "  - check format"
	FormatCharacter
	Kontext
	Active.SetPage TabFontEffects
	Kontext "TabFontEffects"
	if StrikeThrough.GetSelIndex <> "2" then Warnlog "Wrong entry selected in StrikeThrough"
	if Outline.IsChecked then Warnlog "Format Outline is still checked"
	TabFontEffects.OK

	'/// Close document ///
	Call hCloseDocument
endcase

' **********************************************************************

testcase tFormatStylist6
  	Dim i as integer
	printlog "- Format / Stylist : new Style from selection"
	'/// New writerdocument ///

	Call hNewDocument
	Call wDokSchreiben "Creating a style from selection <Return><Up><Shift End>"
	'/// create a new style from selection ///
	FormatCharacter
	Kontext
	Active.SetPage TabFontEffects
	Kontext "TabFontEffects"
	Shadow.Check
	StrikeThrough.Select 2
	Outline.Check
	Effects.Select 3
	Blinking.Check
	Kontext
	Active.Setpage TabHyperlinkZeichen
	Kontext "TabHyperlinkZeichen"
	URLName.SetText "www.mikeportnoy.com"
	TabHyperlinkZeichen.OK

	printlog "  - Create Character Style from selection"
	'/// Create Character Style from selection ///
   	Kontext "Stylist"
    if not Stylist.Exists then FormatStylist
	Kontext "Stylist"
	TBGestalter.Click ZeichenVorlagen
	Sleep 1

    AusSelektion.OpenMenu
    Sleep 1
    hMenuSelectNr(1)
    Sleep 1
    
   	Kontext "VorlageErzeugen"
	if VorlageErzeugen.Exists then
		VorlagenName.SetText "Testtool"
		VorlageErzeugen.OK
	else
		Warnlog "Creating Style did not work. Dialog not up!"
	endif

   	printlog "   - assign new Character Style to a new text"
	'/// assign new character style to a new text ///
	wDokSchreiben "<Home><Down>",3
	wDokSchreiben "This is some new text <Return><Up><Up><Shift End>"
	Kontext "Stylist"
	TBGestalter.Click ZeichenVorlagen
	Vorlagenliste.TypeKeys "<Home>"
	if Vorlagenliste.GetSeltext = "Testtool" then
     	Vorlagenliste.TypeKeys "<Return>"
	else	
		For i = 1 to 100
			Vorlagenliste.TypeKeys "<Down>"
			if Vorlagenliste.GetSeltext = "Testtool" then
				Vorlagenliste.TypeKeys "<Return>"
				i = 102
			endif
		next i
	endif	
	Stylist.Close
	if i = 101 then
    	Warnlog "Created Style could not be found in Stylist!"
	else
    	Printlog "   - check Style"
		'/// check style ///
		FormatCharacter
		Kontext
		Active.SetPage TabFontEffects
		Kontext "TabFontEffects"
		if NOT Shadow.IsChecked then Warnlog "Shadow is not checked anymore"
		if StrikeThrough.GetSelIndex <> "2" then Warnlog "Wrong entry selection in StrikeThrough"
		if NOT Outline.IsChecked then Warnlog "Outline is not checked anymore"
		if Effects.GetSelIndex <> "3" then Warnlog "Wrong effect selected"
		if NOT Blinking.IsChecked then Warnlog "Blinking is not checked anymore"
		Kontext
		Active.Setpage TabHyperlinkZeichen
		Kontext "TabHyperlinkZeichen"
		if URLName.GetText <> "http://www.mikeportnoy.com/" then Warnlog "#i41171#TabHyperlink: URL is wrong " + URLName.Gettext
		TabHyperlinkZeichen.OK
	endif

	'/// Close document ///
	Call hCloseDocument
endcase

' **********************************************************************

testcase tKeyboardShortcutToStyles()
    '/// i29441 Assign Keyboard Shortcuts to Styles ///'
    dim sTempa as string
    dim sTempb as string
    dim sTempc as string
    dim i,x as integer

    '/// open new application document ///'
    call hNewDocument()

    '/// get current default style from TextObjectBar ///'
    kontext "TextObjectBar"
    sTempa = Vorlage.getSelText
    sTempc = sTempa
    for i = 3 to 0 step -1
        '/// Perform the Keycombination <CTRL>+3 (2,1,0) and check, if Style in TextObjectBar changed///'
        printlog "- <Ctrl>+<"+i+"> -> Heading "+i+" style"
        Call hTypeKeys("<Mod1 "+i+">")
        sleep 1
        kontext "TextObjectBar"
        sTempb = sTempa
        sTempa = Vorlage.getSelText
        if (sTempa <> sTempb) then
            printlog "OK: Heading changed: '" + sTempa + "'"
        else
            warnlog "Heading didn't change: '" + sTempa + "'"
        endif
    next i
    ' should now be the default from the beginning
    if (uCase(gApplication)<>"HTMLDOKUMENT") then
        if (sTempa = sTempc) then
            printlog "OK: Heading changed to default: '" + sTempa + "'"
        else
            warnlog "Heading didn't change to default: '" + sTempa + "'"
        endif
    endif

    '/// close document ///'
    call hCloseDocument()
endcase 
