'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_106bb_.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:28:08 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_106bb_
   printLog Chr(13) + "---------   Level 1 - Tools - Menu (3)   ----------"

   Call tToolsFootnotes
   Call tToolsTextInTables
   Call tToolsTextInTables2

end sub


testcase tToolsFootnotes
  PrintLog "- Tools / Checking Footnotes at end of page and end of document"

   Call hNewDocument
   ToolsFootnote
  Printlog "  - Footnote at end of page"
   Kontext
   Active.SetPage TabFussnoten
   Kontext "TabFussnoten"
   SeitenEnde.Check
   TabFussnoten.OK

   Sleep 3
   wDokSchreiben "Hallo die ist ein Text an dem gleich eine Funote angebunden wird"
   InsertFootnote
   Kontext "FussnoteEinfuegen"
   Fussnote.Check
   FussnoteEinfuegen.OK
   InsertFieldsPageNumbers
   wait 500
   wDokSchreiben "+0"
   wait 500
   wDokschreiben "<Shift Home>"
   Sleep 1
   try
    ToolsCalculate
   catch
     ' Workaround for bug.
     wDokSchreiben "<End>"
     wDokschreiben "<Shift Home>"
     try
      ToolsCalculate
      Warnlog "Selecting text in footnote with <Shift Home> works only at the second time (bug#101047)"
     catch
      Warnlog "Tools/Calculate is disabled!"
     endcatch
   endcatch
   Sleep 1
   if GetClipboardText <> "1" then Warnlog "Footnote at end of page: Footnote not at end of page 1 but " + GetClipboardText

   wDokSchreiben "<PageUp><Return>Dies ist die 2. Funote."
   InsertFootnote
   Kontext "FussnoteEinfuegen"
   Fussnote.Check
   FussnoteEinfuegen.OK
   InsertFieldsPageNumbers
   wDokSchreiben "+0"
   wDokschreiben "<Shift Home>"
   Sleep 1
   try
    ToolsCalculate
   catch
     ' Workaround for bug.
     wDokSchreiben "<End>"
     wDokschreiben "<Shift Home>"
     try
      ToolsCalculate
     catch
      Warnlog "Tools/Calculate is disabled!"
     endcatch
   endcatch
   Sleep 1
   if GetClipboardText <> "1" then Warnlog "Footnote at end of page: Footnote not at end of page 1 but " + GetClipboardText
   wDokSchreiben "<PageUp><Return>"

   ToolsFootnote
  Printlog "  - Footnote at end of document"
   Kontext
   Active.SetPage TabFussnoten
   Kontext "TabFussnoten"
   Dokumentende.Check
   TabFussnoten.OK

   wDokSchreiben "<PageUp><Return>Hallo dies ist wieder eine Funote."
   InsertFootnote
   Kontext "FussnoteEinfuegen"
   Fussnote.Check
   FussnoteEinfuegen.OK
   InsertFieldsPageNumbers
   wDokSchreiben "+0"
   wDokschreiben "<Shift Home>"
   Sleep 1
   try
    ToolsCalculate
   catch
     ' Workaround for bug.
     wDokSchreiben "<End>"
     wDokschreiben "<Shift Home>"
     try
      ToolsCalculate
     catch
      Warnlog "Tools/Calculate is disabled!"
     endcatch
   endcatch
   Sleep 1
   if GetClipboardText <> "2" then Warnlog "Footnote at end of document:Fottnote not at end of page 2 but " + GetClipboardText

   wDokSchreiben "<PageUp><Return>4. Funote!"
   InsertFootnote
   Kontext "FussnoteEinfuegen"
   Fussnote.Check
   FussnoteEinfuegen.OK
   InsertFieldsPageNumbers
   wDokSchreiben "+0<Mod1 Shift Home>"
   Sleep 1
   try
    ToolsCalculate
   catch
     ' Workaround for bug.
     wDokSchreiben "<End>"
     wDokschreiben "<Shift Home>"
     try
      ToolsCalculate
     catch
      Warnlog "Tools/Calculate is disabled!"
     endcatch
   endcatch
   if GetClipboardText <> "2" then Warnlog "Footnote at end of document:Fottnote not at end of page 2 but " + GetClipboardText

   Call hCloseDocument

endcase

' *******************************************************************
testcase tToolsTextInTables
  PrintLog "- Tools / Text <-> Table"

   Call  hNewDocument
  printlog "   - Text in Table : Seperators are Tabulators"
   wDokSchreiben ("Der<Tab>Text<Tab>soll<Tab>in<Tab>eine<Tab>Tabelle<Shift Home>")
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Tabulator.Check
   TextInTabelleUmwandeln.OK
   wDokSchreiben "<Left>"
   InTabelleKontrollieren

  printlog "   - Text in Table : Seperator is Tabulator"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Tabulator.Check
   TextInTabelleUmwandeln.OK
   InTextKontrollieren

  printlog "   - Text in Table : Seperator is tabulator with "
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Tabulator.Check
   GleicheBreite.Check
   TextInTabelleUmwandeln.OK
   wDokSchreiben "<Left>"
   InTabelleKontrollieren

  printlog "   - Text in Table : Seperator is tabulator"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Tabulator.Check
   TextInTabelleUmwandeln.OK
   InTextKontrollieren
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Tabulator.Check
   TextInTabelleUmwandeln.OK

  printlog "   - Text in Table : Seperator is Semicolon"
   wDokSchreiben "<Left>"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Semikolon.Check
   TextInTabelleUmwandeln.OK
   InTextKontrollieren

  printlog "   - Text in Table : Seperator is semicolon"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Semikolon.Check
   TextInTabelleUmwandeln.OK
   InTabelleKontrollieren

  printlog "   - Text in Table : Seperator is other ( comma )"
   wDokSchreiben "<Left>"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Andere.Check
   AndereText.SetText ","
   TextInTabelleUmwandeln.OK
   InTextKontrollieren

  printlog "   - Text in Table : Seperator is other ( comma )"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Andere.Check
   AndereText.SetText ","
   TextInTabelleUmwandeln.OK
   InTabelleKontrollieren

  printlog "   - Text in Table : Seperator is other ( space )"
   wDokSchreiben "<Left>"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Andere.Check
   AndereText.SetText " "
   TextInTabelleUmwandeln.OK
   InTextKontrollieren

  printlog "   - Text in Table : Seperator is other ( space )"
   wDokSchreiben "<Home><Shift End>"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Andere.Check
   AndereText.SetText " "
   TextInTabelleUmwandeln.OK
   InTabelleKontrollieren

  printlog "   - Text in Table : Seperator is paragraph"
   wDokSchreiben "<Left>"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Absatz.Check
   TextInTabelleUmwandeln.OK
   InTextKontrollieren
   Call wDokSchreiben "<Shift Down><Shift End>", 5

  printlog "   - Text in Table : Seperator is paragraph"
   ToolsTextInTable
   Kontext "TextInTabelleUmwandeln"
   Absatz.Check
   TextInTabelleUmwandeln.OK
   InTabelleKontrollierenExtra
   InTabelleKontrollieren

   Call hCloseDocument
endcase


' *******************************************************************
testcase tToolsTextInTables2
    PrintLog "- Tools / Text <-> Table with more lines "

    Call  hNewDocument
    printlog "   - Text in Table : Seperator are Tabulators"
    Call wDokSchreiben ("Dieser<Tab>Text<Tab>soll<Tab>in<Tab>eine<Tab>Tab<Return>")
    Call wDokSchreiben ("Dieser<Tab>Text<Tab>soll<Tab>auch<Tab>in<Tab>Tab<Return>")
    Call wDokSchreiben ("Dies<Tab><Tab><Tab>in<Tab>eine<Tab>Tab<Return>")
    Call wDokSchreiben ("Dieser<Tab>Text<Tab>soll<Tab>auch<Tab>in<Tab>Tab")
    Call wDokSchreiben ("<Mod1 A>"
    ToolsTextInTable
    Kontext "TextInTabelleUmwandeln"
    Tabulator.Check
    TextInTabelleUmwandeln.OK
    wait 500
    Call wDokSchreiben "<Tab><Mod1 A>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if GetClipboardText <> "Text" then Warnlog "1. Text wrong!"

    Call wDokSchreiben "<Down><Down><Shift End>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if GetClipboardText <> "" then Warnlog "2. Text wrong!"
    Call wDokSchreiben "<Right><Shift End>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if GetClipboardText <> "" then Warnlog "3. Text wrong!"
    Call wDokSchreiben "<Right><Mod1 A>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if GetClipboardText <> "in" then Warnlog "4. Text wrong!"
    Call wDokSchreiben "<Right><Tab><Tab><Mod1 A>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if GetClipboardText <> "Dieser" then
        if GetClipBoardtext <> "Diese" then
            Warnlog "5. Text wrong!"
        endif
    endif
    Call wDokSchreiben "<Right><Tab><Tab><Tab><Tab><Shift End>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if GetClipboardText <> "Tab" then Warnlog "6. Text wrong!"

    printlog "   - Text in Table : Seperator is tabulator"
    Call wDokSchreiben "<Mod1 a>"
    ToolsTextInTable
    Kontext "TextInTabelleUmwandeln"
    Tabulator.Check
    TextInTabelleUmwandeln.OK
    Call wDokSchreiben "<Mod1 Home><Mod1 Shift Right>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if Left$(GetClipboardText,6) <> "Dieser" then Warnlog "1. Text wrong!"
    Call wDokSchreiben "<Down><Home><Mod1 Shift Right>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if Left$(GetClipboardText,6) <> "Dieser" then Warnlog "2. Text wrong!"
    Call wDokSchreiben "<Down><Home><Mod1 Right><Mod1 Right><Mod1 Right><Mod1 Shift Right>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if Left$(GetClipboardText,4) <> "Tab" then Warnlog "3. Text wrong!"
    Call wDokSchreiben "<Down><Mod1 Left><Mod1 Left><Mod1 Shift Right>"
    try
        EditCopy
    catch
        Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    endcatch
    if Left$(GetClipboardText,2) <> "in" then Warnlog "4. Text wrong!"
    Call hCloseDocument
endcase
