'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_106a_.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:27:50 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_106a_
   printLog Chr(13) + "---------   Level 1 - Tools - Menu (2)   ----------"

   Call tToolsHyphenation1                   ' ohne Trennmglichkeit
   Call tToolsHyphenation2                   ' mit Trennmglichkeiten
   Call tToolsAutocorrectReplace
   Call tToolsAutocorrectExceptions1           ' nach Punkten hinter Abkrzungen nicht gro schreiben
   Call tToolsAutocorrectExceptions2           ' Wrter mit zwei Grobuchsteben am Anfang
   Call tToolsAutocorrectExceptions3
   Call tToolsAutocorrectDoubleQuotes
   Call tToolsAutocorrectSingleQuotes
'  Call tToolsAutocorrectOptions      ' nach Umstellung der Liste kein Test mehr mglich
   Call tToolsAutocorrectWordCompletion
end sub

' *******************************************************************
testcase tToolsHyphenation1
  PrintLog "- Tools / Hyphenation the first"
   Select Case iSprache
       case 81 : Printlog "- No Hyphenation in Japanese!"
                 goto endsub
       case 82 : Printlog "- No Hyphenation in Korean!"
                 goto endsub
       case 86 : Printlog "- No Hyphenation in Chinese (simplified)!"
                 goto endsub
       case 88 : Printlog "- No Hyphenation in Chinese (traditional)!"
                 goto endsub
   end select

   Call hNewDocument
   printlog "   - Hyphenation without a text"
   '/// New writerdocument ///
   ToolsLanguageHyphenate
   '/// Call 'Hyphenate' without any text written ///
   Kontext "Silbentrennung"
   if Silbentrennung.Exists then
      Warnlog "Dialog 'Hyphenation' is up"
      Silbentrennung.Cancel
   else
      Kontext "Active"
      if Active.Exists then
         Active.OK
      else
         Warnlog "Hyphenation gives no notification of finishing"
      end if
   end if

   printlog "   - Hyphenation with text but no possibility of hyphenation"
   '/// insert a text, with no possibility of hyphenation" ///
   select case iSprache
      case 01 : Call wDokSchreiben "This ist a text with no splitting words"
      '/// English: "This ist a text with no splitting words" ///
      case 03 : Call wDokschreiben "Sero eliminados todos os ficheiros e todas as pastas criados pelo programa durante ... "
      '/// Portuguese: "Sero eliminados todos os ficheiros e todas as pastas criados pelo programa durante ... " ///
      case 31 : Call wDokSchreiben "Wijek danken u voor uw interesse in het samenwerken met Star Division. "
      '/// Dutch: "Wijek danken u voor uw interesse in het samenwerken met Star Division. " ///
      case 33 : Call wDokSchreiben "Merci beaucoup pout votre candidature du 13/11/97."
      '/// French: "Merci beaucoup pout votre candidature du 13/11/97." ///
      case 34 : Call wDokSchreiben "Aunque se descarta de momento una vacunacin masiva a nivel nacional.."
      '/// Spanish "Aunque se descarta de momento una vacunacin masiva a nivel nacional.." ///
      case 39 : Call wDokSchreiben "Il documento 'Senza nome 1'  stato modififcato"
      '/// Italian: "Il documento 'Senza nome 1'  stato modififcato" ///
      case 45 : Call wDokschreiben "Stats- og regeringscheferne mtte udskyde den bebudede reform af EU-Kommissionen.."
      '/// Danish: "Stats- og regeringscheferne mtte udskyde den bebudede reform af EU-Kommissionen.." ///
      case 46 : Call wDokschreiben "P den hr sidan matar Du in Ditt kundnummer och Din registreringsnyckel."
      '/// Swedish: "P den hr sidan matar Du in Ditt kundnummer och Din registreringsnyckel." ///
      case 48 : Call wDokschreiben "Nie wolno w zadnim wypadku przerywa uruchomionego serwisu"
      '/// Polish: "Nie wolno w zadnim wypadku przerywa uruchomionego serwisu" ///
      case 49 : Call wDokSchreiben "Dies ist ein Text ohne eine Mglichkeit Wrter zu trennen"
      '/// German: "Dies ist ein Text ohne eine Mglichkeit Wrter zu trennen" ///
      case else : Warnlog "No text  for language " + iSprache + " created. No test!"
                  Call hCloseDocument
                  goto endsub
   end select
   Call wDokSchreiben "<Home>"
   '/// Point cursor <Home> and select Tools / Hyphenate ///
   ToolsLanguageHyphenate
   Kontext "Silbentrennung"
   '/// A messagebox instead of Hyphenation-dialog should appear ///
   if Silbentrennung.Exists then
      Warnlog "Dialog is up"
      Silbentrennung.Cancel
   else
      Kontext "Active"
      '/// Close Messagebox ///
      if Active.Exists then Active.OK
   end if
   '/// Close writerdocument ///
   Call hCloseDocument
endcase
' *******************************************************************
testcase tToolsHyphenation2
  Dim i : Dim Zaehler : Dim DasWort$ : Dim Trenner : Dim pos : Dim Dummy
  Dim InsFile as string

  PrintLog "- Tools / Hyphenation the 2nd"
   '/// Open writerdocument depending on office language (except Asian-Versions) ///
   Select Case iSprache
       case 81 : Printlog "- No Hyphenation in Japanese!"
                 goto endsub
       case 82 : Printlog "- No Hyphenation in Korean!"
                 goto endsub
       case 86 : Printlog "- No Hyphenation in Chinese (simplified)!"
                 goto endsub
       case 88 : Printlog "- No Hyphenation in Chinese (traditional)!"
                 goto endsub
   end select
    select case iSprache
      case 01 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\001.sxw" )
      '/// English: gTesttoolPath + "writer\\level1\\input\\linguistik\\001.sxw" ///
      case 03 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\003.sxw" )
      '/// Portuguese: gTesttoolPath + "writer\\level1\\input\\linguistik\\003.sxw" ///
      case 31 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\031.sxw" )
      '/// Dutch: gTesttoolPath + "writer\\level1\\input\\linguistik\\031.sxw" ///
      case 33 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\033.sxw" )
      '/// French: gTesttoolPath + "writer\\level1\\input\\linguistik\\033.sxw" ///
      case 34 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\034.sxw" )
      '/// Spanish: gTesttoolPath + "writer\\level1\\input\\linguistik\\034.sxw" ///
      case 39 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\039.sxw" )
      '/// Italian: gTesttoolPath + "writer\\level1\\input\\linguistik\\039.sxw" ///
      case 45 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\045.sxw" )
      '/// Danish: gTesttoolPath + "writer\\level1\\input\\linguistik\\045.sxw" ///
      case 46 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\046.sxw" )
      '/// Swedish: gTesttoolPath + "writer\\level1\\input\\linguistik\\046.sxw" ///
      case 48 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\048.sxw" )
      '/// Polish: gTesttoolPath + "writer\\level1\\input\\linguistik\\048.sxw" ///
      case 49 : InsFile = Convertpath ( gTesttoolPath + "writer\level1\input\linguistik\049.sxw" )
      '/// German: gTesttoolPath + "writer\\level1\\input\\linguistik\\049.sxw" ///
      case else : Warnlog "No document for language " + iSprache + " created. No test!"
                  goto endsub
    end select

   if gApplication = "MASTERDOC" then
    if wInsertDocumentinMasterDoc(InsFile) = False then goto endsub
    EditPaste
    Call wDokschreiben("<PageUp>",2)
    Call wDokschreiben("<Home>")
   else
    Call hDateiOeffnen(InsFile)
   endif

  Zaehler = 10 : Trenner = 10 : Dummy = 10

  printlog "-  check 'Next'"
   '/// Point cursor <Home> in document ///
   Call wDokSchreiben "<up>", 10
   Call wDokSchreiben "<Home>"
   ToolsLanguageHyphenate
   '/// Execute Hyphenation ///
   Kontext "Silbentrennung"
   if Not Silbentrennung.Exists then
    Kontext "Active"
    if Active.Exists then
     if Active.GetRT = 304 then
      Active.Ok
      ' Force pagesize change to bringup Hyphenation-dialog
      FormatPageWriter
      Kontext
      active.SetPage TabSeite
      Kontext "TabSeite"
      Breite.Settext "15"
      TabSeite.Ok
      Sleep 1
      ToolsLanguageHyphenate
      Kontext "Silbentrennung"
       if Not Silbentrennung.Exists then
         Warnlog "Unable to bring up Dialog 'Hyphenation'!"
         goto endsub
       endif
     endif
    endif
   endif
   '/// In Hyphenation dialog click 'Next' until disabled ///
    for i=1 to Zaehler
       Kontext "Silbentrennung"
       if Weiter.IsEnabled then Weiter.Click
       Kontext "Active"
        if Active.Exists then
         if i < Zaehler then printlog "-   In this case left sub on entry " + i
         i = Zaehler + 1
        endif
       Sleep 1
    next i
    Kontext "Active"
    if Active.Exists then
       Active.OK
    else
   '/// A "Completed" messagebox should appear ///
       Warnlog "- No completion message"
       Kontext "Silbentrennung"
       if Silbentrennung.Exists then
          Warnlog "Dialog 'Hyphenate' should have been closed"
          Silbentrennung.Cancel
       end if
    end if

   printlog "-  test 'Seperate'"
    Call wDokSchreiben "<Up>",25
    Call wDokSchreiben "<Home>"

   '/// Test 'Seperate' ///
    ToolsLanguageHyphenate
    Kontext "Silbentrennung"
    for i=1 to Trenner
     Kontext "Silbentrennung"
      if i=1 then
       DasWort$ = Wort.Gettext     ' remember first word found !
       pos = instr(DasWort$,"-")
       if pos > 0 then             ' Remove "-" from word
        DasWort$ = Left(DasWort$, pos - 1) + Mid(DasWort$, pos + 1, Len(DasWort$) - pos)
       endif
       Weiter.Click                ' jump to next
      endif
      Silbentrennung.Ok
      Kontext "Active"
       if Active.Exists then
        if i < Trenner then printlog "-  In this case left sub on entry " + i
        i = Trenner +1
       endif
    next i
    wait 500
    Kontext "Active"
    if Active.Exists then
       Active.OK
    else
       Warnlog "- No completion message"
       Kontext "Silbentrennung"
       if Silbentrennung.Exists then
          Warnlog "Dialog 'Hyphenation' should have been closed"
          Silbentrennung.Cancel
       end if
    end if

   printlog "-  'Hyphenation' for only one word"
   '/// Hyphenation for only one word ///
    ' Remove "=" from string
    for i=1 to Dummy
     pos = instr(DasWort$,"=")
      if pos > 0 then             ' Bindestrich rausfiltern
       DasWort$ = Left(DasWort$, pos - 1) + Mid(DasWort$, pos + 1, Len(DasWort$) - pos)
      else
       i = Dummy +1
      endif
    next i

    Call wDokSchreiben "<Up>",25
    Call wDokSchreiben "<Home>"
    EditSearchAndReplace
    Kontext "FindAndReplace"
    SearchFor.Settext DasWort$
    Search.Click
    Kontext "Active"
    if Active.Exists then
     if active.GetRT = 304 then
       Warnlog "- Word to test not found ! No hyphenation for 1 Word! " + DasWort$
       try
        Active.Ok
       catch
        Warnlog Active.Gettext
        Active.yes
       endcatch
       Kontext "FindAndReplace"
       FindAndReplace.Cancel
       Goto Hiergehtsweiter
     endif
    endif

     Kontext "FindAndReplace"
     FindAndReplace.Cancel
     EditCopy
     if GetClipboardText <> DasWort$ then
       Warnlog "- Wrong word selected! Is: " + GetClipBoardtext
     else
       ToolsLanguageHyphenate
       Kontext "Silbentrennung"
       if Silbentrennung.Exists then
         Silbentrennung.Ok
         Sleep 2
       endif
       Kontext "Active"
       if Active.Exists then
         Active.OK
       else
         Warnlog "No final notification"
         Kontext "Silbentrennung"
         if Silbentrennung.Exists then
          Warnlog "Dialog 'Hyphenation' should have benn closed"
          Silbentrennung.Cancel
        endif
       endif
     endif

Hiergehtsweiter:
   printlog "-  check 'Undo Seperate'"
   '/// check Undo Seperate ///
    ToolsLanguageHyphenate
    Kontext "Active"
    if Active.Exists then
     if Active.GetRT = 304 then
      try   ' Continue Checking at beginning of document ?
       Active.Yes
      catch
       Warnlog Active.Gettext + " Bug#90775"
       Active.Ok
       Call hCloseDocument
       goto endsub
      endcatch
     endif
    endif
    Kontext "Silbentrennung"
    if Not Silbentrennung.Exists then
     Kontext "Active"
       Warnlog Active.Gettext + " Bug#90775"
       Active.Ok
       Call hCloseDocument
       goto endsub
    endif
    for i=1 to Zaehler
       Kontext "Silbentrennung"
       if Entfernen.IsEnabled then Entfernen.Click
       Kontext "Active"
        if Active.Exists then
         try
          Active.Yes  ' msgbox 'Continue checking at beginning of document'
         catch
          if i < Zaehler then printlog "-   In this case left sub on entry " + i
          i = Zaehler + 1
         endcatch
        endif
       Sleep 1
    next i
    Kontext "Active"
    if Active.Exists then
     if Active.GetRT = 304 then
       try
         Active.Yes
        catch
         Active.OK
        endcatch
     else
       Warnlog "- No final message"
       Kontext "Silbentrennung"
       if Silbentrennung.Exists then
          Warnlog "Dialog 'Hyphenation' should have been closed"
          Silbentrennung.Cancel
       end if
     end if
    endif
    Kontext "Active"
    if Active.Exists then
     if Active.GetRT = 304 then Active.Ok
    endif
    Sleep 2
    Call wDokSchreiben "<up>", 10
    Call wDokSchreiben "<Home>"
    EditSearchAndReplace
    Kontext "FindAndReplace"
    SearchFor.Settext DasWort$
    Search.Click

    Kontext "Active"
    if Active.Exists then
     if Active.GetRT = 304 then
      try
       Active.Ok
      catch
       Active.yes
       wait 500
       Kontext "Active"
        if Active.Exists then
         if Active.GetRT = 304 then Active.Ok
        endif
      endcatch
     endif
    endif
    Kontext "FindAndReplace"
    FindAndReplace.Cancel
    EditCopy
    if GetClipboardText <> DasWort$ then Warnlog "Undo of seperation has not been lifted up / performed."

   printlog "-  check 'next and back'"
   '/// check 'next' and 'back' ///
    ToolsLanguageHyphenate
    Kontext "Silbentrennung"
    for i=1 to Zaehler
       if Vor.IsEnabled then Vor.Click
    next i
    if Vor.IsEnabled then Warnlog "'Next' is active!"

    for i=1 to Zaehler
       if Zurueck.IsEnabled then Zurueck.Click
    next i
    if Zurueck.IsEnabled then Warnlog "'Back' is active!"
    Silbentrennung.Cancel
    '/// Close writerdocument ///
   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsAutocorrectReplace
  Dim i as Integer , oSprache as string
  Dim IstWort(3) as string,SollWort(3) as string
  PrintLog "- Tools / Autocorrect / Replace"

   Call hNewDocument
   '/// Open a new document ///
   Printlog "   - pick up text"
   Call wDokSchreiben "Azbz<Shift Home>"
   '/// Enter text "Azbz" in document ///
   Wait 500
   Call OptionenAufrufen("TabErsetzung")
   '/// Call Tools / Autocorrect/Autoformat ///

   'select case iSystemSprache
   '    case 01,1 : oSprache = "English (USA)"
   '    case 03   : oSprache = "Portugus"
   '    case 31   : oSprache = "Nederlands"
   '    case 33   : oSprache = "Franais (France)"
   '    case 34   : oSprache = "Espaol (Espaa)"
   '    case 39   : oSprache = "Italiano (Italia)"
   '    case 45   : oSprache = "Dansk"
   '    case 46   : oSprache = "svenska (Sverige)"
   '    case 48   : oSprache = "Polski"
   '    case 49   : oSprache = "Deutsch (Deutschland)"
   'end select
   '/// Select Tabpage 'Replace' and check if selected language is the same like Office-language ///
   'if oSprache > "" then
   ' if WelcheSprache.GetSeltext <> oSprache then
   '   Warnlog "Wrong default-language for replacement and exceptions!"
   '   try
   '      WelcheSprache.Select oSprache
   '   catch
   '      Warnlog "Unable to select language: " + oSprache
   '      Kontext "TabErsetzung"
   '      TabErsetzung.Cancel
   '      Call hCloseDocument
   '      goto endsub
   '   endcatch
   ' endif
   'endif

  '/// Check checkbox 'Text only' ///
  if NurText.IsEnabled then NurText.Check
   '/// Set as word to replace : 'Azzb' ///
   Kuerzel.SetText "Azzb"
   wait 100

   if NOT Neu.IsEnabled then
      Warnlog "New-Button is disabled, maybe the replacing text already exists!"
   else
      Neu.Click
      '/// Hit button 'New' ///
   end if
    IstWort(1) = "Azzb"
    SollWort(1)= "Azbz"
    '/// Read and remember two additional pairs from list ///
   Liste.Select Liste.GetItemCount / 2
    IstWort(2) = Kuerzel.Gettext
    SollWort(2)= ReplaceWith.Gettext
   Liste.Select Liste.GetItemCount
    IstWort(3) = Kuerzel.Gettext
    SollWort(3)= ReplaceWith.Gettext
   TabErsetzung.OK
   '/// Close Autocorrect-dialog ///

   Sleep 2
   Call wDokSchreiben "<Delete>"
   Call wDokSchreiben "Azzb"
   '/// Write down 'Azzb' in document and enter a 'Space' ///
   wait 500
   Call wDokSchreiben "<Space>"
   Sleep 3
   Call wDokSchreiben "<Left><Shift Home>"
   Sleep 3
   EditCopy
   '/// Check if word has been replaced with 'Azbz' ///
   if GetClipboardText <> "Azbz" then Warnlog "Text has not been automatically replaced!"

  Printlog "   - delete entry from replace list"
   '/// Reopen 'Autocorrectur' dialog and delete entry from replace-list ///
   OptionenAufrufen("TabErsetzung")
   for i=1 to 1000
      if Kuerzel.GetText = "Azzb" then
         i=1001
      else
         Liste.Typekeys "<Down>"
      end if
   next i
   wait 100
   try
    Loeschen.Click
   catch
    Warnlog "Unable to delete entry! Not found or button disabled!"
   endcatch
   TabErsetzung.OK

   '/// Check if word will be replaced though it has been deleted from list ///
   Call wDokSchreiben "<Delete>"
   Call wDokSchreiben "Azzb "
   Sleep 1
   Call wDokSchreiben "<Left><Shift Home>"
   EditCopy
   if GetClipboardText <> "Azzb" then Warnlog "Text has still not been replaced"

   Call wDokSchreiben "Replace function corrects the following words : <Return>"
   For i = 2 to 3
      printlog IstWort(i) + " should have been replaced with: " + Sollwort(i)
      Call wDokSchreiben IstWort(i) + "<Return>"
      Call wDokSchreiben "<Up><Home>"
      Call wDokSchreiben "<Shift End>"
      EditCopy
      if GetClipboardtext <> Sollwort(i) then
         Warnlog "- False!"
      else
         printlog "- True!"
      endif
      Call wDokSchreiben "<Delete>"
   next i

   '/// Close document ///
   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsAutocorrectExceptions1
  Dim i, oSprache as string
  Dim IstWort1 as string, IstWort2 as string, IstWort3 as string

  Printlog "- Tools / Autocorrect  Exceptions  => Test abbreviation "

  Printlog "   - check, if it works"
   Call hNewDocument
   wDokSchreiben "Upps. hallo <Mod1 Left><Shift Right>"
   EditCopy
   if GetClipboardText <> "H" then Warnlog "Second word has no capital letter as a first character!"
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - Enter exception"
   Call OptionenAufrufen("TabErsetzung")
   select case iSprache
       case 01 : oSprache = "English (USA)"
       case 03 : oSprache = "Portugus"
       case 31 : oSprache = "Nederlands (NL)"
       case 33 : oSprache = "Franais (France)"
       case 34 : oSprache = "Espaol (Espaa)"
       case 39 : oSprache = "Italiano (Italia)"
       case 45 : oSprache = "Dansk"
       case 46 : oSprache = "svenska (Sverige)"
       case 48 : oSprache = "Polski"
       case 49 : oSprache = "Deutsch (Deutschland)"
   end select
   if oSprache > "" then
    if WelcheSprache.GetSeltext <> oSprache then
      try
          WelcheSprache.Select oSprache
      catch
         Warnlog "Unable to select language: " + oSprache
         Kontext "TabErsetzung"
         TabErsetzung.Cancel
         Call hCloseDocument
         goto endsub
      endcatch
    endif
   endif
   Kontext
   Active.Setpage TabAusnahmen
   Kontext "TabAusnahmen"

   Abkuerzungen.SetText "Apps."
   Wait 100
   if AbkuerzungenNeu.IsEnabled then AbkuerzungenNeu.Click

  Printlog "   - check, if entry is in list"
   Abkuerzungen.SetText "Apps."
   Wait 100
   if NOT AbkuerzungenLoeschen.IsEnabled then Warnlog "Entry is not in list"
   TabAusnahmen.OK

  Printlog "   - check exception"
   wDokSchreiben "Apps. hallo <Mod1 Left><Shift Right>"
   EditCopy
   if GetClipboardText <> "h" then Warnlog "Though the word is in the Exceptions-list, it is in capital letters!"
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - delete exception"
   OptionenAufrufen("TabAusnahmen")
   Abkuerzungen.SetText "Apps."
   Wait 100
   if NOT AbkuerzungenLoeschen.IsEnabled then
      Warnlog "Entry is not in list"
   else
      AbkuerzungenLoeschen.Click
   end if
    IstWort1 = AbkuerzungenListe.GetItemtext(1)
    IstWort2 = AbkuerzungenListe.GetItemtext(AbkuerzungenListe.GetItemCount / 2)
    IstWort3 = AbkuerzungenListe.GetItemtext(AbkuerzungenListe.GetItemCount)
   TabAusnahmen.OK

   Printlog "   - check deleted exception"
   wDokSchreiben "<Home><Shift End><Delete>"
   wait 100
   wDokSchreiben "Apps. hallo <Mod1 Left><Shift Right>"
   EditCopy
   if GetClipboardText <> "H" then Warnlog "Second word has not been written in capital letters"

    Call wDokSchreiben "<Home><Shift End><Backspace>"
    Call wDokSchreiben "dieserSatz beginnt gro."
    Call wDokSchreiben " dieser hoffentlich auch.<Return>"
    Call wDokSchreiben "hinter " + IstWort1 + " und " + IstWort2 + " geht's klein weiter,"
    Call wDokSchreiben " genau wie hinter "+ IstWort3 + " saubere Sache. <Return>"
    Call hCloseDocument
endcase
' *******************************************************************
testcase tToolsAutocorrectExceptions2
   Dim IstWort1 as string, IstWort2 as string, IstWort3 as string
   Dim i, oSprache as string
  Printlog "- Tools / Autocorrect Tabpage Exceptions  => Two capital letter at the beginning of a word"

   Call hNewDocument
  Printlog "   - check if it works"
   wDokSchreiben "HHallo <Home><Right><Shift Right>"
   EditCopy
   if GetClipboardText <> "h" then Warnlog "Second character has not been replaced"
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - enter exception"
   OptionenAufrufen("TabErsetzung")
   select case iSprache
       case 01 : oSprache = "English (USA)"
       case 03 : oSprache = "Portugus"
       case 31 : oSprache = "Nederlands (NL)"
       case 33 : oSprache = "Franais (France)"
       case 34 : oSprache = "Espaol (Espaa)"
       case 39 : oSprache = "Italiano (Italia)"
       case 45 : oSprache = "Dansk"
       case 46 : oSprache = "svenska (Sverige)"
       case 48 : oSprache = "Polski"
       case 49 : oSprache = "Deutsch (Deutschland)"
   end select
   if oSprache > "" then
    if WelcheSprache.GetSeltext <> oSprache then
       try
          WelcheSprache.Select oSprache
       catch
          Warnlog "Unable to select language: " + oSprache
          Kontext "TabErsetzung"
          TabErsetzung.Cancel
          Call hCloseDocument
          goto endsub
       endcatch
    endif
   endif
   Kontext
   Active.Setpage TabAusnahmen
   Kontext "TabAusnahmen"

   Woerter.SetText "HHallo"
   Wait 100
   if WoerterNeu.IsEnabled then WoerterNeu.Click
  Printlog "   - check if entry is in list"
   Woerter.SetText "HHallo"
   Wait 100
   if NOT WoerterLoeschen.IsEnabled then Warnlog "Entry is not in list"
   TabAusnahmen.OK

  Printlog "   - check exceptions"
   wDokSchreiben "HHallo <Home><Right><Shift Right>"
   EditCopy
   if GetClipboardText <> "H" then Warnlog "Second character is not a capital letter"
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - delete exception"
   OptionenAufrufen("TabAusnahmen")
   Woerter.SetText "HHallo"
   Wait 100
   if NOT WoerterLoeschen.IsEnabled then
      Warnlog "Entry is not in list"
   else
      WoerterLoeschen.Click
   end if
    IstWort1 = WoerterListe.GetItemtext(1)
    IstWort2 = WoerterListe.GetItemtext(WoerterListe.GetItemCount / 2)
    IstWort3 = WoerterListe.GetItemtext(WoerterListe.GetItemCount)
   TabAusnahmen.OK

  Printlog "   - check deleted exception"
   wDokSchreiben "HHallo <Home><Right><Shift Right>"
   EditCopy
   if GetClipboardText <> "h" then Warnlog "Second character is not a capital letter"
   Call wDokSchreiben "<End><Return>"
   Call wDokSchreiben "ZWei GRossbuchstaben sollten ersetzt werden.<Return>"
   Call wDokSchreiben "Nur nicht " + IstWort1 + ", " + IstWort2 + " und " + IstWort3 + ".<Return>"

   Call hCloseDocument
endcase
' *******************************************************************

testcase tToolsAutocorrectExceptions3
 Printlog "- Tools / Autocorrect / Special Characters"
 Call hNewDocument
 TypeKeysDelay 9000
 RemoteCommandDelay true

 Call wDokSchreiben "Autokorrektur whrend der Eingabe<Return>"
 Call wDokSchreiben "1st<Return>"
 Call wDokSchreiben "2nd<Return>"
 Call wDokSchreiben "3rd<Return>"
 Call wDokSchreiben "4th<Return>"
 Call wDokSchreiben "Dies wird ein ganz *fetter* Text!<Return>"
 Call wDokSchreiben "Natrlich gibt es auch die _unterstrichene_ Variante!<Return>"
 Call wDokSchreiben "Diese www.tolle.adresse und diese@adresse.sollten als hervorgehobene und unterstrichene URLs erscheinen.<Return>"
 Call wDokSchreiben "Ein 1/2 Schwein, ein 1/4 Liter Sauce und einen 3/4 Liter Bier<Return>"

 Call wDokSchreiben "1. Ich sollte zur<Return>"
 Call wDokSchreiben "Numerierung werden aber<Return><BackSpace>"
 Call wDokSchreiben "hier verliere ich meine Nummerierung, behalte aber meine Einrckung, und... <Return>"
 Call wDokSchreiben "Hoppala! Wieder nummeriert aber <Return><Return>"
 Call wDokSchreiben "Jetzt ist Schluss: bin ganz normal, oder????<Return><Return>"

 Call wDokSchreiben "Es folgt eine schne Linie mit 0,5ptEinzelstrich unten:<Return>"
 Call wDokSchreiben "---<Return>"
 Call wDokSchreiben "Hier mit 1,0pt Einzelstrich unten:<Return>"
 Call wDokSchreiben "___<Return>"
 Call wDokSchreiben "Hier mit 1.1pt Doppelstrich unten:<Return>"
 Call wDokSchreiben "===<Return>"
 Call wDokSchreiben "Hier mit 4.5pt Doppelstrich unten:<Return>"
 Call wDokSchreiben "***<Return>"
 Call wDokSchreiben "Hier mit 6,0pt Doppelstrich unten:<Return>"
 Call wDokSchreiben "~~~<Return>"
 Call wDokSchreiben "Hier mit 9,0pt Doppelstrich unten:<Return>"
 Call wDokSchreiben "###<Return>"

 Call wDokSchreiben "Und jetzt eine zweizellige Tabelle:<Return>"
 Call wDokSchreiben "+----+----+"
 Wait 500
 Call wDokSchreiben "<Return>"
 Wait 500
 Call wDokSchreiben "<Down><Return>"

 Call wDokSchreiben "Und jetzt eine berschrift!<Return><Return>"
 Call wDokSchreiben "Keine Wortergnzung oder doch Wor<Return>"
 Sleep 1
 Call wDokSchreiben "tergnzung?<Return>"

 RemoteCommandDelay false
 Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsAutocorrectDoubleQuotes
  Dim Vorn$ : Dim Hinten$ : Dim Normal$

  Printlog "- Tools / Autocorrect / Custom Quotes   ( Double Quotes )"
   if bAsianLan = True then
    printlog "- Not in Asian languages!"
    goto endsub
   endif
   Call hNewDocument
      select case iSprache
          'case 01 : Normal$ = Chr(34) : Vorn$ = Chr(147) : Hinten$ = Chr(148)
          'Unicode
          case 01 : Normal$ = Chr(34) : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
          'case 03 : Normal$ = Chr(34) : Vorn$ = Chr(147) : Hinten$ = Chr(148)
          case 03 : Normal$ = Chr(34) : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
          case 07 : Warnlog "Test not possible. No quotes in russian !"
                    Call hCloseDocument
                    goto endsub
          'case 31 : Normal$ = Chr(34) : Vorn$ = Chr(147) : Hinten$ = Chr(148)
          case 31 : Normal$ = Chr(34) : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
          case 33 : Normal$ = Chr(34) : Vorn$ = Chr(171) : Hinten$ = Chr(187)
          'case 34 : Normal$ = Chr(34) : Vorn$ = Chr(147) : Hinten$ = Chr(148)
          case 34 : Normal$ = Chr(34) : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
          'case 39 : Normal$ = Chr(34) : Vorn$ = Chr(147) : Hinten$ = Chr(148)
          case 39 : Normal$ = Chr(34) : Vorn$ = Chr(8220) : Hinten$ = Chr(8221)
          'case 45 : Normal$ = Chr(34) : Vorn$ = Chr(148) : Hinten$ = Chr(148)
          case 45 : Normal$ = Chr(34) : Vorn$ = Chr(8221) : Hinten$ = Chr(8221)
          'case 46 : Normal$ = Chr(34) : Vorn$ = Chr(39) : Hinten$ = Chr(39)
          case 46 : Normal$ = Chr(34) : Vorn$ = Chr(39) : Hinten$ = Chr(39)
          'case 48 : Normal$ = Chr(132) : Vorn$ = Chr(132) : Hinten$ = Chr(147)
          case 48 : Normal$ = Chr(8222) : Vorn$ = Chr(8222) : Hinten$ = Chr(8220)
          'case 49 : Normal$ = Chr(34) : Vorn$ = Chr(132) : Hinten$ = Chr(147)
          case 49 : Normal$ = Chr(34) : Vorn$ = Chr(8222) : Hinten$ = Chr(8220)
      end select

  Printlog "   - replace double quotes"
   OptionenAufrufen("TabTypografisch")
   DoppelteReplace.Check
   TabTypografisch.OK
   wDokSchreiben ( Normal$ + "Hallo" + Normal$ + " " )
   wait 100
   wDokSchreiben "<Home><Shift Right>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Vorn$ then Warnlog "Start quotes is not " + Vorn$ + " but " + GetClipBoardtext
   wDokSchreiben "<End><Left><Shift Left>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Hinten$ then Warnlog "End quotes is not " + Hinten$ + " but " + GetClipBoardtext
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - don't replace double quotes!"
   CheckUberpruefen ( Normal$ + "Hallo" + Normal$ + " " )
   OptionenAufrufen("TabTypografisch")
   DoppelteReplace.Uncheck
   TabTypografisch.OK
   wDokSchreiben ( Normal$ + "Hallo" + Normal$ + " " )
   wait 100
   wDokSchreiben "<Home><Shift Right>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Normal$ then Warnlog "Start character is not " + Normal$ + " but " + GetClipBoardtext
   wDokSchreiben "<End><Left><Shift Left>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Normal$ then Warnlog "End character is not " + Normal$ + " but " + GetClipBoardtext
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - replace character"
   OptionenAufrufen("TabTypografisch")
   DoppelteReplace.Check
   DoppeltWortAnfang.Click
   Kontext "Sonderzeichen"
   Schriftliste.TypeKeys "<PageUp><Home>"
   Schriftliste.TypeKeys "<Right>", 59
   Schriftliste.TypeKeys "<Space>"
   Sonderzeichen.OK
   Kontext "TabTypografisch"
   DoppeltWortEnde.Click
   Kontext "Sonderzeichen"
   Schriftliste.TypeKeys "<PageUp><Home>"
   Schriftliste.TypeKeys "<Right>", 61
   Schriftliste.TypeKeys "<Space>"
   Sonderzeichen.OK
   Kontext "TabTypografisch"
   TabTypografisch.OK
   wDokSchreiben ( Normal$ + "Hallo" + Normal$ + " " )
   wait 100
   wDokSchreiben "<Home><Shift Right>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Chr(91) then Warnlog "Start character not " + Chr(91) + " but " + GetClipBoardtext
   wDokSchreiben "<End><Left><Shift Left>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Chr(93) then Warnlog "End character not " + Chr(93) + " but " + GetClipBoardtext
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - back to default"
   OptionenAufrufen("TabTypografisch")
   DoppelteReplace.Check
   DoppeltStandard.Click
   wait 100
   TabTypografisch.OK
   wDokSchreiben ( Normal$ + "Hallo" + Normal$ + " " )
   wait 100
   wDokSchreiben "<Home><Shift Right>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Vorn$ then Warnlog "Start character not " + Vorn$ + " but " + GetClipBoardtext
   wDokSchreiben "<End><Left><Shift Left>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Hinten$ then Warnlog "End character not " + Hinten$ + " but " + GetClipBoardtext
   wDokSchreiben "<Home><Shift End><Delete>"

   hCloseDocument
endcase
' *******************************************************************
testcase tToolsAutocorrectSingleQuotes
  Dim Vorn$ : Dim Hinten$ : Dim Normal$

  Printlog "- Tools / Autocorrect / Custom Quotes  ( Single Quotes )"
   if bAsianLan = True then
    printlog "- Not in Asian languages!"
    goto endsub
   endif
   Call hNewDocument
   if gPlatgroup = "os2" then
      Normal$ = Chr(39) : Vorn$ = Chr(39) : Hinten$ = Chr(39)
   else
      select case iSprache
          'case 01 : Normal$ = Chr(39) : Vorn$ = Chr(145) : Hinten$ = Chr(146)
          'case 03 : Normal$ = Chr(39) : Vorn$ = Chr(145) : Hinten$ = Chr(146)
          'case 07 : Warnlog "Test impossible. No quotes in russian!"
          '          hCloseDocument
          '          goto endsub
          'case 31 : Normal$ = Chr(39) : Vorn$ = Chr(145) : Hinten$ = Chr(146)
          'case 33 : Normal$ = Chr(39) : Vorn$ = Chr(145) : Hinten$ = Chr(146)
          'case 34 : Normal$ = Chr(39) : Vorn$ = Chr(145) : Hinten$ = Chr(146)
          'case 39 : Normal$ = Chr(39) : Vorn$ = Chr(145) : Hinten$ = Chr(146)
          'case 45 : Normal$ = Chr(39) : Vorn$ = Chr(146) : Hinten$ = Chr(146)
          'case 46 : Normal$ = Chr(39) : Vorn$ = Chr(39) : Hinten$ = Chr(39)
          'case 48 : Normal$ = Chr(39) : Vorn$ = Chr(130) : Hinten$ = Chr(145)
          'case 49 : Normal$ = Chr(39) : Vorn$ = Chr(130) : Hinten$ = Chr(145)

          case 01 : Normal$ = Chr(39) : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
          case 03 : Normal$ = Chr(39) : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
          case 07 : printlog "Test impossible. No quotes in russian!"
                    hCloseDocument
                    goto endsub
          case 31 : Normal$ = Chr(39) : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
          case 33 : Normal$ = Chr(39) : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
          case 34 : Normal$ = Chr(39) : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
          case 39 : Normal$ = Chr(39) : Vorn$ = Chr(8216) : Hinten$ = Chr(8217)
          case 45 : Normal$ = Chr(39) : Vorn$ = Chr(8217) : Hinten$ = Chr(8217)
          case 46 : Normal$ = Chr(39) : Vorn$ = Chr(39) : Hinten$ = Chr(39)
          case 48 : Normal$ = Chr(39) : Vorn$ = Chr(44) : Hinten$ = Chr(8216)
          case 49 : Normal$ = Chr(39) : Vorn$ = Chr(44) : Hinten$ = Chr(8216)

      end select
   end if

  Printlog "   - replace single quotes"
   OptionenAufrufen("TabTypografisch")
   EinfacheReplace.Check
   TabTypografisch.OK
   wDokSchreiben ( Normal$ + "Hallo" + Normal$ + " " )
   wait 100
   wDokSchreiben "<Home><Shift Right>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Vorn$ then Warnlog "Start character not " + Vorn$ + " but " + GetClipBoardtext + "Asc: " + ASC(GetClipBoardtext)
   wDokSchreiben "<End><Left><Shift Left>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Hinten$ then Warnlog "End character not " + Hinten$ + " but " + GetClipBoardtext + "Asc: " + ASC(GetClipBoardtext)
   wDokSchreiben "<Home><Shift End><Delete>"
   CheckUberpruefen ( Normal$ + "Hallo" + Normal$ + " " )

  Printlog "   - don't replace single quotes"
   OptionenAufrufen("TabTypografisch")
   EinfacheReplace.Uncheck
   TabTypografisch.OK
   wDokSchreiben ( Normal$ + "Hallo" + Normal$ + " " )
   wait 100
   wDokSchreiben "<Home><Shift Right>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Normal$ then Warnlog "Start character not " + Normal$ + " but " + GetClipBoardtext + "Asc: " + ASC(GetClipBoardtext)
   wDokSchreiben "<End><Left><Shift Left>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Normal$ then Warnlog "End character not " + Normal$ + " but " + GetClipBoardtext + "Asc: " + ASC(GetClipBoardtext)
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - replace character"
   ToolsAutoCorrect
   Kontext
   active.SetPage TabTypografisch
   Kontext "TabTypografisch"
   EinfacheReplace.Check
   EinfachWortAnfang.Click
   Kontext "Sonderzeichen"
   Schriftliste.TypeKeys "<PageUp><Home>"
   Schriftliste.TypeKeys "<Right>", 59   ' is [
   Schriftliste.TypeKeys "<Space>"
   Sonderzeichen.OK
   Kontext "TabTypografisch"
   EinfachWortEnde.Click
   Kontext "Sonderzeichen"
   Schriftliste.TypeKeys "<PageUp><Home>"
   Schriftliste.TypeKeys "<Right>", 61  ' is ]
   Schriftliste.TypeKeys "<Space>"
   Sonderzeichen.OK
   Kontext "TabTypografisch"
   TabTypografisch.OK
   wDokSchreiben ( Normal$ + "Hallo" + Normal$ + " " )
   wait 100
   wDokSchreiben "<Home><Shift Right>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Chr(91) then Warnlog "Start character not " + Chr(91) + " but " + GetClipBoardtext + "Asc: " + ASC(GetClipBoardtext)
   wDokSchreiben "<End><Left><Shift Left>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Chr(93) then Warnlog "End character not " + Chr(93) + " but " + GetClipBoardtext + "Asc: " + ASC(GetClipBoardtext)
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - back to default"
   ToolsAutoCorrect
   Kontext
   active.SetPage TabTypografisch
   Kontext "TabTypografisch"
   EinfacheReplace.Check
   EinfachStandard.Click
   wait 100
   TabTypografisch.OK
   wDokSchreiben ( Normal$ + "Hallo" + Normal$ + " " )
   wait 100
   wDokSchreiben "<Home><Shift Right>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Vorn$ then Warnlog "Start character not " + Vorn$ + " but " + chr$(GetClipBoardtext) + "Asc: " + ASC(GetClipBoardtext)
   wDokSchreiben "<End><Left><Shift Left>"
   Sleep 1
   EditCopy
   if GetClipboardText <> Hinten$ then Warnlog "End character not " + Hinten$ + " but " + GetClipBoardtext + "Asc: " + ASC(GetClipBoardtext)
   wDokSchreiben "<Home><Shift End><Delete>"

   ToolsAutoCorrect
   Kontext
   active.SetPage TabTypografisch
   Kontext "TabTypografisch"
   EinfacheReplace.UnCheck
   TabTypografisch.OK

   hCloseDocument
endcase

' *******************************************************************

testcase tToolsAutocorrectOptions
  Printlog "- Tools / Autocorrect / Options"
   Call hNewDocument

  Printlog "   - Automatisch whrend der Eingabe Replace ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   if NOT AutomatischWaehrendDerEingabeReplace.IsChecked then
      Warnlog "Per Default ist es nicht gecheckt"
   else
      AutomatischWaehrendDerEingabeReplace.Check
   end if
   TabOptionen.OK
   if iSprache = 33 then
      CheckUberpruefen "Aggio "
   else
      CheckUberpruefen "(C) "
   end if

  Printlog "   - Automatisch whrend der Eingabe Replace ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   AutomatischWaehrendDerEingabeReplace.UnCheck
   TabOptionen.OK
   UnCheckUeberpruefen "(C) "

  Printlog "   - Zwei Grossbuchstaben am Wortanfang korrigieren ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   AutomatischWaehrendDerEingabeReplace.Check
   if NOT ZweiGrossbuchstabenAmWortanfangKorrigieren.IsChecked then
      Warnlog "Per Default ist es nicht gecheckt"
   else
      ZweiGrossbuchstabenAmWortanfangKorrigieren.Check
   end if
   TabOptionen.OK
   CheckUberpruefen "ABer "

  Printlog "   - Zwei Grossbuchstaben am Wortanfang korrigieren ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   ZweiGrossbuchstabenAmWortanfangKorrigieren.UnCheck
   TabOptionen.OK
   UnCheckUeberpruefen "ABer "

  Printlog "   - Jeden Satz mit einem Grossbuchstaben beginnen ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   ZweiGrossbuchstabenAmWortanfangKorrigieren.Check
   if NOT JedenSatzMitEinemGrossbuchstabenBeginnen.IsChecked then
      Warnlog "Per Default ist es nicht gecheckt"
   else
      JedenSatzMitEinemGrossbuchstabenBeginnen.Check
   end if
   TabOptionen.OK
   CheckUberpruefen "Hallo. dies ist ein Satz. "

  Printlog "   - Jeden Satz mit einem Grossbuchstaben beginnen ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   JedenSatzMitEinemGrossbuchstabenBeginnen.UnCheck
   TabOptionen.OK
   UnCheckUeberpruefen "Hallo. dies ist ein Satz. "

  Printlog "   - Automatisch Fett und Unterstrichen ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   JedenSatzMitEinemGrossbuchstabenBeginnen.Check
   if NOT AutomatischFettUndUnterstrichen.IsChecked then
      Warnlog "Per Default ist es nicht gecheckt"
   else
      AutomatischFettUndUnterstrichen.Check
   end if
   TabOptionen.OK
   CheckUberpruefen "*Hallo* "
   CheckUberpruefen "_Hallo_ "

  Printlog "   - Automatisch Fett und Unterstrichen ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   AutomatischFettUndUnterstrichen.UnCheck
   TabOptionen.OK
   UnCheckUeberpruefen "_Hallo_ "
   UnCheckUeberpruefen "*Hallo* "

  Printlog "   - Doppelte Leerzeichen ignorieren ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   AutomatischFettUndUnterstrichen.Check
   if DoppelteLeerzeichenIgnorieren.IsChecked then
      Warnlog "Per Default ist es gecheckt"
   else
      DoppelteLeerzeichenIgnorieren.Check
   end if
   TabOptionen.OK
   CheckUberpruefen "Hallo  dies sind 2  Leerzeichen "

  Printlog "   - Doppelte Leerzeichen ignorieren ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   DoppelteLeerzeichenIgnorieren.UnCheck
   TabOptionen.OK
   UnCheckUeberpruefen "Hallo  dies sind 2  Leerzeichen "

  Printlog "   - 1/2 Replace ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   if NOT Gegen12Replace.IsChecked then
      Warnlog "Per Default ist nicht gecheckt"
   else
      Gegen12Replace.Check
   end if
   TabOptionen.OK
   CheckUberpruefen "1/2 "

  Printlog "   - 1/2 Replace ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   Gegen12Replace.UnCheck

 '** 1/2 aus der Ersetzungsliste lschen
   Kontext
   active.SetPage TabErsetzung
   Kontext "TabErsetzung"
  Dim i
   Liste.Typekeys "<Up>", 40
   for i=1 to 20
      if Kuerzel.GetText = "1/2" then
         i=1000
         wait 100
         Loeschen.Click
         Warnlog "Die 1/2-Umsetzung stand auch noch in der Replace-Liste"
      else
         Liste.Typekeys "<Down>"
      end if
   next i
   TabErsetzung.OK
   Sleep 1
   UnCheckUeberpruefen "1/2 "

  Printlog "   - 1st durch 1^st Replace ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   Gegen12Replace.Check
   if NOT Gegen1stReplace.IsChecked then
      Warnlog "Per Default ist nicht gecheckt"
   else
      Gegen1stReplace.Check
   end if
   TabOptionen.OK
   wDokSchreiben "1st "
   wait 100
   wDokSchreiben "<Home><Right><Right>"
   FormatCharacter
   Kontext
   Active.SetPage TabFontPosition
   Kontext "TabFontPosition"
   if NOT Super.IsChecked then Warnlog "Der Text wurde nicht verndert, er ist nicht hochgestellt"
   TabFontPosition.OK
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - 1st durch 1^st Replace ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   Gegen1stReplace.UnCheck
   TabOptionen.OK
   wDokSchreiben "1st "
   wait 100
   wDokSchreiben "<Home><Right><Right>"
   FormatCharacter
   Kontext
   Active.SetPage TabFontPosition
   Kontext "TabFontPosition"
    if Super.IsChecked then Warnlog "Der Text wurde verndert, er ist doch hochgestellt"
   TabFontEffects.OK
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - Gedankenstriche Replace ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   Gegen1stReplace.Check
   if NOT GedankenstricheReplace.IsChecked then
      Warnlog "Per Default ist nicht gecheckt"
   else
      GedankenstricheReplace.Check
   end if
   TabOptionen.OK
   CheckUberpruefen "Hallo -Herbert "

  Printlog "   - Gedankenstriche Replace ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   GedankenstricheReplace.UnCheck
   TabOptionen.OK
   UnCheckUeberpruefen "Hallo -Herbert "

  Printlog "   - URL erkennen ( gecheckt )"
   OptionenAufrufen("TabOptionen")
   GedankenstricheReplace.Check
   if NOT URLErkennen.IsChecked then
      Warnlog "Per Default ist nicht gecheckt"
   else
      URLErkennen.Check
   end if
   TabOptionen.OK
   wDokSchreiben "Es ist www.mopo.de "
   wait 100
   wDokSchreiben "<End><Left><Left>"
   FormatCharacter
   Kontext
   Active.SetPage TabFontEffects
   Kontext "TabFontEffects"
   if Underline.GetSelIndex = 0 then Warnlog "Text has not been changed. Text is underlined!"
   TabFontEffects.OK
   wDokSchreiben "<Home><Shift End><Delete>"

  Printlog "   - URL erkennen ( nicht gecheckt )"
   OptionenAufrufen("TabOptionen")
   URLErkennen.UnCheck
   TabOptionen.OK
   wDokSchreiben "Es ist www.mopo.de "
   wait 100
   wDokSchreiben "<End><Left><Left>"
   FormatCharacter
   Kontext
   Active.SetPage TabFontEffects
   Kontext "TabFontEffects"
   if Underline.GetSelIndex > 0 then Warnlog "Text has been changed. Text is not underlined!"
   TabFontEffects.OK
   wDokSchreiben "<Home><Shift End><Delete>"

   OptionenAufrufen("TabOptionen")
   URLErkennen.Check
   TabOptionen.OK

   hCloseDocument
endcase

' *******************************************************************

testcase tToolsAutocorrectWordCompletion
  Dim UeberEnde as integer : Dim UeberEingabe as integer : Dim UeberLeer as integer : Dim UeberRechts as integer
  Dim i as integer
   UeberEnde = 1
   UeberEingabe = 2
   UeberLeer = 3
   UeberRechts = 4

  printlog "- Test word completion"
  hNewDocument
  ToolsAutoCorrect
   Kontext
   active.SetPage TabWortergaenzung
   Kontext "TabWortergaenzung"
   if GesammelteWorte.GetItemCount > 0 then
    for i= 1 to GesammelteWorte.GetItemCount
     GesammelteWorte.Select 1
     if EintragLoeschen.IsEnabled then
      EintragLoeschen.Click
     else
      i = GesammelteWorte.GetItemCount + 1
     endif
    next i
   endif

  printlog "-  don't collect suggestions"
   WoerterErgaenzen.Check
   VorschlaegeSammeln.UnCheck
   MinWortlaenge.Settext 5
   TabWortergaenzung.ok
   Call wBlindtextEinfuegen

   ToolsAutoCorrect
   Kontext
   active.SetPage TabWortergaenzung
   Kontext "TabWortergaenzung"
   if VorschlaegeSammeln.IsChecked then Warnlog "Checkbox 'Collect suggestions' is checked!"
   if GesammelteWorte.GetItemCount >= 1 then
    Warnlog "Though checkbox is not checked, words have been collected!"
    GesammelteWorte.Select 1
    GesammelteWorte.TypeKeys "<Shift End>"
    if EintragLoeschen.IsEnabled then EintragLoeschen.Click
   endif
   VorschlaegeSammeln.Check
   TabWortergaenzung.Ok

  printlog "-  collect suggestions"
   Call wBlindtextEinfuegen
   Sleep 5
   ToolsAutoCorrect
   Kontext
   active.SetPage TabWortergaenzung
   Kontext "TabWortergaenzung"
   if GesammelteWorte.GetItemCount = 0 then Warnlog "Though checkbox has been checked words have not been collected !"

   MinWortlaenge.Settext 5
   AnnehmenMit.Select UeberEnde
   TabWortergaenzung.Ok
   Wait 500
   EditSelectAll
   Call wDokSchreiben "<Delete>"

  printlog "-  completion with 'End'"
   Call wDokSchreiben "Dies ist ein Test der automatischen Worterkennung !<Return>"
   WortErgaenzen("<End>")

  printlog "-  Completion with 'Enter'"
   ToolsAutoCorrect
   Kontext
   active.SetPage TabWortergaenzung
   Kontext "TabWortergaenzung"

   AnnehmenMit.Select UeberEingabe
   TabWortergaenzung.Ok
   Call WortErgaenzen("<Return>")

  printlog "-  Completion with 'Space'"
   ToolsAutoCorrect
   Kontext
   active.SetPage TabWortergaenzung
   Kontext "TabWortergaenzung"

   AnnehmenMit.Select UeberLeer
   TabWortergaenzung.Ok
   Call WortErgaenzen("<Space>")

  printlog "-  Completion with 'Cursor right'"
   ToolsAutoCorrect
   Kontext
   active.SetPage TabWortergaenzung
   Kontext "TabWortergaenzung"

   AnnehmenMit.Select UeberRechts
   TabWortergaenzung.Ok
   Call WortErgaenzen("<Right>")

 Call hCloseDocument
endcase
