'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_files.inc,v $
'*
'*  $Revision: 1.36 $
'*
'*  last change: $Author: msc $ $Date: 2005/11/10 12:23:28 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : thorsten.bosbach@sun.com
'*
'* short description : global routines around the loading and saving of documents
'*
'******************************************************************
' #1 hDateiOeffnen
' #1 hDateiOeffnenMitFilter
' #1 hDateiOeffnenMitAnderemFilter
' #1 hASCIIDateiOeffnen
' #1 hSpeichern
' #1 hSpeichernUnter
' #1 hSpeichernUnterKill
' #1 hSpeichernUnterMitFilter
' #1 hSpeichernUnterMitFilterKill
' #1 hGrafikEinfuegen
' #1 hGrafikVerknuepftEinfuegen
' #1 IsItSaved
' #1 IsItLoaded
' #1 hIsNamedDocLoaded
' #1 IsImageLoaded
' #1 hGetUsedFilter
' #1 hFileExport
' #1 hExportAsPDFmulti
' #1 hFileOpenWithFilter
' #1 hDrucken
' #1 hDokumentDrucken
' #1 hIsWebPageLoaded
' #1 hSys2IntDlg
' #1 hInt2SysDlg
' #1 hhSysToInt
'\**********************************************************************************

function hDateiOeffnen ( DocName$, optional Verknuepft as Boolean ) as boolean
'/// All (office) documents will be opened without special filter settings.
'///+ As an optional parameter you can set how to handle Yes/No queries.
'/// <u>OPTIONAL</u>: TRUE or FALSE
'/// <u>DEFAULT</u>: Handle yes/no queries with <b>yes</b>
'/// <u>Input</u>: Filename with complete path [optional parameter as BOOLEAN]
'/// <u>Return</u>: TRUE or FALSE if the file could be loaded or not.

   Dim DieDatei as String
   Dim Dummy as Boolean
   Dim isMis as Boolean
   Dim i as integer

   DieDatei = ConvertPath ( DocName$ )

   isMis = FALSE

   Dummy = TRUE
   if hFileExists ( DieDatei ) = FALSE then
      Warnlog "t_files::hDateiOeffnen(): '" + DieDatei + "' does not exists!"
      Dummy = FALSE
   else
      if IsMissing ( Verknuepft ) = TRUE then
         Verknuepft = FALSE
         isMis = TRUE
      end if

      FileOpen
      sleep (1)
      Kontext "OeffnenDlg"
      Dateiname.SetText DieDatei
      sleep (3)
      Oeffnen.Click
      sleep (3)

     'Only the Currency sample needs that loop
     for i = 1 to 2
      Kontext "Active"
      if Active.Exists(3) then
         if isMis = FALSE then
            printlog "t_files::hDateiOeffnen(): " + Active.GetText
         else
            Warnlog "t_files::hDateiOeffnen(): " + Active.GetText
         end if
         try
            Active.OK
         catch
            if Verknuepft = FALSE then
               Active.No              ' e.g. Links WON'T be updated
            else
               Active.Yes             ' e.g. Links WILL be updated
            end if
         endcatch
         Kontext "OeffnenDlg"
         if OeffnenDlg.Exists(1) then
            OeffnenDlg.Cancel
            Dummy = FALSE
            Warnlog "t_files::hDateiOeffnen(): The File-Open-Dialog is open!"
         end if
      end if
     next i
   end if

   if Dummy = TRUE then
      hDateiOeffnen = IsItLoaded
   else
      hDateiOeffnen = FALSE
   end if
end function

'-------------------------------------------------------------------------

function hDateiOeffnenMitFilter ( DocName$, Filter$, optional Verknuepft as Boolean  ) as boolean
'/// hDateiOeffnenMitFilter hFileOpenWithFilter
'/// All (office) documents will be opened WITH special filter setting.
'/// As an <b>OPTIONAL</b> parameter you can set how to handle Yes/No queries.
'///+ <ul><li>optional parameter is TRUE or FALSE</li>
'///+ <li><b>default</b> is to handle yes/no queries with <b>yes</b></li>
'/// <u>Input</u>: Filename with complete path [optional parameter as BOOLEAN]
'/// <u>Return</u>: TRUE or FALSE if the file could be loaded or not.</ul>

   Dim DieDatei as String
   Dim Dummy as Boolean

   '/// use 'ConvertPath' on the FileName ///'
   DieDatei = ConvertPath ( DocName$ )
   hDateiOeffnenMitFilter = FALSE

   '/// check if file exists ///'
   Dummy = TRUE
   if hFileExists ( DieDatei ) = FALSE then
      Warnlog "hDateiOeffnenMitFilter(): '" + DieDatei + "' does not exists!"
      Dummy = FALSE
   else
      if IsMissing ( Verknuepft ) = TRUE then
         Verknuepft = TRUE
      end if

      '/// call file->open and make the entries; click button 'open' ///'
      FileOpen
      Kontext "OeffnenDlg"
      DateiTyp.Select Filter$
      Sleep (1)
      Dateiname.SetText DieDatei
      Sleep (3)
      Oeffnen.Click
      Sleep (1)

      '/// if dialog 'AsciiFilterOptionen' comes up, say OK ///'
      Kontext "AsciiFilterOptionen"
      If AsciiFilterOptionen.Exists(3) then
         if Verknuepft = FALSE then
            printlog "hDateiOeffnenMitFilter ():  ASCII filter dialog came up ! "
         else
            Warnlog  "hDateiOeffnenMitFilter ():  ASCII filter dialog came up ! "
         end if
         AsciiFilterOptionen.OK
         sleep(5)
         hDateiOeffnenMitFilter = TRUE
      else
         Kontext "Filterauswahl"
         If Filterauswahl.Exists then
            Filterauswahl.Cancel
            warnlog "Filterselection-box visible. BUG!"
         End If
      End If

      '/// print every active, that comes up as printlog and try to say OK/YES ///'
      '///+ exeption to the rule: if OK fails AND if 'optional UpdateLinks' TRUE say YES, else NO ///'
      Kontext "Active"
      if Active.Exists(2) then
         if Verknuepft = FALSE then
            printlog "hDateiOeffnenMitFilter (): " + Active.GetText
         else
            Warnlog "hDateiOeffnenMitFilter (): " + Active.GetText
         end if
         try
            Active.OK
         catch
            if Verknuepft = FALSE then
               Active.No              ' eg. Links won't be updated
            else
               Active.Yes             ' eg. Links will be updated
            end if
         endcatch
         Kontext "OeffnenDlg"
         if OeffnenDlg.Exists(1) then
            OeffnenDlg.Cancel
            Dummy = FALSE
            Warnlog "hDateiOeffnenMitFilter (): The File-Open-Dialog is open!"
         end if
      end if
   end if

   if Dummy = TRUE then
      hDateiOeffnenMitFilter = IsItLoaded
   else
      hDateiOeffnenMitFilter = FALSE
   end if
end function

'-------------------------------------------------------------------------

function hDateiOeffnenMitAnderemFilter ( NamederDatei$, AndererFilter$, optional Verknuepft as Boolean ) as boolean
'/// hDateiOeffnenMitAnderemFilter hFileOpenWithDifferentFilter
'/// All (office) documents will be opened WITH special filter setting.
'/// As an <b>OPTIONAL</b> parameter you can set how to handle Yes/No queries.
'///+ <ul><li>optional parameter is TRUE or FALSE</li>
'///+ <li><b>default</b> is to handle yes/no queries with <b>yes</b></li>
'///+ <li>if the Filter-Selection-Box comes up, the filter is selected a second time
'/// <u>Input</u>: Filename with complete path; File Type; [optional parameter as BOOLEAN]
'/// <u>Return</u>: TRUE or FALSE if the file could be loaded or not.</ul>

   Dim DieDatei as String
   Dim Dummy as Boolean
   Dim vOneBefore as integer

   DieDatei = ConvertPath ( NamederDatei )
   Dummy = TRUE
   if hFileExists ( DieDatei ) = FALSE then
      Warnlog "hDateiOeffnenMitAnderemFilter(): '"+ DieDatei + " does not exist!"
      Dummy = FALSE
   else
      if IsMissing ( Verknuepft ) = TRUE then
         Verknuepft = FALSE
      end if

      FileOpen
      Kontext "OeffnenDlg"
      Sleep (1)
      DateiTyp.Select AndererFilter$
      Sleep (1)
      Dateiname.SetText DieDatei
      Sleep (3)
      Oeffnen.Click
      Sleep (1)

      Kontext "Filterauswahl"
      if Filterauswahl.Exists then
         Filter.Select ( AndererFilter$ )
         Filterauswahl.OK
         Warnlog "Filter can't be find, the filter-dialog is now open and the filter must be selected again! BUG!!!"
      end if

      Kontext "Active"
      if Active.Exists(2) then
         if Verknuepft = FALSE then
            printlog "hDateiOeffnenMitAnderemFilter(): " + Active.GetText
         else
            Warnlog "hDateiOeffnenMitAnderemFilter(): " + Active.GetText
         end if
         try
            Active.OK
         catch
            if Verknuepft = FALSE then
               Active.No              ' eg. Links won't be updated
            else
               Active.Yes             ' eg. Links will be updated
            end if
         endcatch
         Kontext "OeffnenDlg"
         if OeffnenDlg.Exists(1) then
            OeffnenDlg.Cancel
            Dummy = FALSE
            Warnlog "hDateiOeffnenMitAnderemFilter(): The File-Open-Dialog is open!"
         end if
      end if
   end if

  if Dummy = TRUE then
     hDateiOeffnenMitAnderemFilter = IsItLoaded
  else
     hDateiOeffnenMitAnderemFilter = FALSE
  end if
end function

'-------------------------------------------------------------------------

function hSpeichern as boolean
'/// hSpeichern hSave
'/// The document just got saved; no checks for any messageboxes! ///'
'/// <u>Input</u>: -
'/// <u>Return</u>: TRUE.
   Dim i%

   FileSave
   Sleep (2)
   hSpeichern = IsItSaved
end function

'-------------------------------------------------------------------------

function hSpeichernUnter ( DieDatei as String ) as boolean
'/// hSpeichernUnter hSaveAs
'/// The current document will be saved.
'///+ <ul><li>without any modification to the default Filtersettings</li>
'///+ <li>if file exists, a warning will be displayed and the file will be replaced</li>
'///+ <li>'automatic file name extension' will be disabled</li>
'/// <u>Input</u>: Filename with complete path
'/// <u>Return</u>: TRUE or FALSE if the file could be saved or not.</ul>

   Dim DerName$
   Dim DerText as String
   Dim bAlienNotAllowed as boolean
   Dim sFiltername as String

   DerName$ = ConvertPath ( DieDatei )

   FileSaveAs
   Kontext "SpeichernDlg"
   Sleep (1)

   If AutomatischeDateinamenserweiterung.IsChecked then AutomatischeDateinamenserweiterung.Uncheck
   Sleep (1)
   Dateiname.SetText DerName$

   Sleep (2)
   Speichern.Click
   Sleep (1)
   Kontext "Active"
   if Active.Exists(2) then
      DerText = Active.GetText
      try
         Warnlog DerText & " (overwrite)"
         Active.Yes
      catch
         Warnlog DerText
         Active.OK
         Kontext "SpeichernDlg"
         if SpeichernDlg.Exists(1) then SpeichernDlg.Cancel
      endcatch
   end if
   Kontext "AlienWarning"
   if AlienWarning.Exists(2) then
      ' Verifying the default filter with the used filter and if it is the same and
      ' the Alien Warning dialog occured return a warning.
      select case lcase(gApplication)
             case "writer",  "textdokument"                  :   if sFilterName = gWriterFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "calc", "tabellendokument"                 :   if sFilterName = gCalcFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "impress", "praesentation"                 :   if sFilterName = gImpressFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "draw", "zeichnung"                        :   if sFilterName = gDrawFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "masterdoc", "globaldokument", "globaldoc" :   if sFilterName = gMasterDocFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "math", "formel"                           :   if sFilterName = gMathFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "html", "htmldokument"                     :   if sFilterName = gHTMLFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
      end select

      if bAlienNotAllowed = TRUE then
         warnlog "Alien Warning-dialog occured but it was the default filter of the application!"
      end if
      AlienWarning.OK
   end if
   sleep(2)
   if FileExists(DerName$) then
        hSpeichernUnter = true
   else
        hSpeichernUnter = false
   endif
end function

'-------------------------------------------------------------------------

function hSpeichernUnterKill ( DieDatei as String ) as Boolean
'/// hSpeichernUnterKill hSaveAsKill
'/// The current document will be saved.
'///+ <ul><li>without any modification to the default Filtersettings</li>
'///+ <li>if file exists, the file will be deleted and then saved</li>
'///+ <li>'automatic file name extension' will be disabled</li></ul>
   Dim DerName$ : Dim DerText as String
   Dim sFiltername as String
   dim bFileSaved as boolean
   Dim bAlienNotAllowed as boolean

   DerName$ = ConvertPath ( DieDatei )

   if hFileExists ( DerName$ ) = TRUE then app.kill ( DerName$ )
   if FileExists (DerName$) then
        warnlog "File could not get deleted in function 'hSpeichernUnterKill': '" + DerName$ + "'"
        bFileSaved = false
   else
        bFileSaved = true
   endif
   Sleep (1)
   FileSaveAs
   Kontext "SpeichernDlg"
   Sleep (1)

   If AutomatischeDateinamenserweiterung.IsChecked then AutomatischeDateinamenserweiterung.Uncheck
   Sleep (1)
   Dateiname.SetText DerName$
   Sleep (2)
   Speichern.Click
   Sleep (1)
   Kontext "Active"
   if Active.Exists(2) then
      DerText = Active.GetText
      try
         Warnlog DerText & " (overwrite)"
         Active.Yes
      catch
         Warnlog DerText
         Active.OK
         Kontext "SpeichernDlg"
         if SpeichernDlg.Exists(1) then SpeichernDlg.Cancel
      endcatch
   end if
   Kontext "AlienWarning"
   if AlienWarning.Exists(2) then
      ' Verifying the default filter with the used filter and if it is the same and
      ' the Alien Warning dialog occured return a warning.
      select case lcase(gApplication)
             case "writer",  "textdokument"                  :   if sFilterName = gWriterFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "calc", "tabellendokument"                 :   if sFilterName = gCalcFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "impress", "praesentation"                 :   if sFilterName = gImpressFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "draw", "zeichnung"                        :   if sFilterName = gDrawFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "masterdoc", "globaldokument", "globaldoc" :   if sFilterName = gMasterDocFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "math", "formel"                           :   if sFilterName = gMathFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "html", "htmldokument"                     :   if sFilterName = gHTMLFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
         end select

         if bAlienNotAllowed = TRUE then
            warnlog "Alien Warning-dialog occured but it was the default filter of the application!"
         end if
         AlienWarning.OK
     end if
     sleep(2)
   if (FileExists(DerName$) AND bFileSaved) then
        bFileSaved = true
   else
        bFileSaved = false
   endif
   hSpeichernUnterKill = bFileSaved
end function

'-------------------------------------------------------------------------

function hSpeichernUnterMitFilter ( DieDatei as String, Filter$, optional bAutoFileExtension as boolean ) as boolean
'/// hSpeichernUnterMitFilter hSaveAsWithFilter
'/// The current document will be saved with a selected filter.
'///+ <ul><li>without any modification to the default Filtersettings</li>
'///+ <li>if file exists, a warning will be displayed and the file will be replaced</li>
'///+ <li>'automatic file name extension' is <b>OPTIONAL</b> selectable</li>
'///+ <ul><li>optional parameter is TRUE or FALSE</li>
'///+ <li><b>default</b> is to UNcheck the 'automatic file name extension' -> FALSE</li>
'/// <u>Input</u>: Filename with complete path; File Type; [optional parameter as BOOLEAN]
'/// <u>Return</u>: TRUE or FALSE if the file could be saved or not.</ul></ul>
   Dim DerName$ : Dim DerText as String
   Dim bAlienNotAllowed as boolean
   Dim sFiltername as String
   dim bFileSaved as boolean

   DerName$ = ConvertPath ( DieDatei )

   sFilterName = Filter$

   FileSaveAs
   Kontext "SpeichernDlg"
   Sleep (1)
   if IsMissing(bAutoFileExtension) then ' TBO 04/01/2002
      If AutomatischeDateinamenserweiterung.IsChecked then AutomatischeDateinamenserweiterung.Uncheck
   else
      if (bAutoFileExtension) then
         AutomatischeDateinamenserweiterung.Check
      else
         AutomatischeDateinamenserweiterung.UnCheck
      endif
   end if
   DateiTyp.Select Filter$
   Sleep (1)
   Dateiname.SetText DerName$
   Sleep (1)
   Speichern.Click
   Sleep (1)
   Kontext "AlienWarning"
   if AlienWarning.Exists(2) then
      ' Verifying the default filter with the used filter and if it is the same and
      ' the Alien Warning dialog occured return a warning.
      select case lcase(gApplication)
             case "writer",  "textdokument"                  :   if sFilterName = gWriterFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "calc", "tabellendokument"                 :   if sFilterName = gCalcFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "impress", "praesentation"                 :   if sFilterName = gImpressFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "draw", "zeichnung"                        :   if sFilterName = gDrawFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "masterdoc", "globaldokument", "globaldoc" :   if sFilterName = gMasterDocFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "math", "formel"                           :   if sFilterName = gMathFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
             case "html", "htmldokument"                     :   if sFilterName = gHTMLFilter then
                                                                    bAlienNotAllowed = TRUE
                                                                 end if
         end select

         if bAlienNotAllowed = TRUE then
            warnlog "Alien Warning-dialog occured but it was the default filter of the application!"
         end if
         AlienWarning.OK
     end if
     sleep(2)
     'Calling function IsItSaved in this library which is using 'IsDocSaving'-slot.
     if IsItSaved = TRUE then
        bFileSaved = TRUE
     end if
   Kontext "Active"
   if Active.Exists (2) then
      DerText = Active.GetText
      try
         Warnlog DerText & " (overwrite)"
         Active.Yes
      catch
         Warnlog DerText
         Active.OK
         Kontext "SpeichernDlg"
         if SpeichernDlg.Exists(1) then SpeichernDlg.Cancel
      endcatch
   end if
   if FileExists(DerName$) then
        hSpeichernUnterMitFilter = true
   else
        hSpeichernUnterMitFilter = false
   endif
end function

'-------------------------------------------------------------------------

function hSpeichernUnterMitFilterKill (sFileName as String, sFilterName, optional bAutoFileExtension as boolean) as boolean
'///+ Officedocument will be saved with named filter.
'///+ If the same file(name) exists it will be overwritten.
'///+ &quot;automated extension&quot; will be set off.
'///+ <u>OPTIONAL as boolean</u>: A Parameter which enables the &quot;automated extension&quot;.

    Dim sDerName as string
    Dim sDerText as string
    Dim ApplicatStrg as string
    Dim bFileSaved as boolean
    Dim bAlienNotAllowed as boolean

    sDerName = ConvertPath (sFileName)

    'Setting return value and temporary variable of return value to FALSE
    bFileSaved = FALSE
    hSpeichernUnterMitFilterKill = FALSE

    if hFileExists (sDerName) = TRUE then
        try
            'Deleting a same named file if it exists.
            app.kill (sDerName)
        catch
            Exceptlog
        endcatch
    end if

    if FileExists(sDerName) then
        'Warning if the file still exist.
        warnlog "global::tools::inc::t_files.inc:hSpeichernUnterMitFilterKill: Existing same named file (" & sDerName & ") could not be deleted."
        warnlog "global::tools::inc::t_files.inc:hSpeichernUnterMitFilterKill: Exiting function without saving the new file."
        'Setting the return of the function to FALSE
        bFileSaved = false
        exit function
    end if

    sleep (1)
    'Calling the slot File -> Save
    FileSaveAs
    Kontext "SpeichernDlg"
    if SpeichernDlg.Exists(2) then
        'Asking for the optional BOOLEAN parameter (automatic file extension)
        if IsMissing(bAutoFileExtension) then
            if AutomatischeDateinamenserweiterung.IsChecked then
                AutomatischeDateinamenserweiterung.Uncheck
            end if
        else
            AutomatischeDateinamenserweiterung.Check
        end if
        DateiTyp.Select sFilterName
        sleep (3)
        DateiName.SetText sDerName
        sleep (3)
        'Saving the document
        Speichern.Click
        sleep (1)
        Kontext
        if Active.Exists(2) then
            if Active.GetRT = 304 then
                sDerText = Active.GetText
                warnlog "global::tools::inc::t_files.inc:hSpeichernUnterMitFilterKill: Exiting function.:'" + sDerText + "'"
                Active.OK
                Kontext "SpeichernDlg"
                if SpeichernDlg.Exists(1) then
                    SpeichernDlg.Cancel
                end if
                bFileSaved = FALSE
                Exit function
            end if
        end if
        Kontext "AlienWarning"
        if AlienWarning.Exists(2) then
            ' Verifying the default filter with the used filter and if it is the same and
            ' the Alien Warning dialog occured return a warning.
            select case lcase(gApplication)
                case "writer",  "textdokument"                  :   if sFilterName = gWriterFilter then
                                                                        bAlienNotAllowed = TRUE
                                                                    end if
                case "calc", "tabellendokument"                 :   if sFilterName = gCalcFilter then
                                                                        bAlienNotAllowed = TRUE
                                                                    end if
                case "impress", "praesentation"                 :   if sFilterName = gImpressFilter then
                                                                        bAlienNotAllowed = TRUE
                                                                    end if
                case "draw", "zeichnung"                        :   if sFilterName = gDrawFilter then
                                                                        bAlienNotAllowed = TRUE
                                                                    end if
                case "masterdoc", "globaldokument", "globaldoc" :   if sFilterName = gMasterDocFilter then
                                                                        bAlienNotAllowed = TRUE
                                                                    end if
                case "math", "formel"                           :   if sFilterName = gMathFilter then
                                                                        bAlienNotAllowed = TRUE
                                                                    end if
                case "html", "htmldokument"                     :   if sFilterName = gHTMLFilter then
                                                                        bAlienNotAllowed = TRUE
                                                                    end if
            end select

            if bAlienNotAllowed = TRUE then
                warnlog "Alien Warning-dialog occured but it was the default filter of the application!"
            end if
            AlienWarning.OK
        end if
        sleep(2)
        'Calling function IsItSaved in this library which is using 'IsDocSaving'-slot.
        if IsItSaved = TRUE then
            bFileSaved = TRUE
        end if
        ' If the automated file extension feature has been used
        ' the input variable 'sFileName' -> 'sDerName' does not match with the real
        ' saved file name (extension is missing!). The file exists and file length verification
        ' are disabled in that case.

        if IsMissing(bAutoFileExtension) then
            'Asking if the file exists AND if the saving process has been executed (not stoped by an error message).
            if FileExists(sDerName) AND bFileSaved = TRUE then
                'Asking if the file lenth is greater than 0
                if FileLen(sDerName) > 0 then
                    'Then returning TRUE for bFileSaved (which will be put into the return value of the function)
                    bFileSaved = true
                else
                    bFileSaved = false
                end if
            else
                'If file does not exist or the saving operation has been canceld the function
                'will return FALSE.
                bFileSaved = false
            end if
        end if
    else
        warnlog "global::tools::inc::t_files.inc:hSpeichernUnterMitFilterKill: 'Save'-dialog was not visible."
        warnlog "global::tools::inc::t_files.inc:hSpeichernUnterMitFilterKill: Document has not been saved!"
        bFileSaved = false
    end if
    'Giving the value of the bFileSaved variable into the return value of the function.
    hSpeichernUnterMitFilterKill = bFileSaved
end function

'-------------------------------------------------------------------------
function hGrafikEinfuegen  ( Grafik$ ) as Boolean
'/// hGrafikEinfuegen hGraphicInsert
'/// A graphic will be inserted (not linked).
'/// <u>Input</u>: Filename with complete path
'/// <u>Return</u>: TRUE or FALSE if the graphic could be inserted or not.

  Dim DieDatei as String
  Dim IsActive as Boolean

   DieDatei = ConvertPath ( Grafik$ )

   InsertGraphicsFromFile
   Sleep (1)
   Kontext
    If Active.Exists(1) then
      warnlog "  Hinweis: " & Active.GetText
      Active.Ok
    End If
   Kontext "GrafikEinfuegenDlg"
   wait 500

   Vorschau.Uncheck
   if gApplication <> "HTMLDOKUMENT" AND gApplication <> "HTML" then
      Verknuepfen.UnCheck
   end if

   Dateiname.SetText DieDatei
   DateiTyp.Select 1                               ' set the filter to 'all formats'
   Sleep (1)
   Oeffnen.Click
   Sleep (1)

   Kontext "Active"
   if Active.Exists(2) then
      Warnlog "  Hinweis: " & Active.GetText
      try
         Active.OK
      catch
         try
        Active.Yes
     catch
        Active.Cancel
     endcatch
      endcatch
      Kontext "GrafikEinfuegenDlg"
     if GrafikEinfuegenDlg.Exists then GrafikEinfuegenDlg.Cancel
   else
    hGrafikEinfuegen = IsImageLoaded
   end if
end function

'-------------------------------------------------------------------------

function hGrafikVerknuepftEinfuegen  ( Grafik$ ) as Boolean
'/// hGrafikEinfuegenEinfuegen hGraphicInsertLinked
'/// A graphic will be inserted <b>LINKED</b>
'/// <u>Input</u>: Filename with complete path
'/// <u>Return</u>: TRUE or FALSE if the graphic could be inserted or not.
  Dim DieDatei as String
  Dim IsActive as Boolean

   DieDatei = ConvertPath ( Grafik$ )

   InsertGraphicsFromFile
   Sleep (1)
   Kontext
    If Active.Exists(1) then
      warnlog "  Hinweis: " & Active.GetText
      Active.Ok
    End If
   Kontext "GrafikEinfuegenDlg"
   wait 500

   Vorschau.UnCheck
   if gApplication <> "HTMLDOKUMENT" AND gApplication <> "HTML" then
      Verknuepfen.Check
   end if

   Dateiname.SetText DieDatei
   DateiTyp.Select 1                               ' set the filter to 'all formats'
   Sleep (1)
   Oeffnen.Click
   Sleep (1)

   Kontext "Active"
   if Active.Exists(2) then
      Warnlog "  Hinweis: " + Active.GetText
      try
         Active.OK
      catch
         Active.Yes
      endcatch
      Kontext "GrafikEinfuegenDlg"
     if GrafikEinfuegenDlg.Exists then GrafikEinfuegenDlg.Cancel
   else
    hGrafikVerknuepftEinfuegen = IsImageLoaded
   end if
end function

'-------------------------------------------------------------------------

sub hDrucken ()
'/// hDrucken hPrint
'/// The current document will be send to the default printer; no checks for any messageboxes!

   kontext "funktionsleiste"
   Drucken.Click
   Sleep (4)
end sub

'-------------------------------------------------------------------------

sub hDokumentDrucken ( Printer$ )
'/// hDrucken hPrint
'/// The current document will be send to the printer; no checks for any messageboxes!
'/// <u>Input</u>: Printername; if the printer doesn't exist, the default is used
   FilePrint
   Kontext "DruckenDlg"
   try
      Drucker.Select Printer$
   catch
      warnlog "Der Drucker " +Printer$+ " existiert nicht, es wird der Standdrucker verwendet!"
   endcatch
   DruckenDlg.OK
   Sleep (4)
end sub

'-------------------------------------------------------------------------

function IsItSaved as boolean
'/// IsItSaved
'/// Wait until document is saved.
    Dim iLoop as integer

    IsItSaved = FALSE
    sleep(3)
    for iLoop =1 to 20
        try
            'Calling slot 'IsDocSaving'
            IsItSaved = IsDocSaving
        catch
            IsItSaved = FALSE
        endcatch

        if IsItSaved = TRUE then
            exit for
        end if
        sleep(1)
    next iLoop
    sleep(2)
end function

'-------------------------------------------------------------------------

function IsItLoaded as boolean
'/// IsItLoaded
'/// Wait until document is loaded
    Dim iLoop as integer

    IsItLoaded = FALSE
    sleep(3)
    for iLoop =1 to 20
        try
            'Calling slot 'IsDocLoading'
            IsItLoaded = IsDocLoading
        catch
            IsItLoaded = FALSE
        endcatch

        if IsItLoaded = TRUE then
            exit for
        end if
        sleep(1)
    next iLoop
    sleep(2)
end function

'-------------------------------------------------------------------------

function hIsNamedDocLoaded (ShouldFile as String, optional bSilent as boolean) as Boolean
    dim sTemp as string
    '/// hIsNamedDocLoaded ///'
    '/// !fails always if a template is loaded, because you have to set a new filename in the save-dialog -> not usable in this case ! ///'
    '/// Input: name of loaded file; Output: True/False ///'
    '///+' if a doc got loaded, the filename in a 'SaveAs' Dlg is different from "" ///
    '///+' usually the file name of the loaded document with an changed extension chosen from SO ///

    if (isMissing(bSilent)) then
        bSilent = False
    endif

    hIsNamedDocLoaded  = False      ' Let's  start WorstCase :-(
    FileSaveAs
    Kontext "SpeichernDlg"
    If DateiOhneExt(DateiExtract(Dateiname.GetSelText)) = DateiOhneExt(DateiExtract(ShouldFile)) Then
        hIsNamedDocLoaded = True
    Else
        sTemp = left(right(ShouldFile,2),1) ' get the 2nd last character ' vor;dot;sti;pot;std
        if (((sTemp="o") or (sTemp="t")) and (left(right(ShouldFile,4),1)=".")) then
            hIsNamedDocLoaded = True ' exception! for linux! and MS-Office Templates
        else
            if ((Dateiname.GetSeltext = "") and not bSilent) then Warnlog "Default filename is empty!"+left(right(ShouldFile,3),1)
        endif
    End If
    SpeichernDlg.Cancel
end function

'-------------------------------------------------------------------------

function IsImageLoaded
'/// IsImageLoaded
'/// Wait until images in document are loaded
  Dim i% : Dim Herbert as Boolean

   Sleep 3
   for i%=1 to 20
      try
         Herbert = IsDocImageLoading
      catch
         Herbert = FALSE
      endcatch
      if Herbert = TRUE then i%=100
      Sleep (1)
   next i%
   if i<100 then
      IsImageLoaded = FALSE
   else
      IsImageLoaded = TRUE
   end if
end function

'-------------------------------------------------------------------------

sub hIsWebPageLoaded as boolean
'Author: Joerg Sievers
'/// If a document in StarOffice Writer is loaded all 9 items in the
'///+ statusbar are visible otherwise not.
'///+ This sub checks the state of these items.
 Dim i as integer
 Dim iGibtdenStatusraus as integer
 printlog "- global::tools::inc::tfiles.inc::hIsWebPageLoaded"
  hIsWebPageLoaded = FALSE
    for i = 1 to 20
        Kontext "DocumentWriter"
        if DocumentWriter.Exists(3) then
            'Count the items on the status bar.
            iGibtdenStatusraus = DocumentWriter.StatusGetItemCount
            'There are nine items on the status bar if the web page has been loaded.
            if iGibtdenStatusraus = 9 then
                hIsWebPageLoaded = TRUE
                exit for
            end If
        end if
        sleep(3)
    next i
end sub

'-------------------------------------------------------------------------

sub hSys2IntDlg
'/// Change from system to StarOffice-internal file-dialog (only for Win32)
   if gPlatgroup <> "unx" then Call hhSysToInt ( TRUE )
   gUseSysDlg = FALSE
end sub

'-------------------------------------------------------------------------

sub hInt2SysDlg
'/// Change from StarOffice-internal to system file-dialog (only for Win32)
   if gPlatgroup <> "unx" then Call hhSysToInt ( FALSE )
   gUseSysDlg = TRUE
end sub

'-------------------------------------------------------------------------

sub hhSysToInt ( bwhats as Boolean )
'/// subroutine for <i>hSys2IntDlg</i> and </i>hInt2SysDlg</i>
   ToolsOptions
   hToolsOptions ( "StarOffice", "General" )
   if bwhats = TRUE then
      StarOfficeDialogeBenutzen.Check
   else
      StarOfficeDialogeBenutzen.Uncheck
   end if
   Sleep 1
   Kontext "OptionenDlg"
   OptionenDlg.OK
   Sleep 3
end sub

'-------------------------------------------------------------------------

function hGetUsedFilter () as string
'/// Get used filter for loaded file.
   try
      FileSaveAs
      Kontext "SpeichernDlg"
      hGetUsedFilter = dateityp.getseltext
      SpeichernDlg.Cancel
   catch
      hGetUsedFilter = "Not possible; try/catch fail in function"
   endcatch
end function

'-------------------------------------------------------------------------

function hFileExport (sName as string, sFilter as string) as boolean
    '/// Wrapper function to simplify the use of the export functions, just give a filename and export format.
    '///+ INPUT:<ul><li>sName: filename</li><li>sFilter: &quot;PDF&quot;: call export for PDF</li></ul>
    '///+ RETURN: execution success?
    select case sFilter
        case "PDF" : '/// use the function 'hExportAsPDF' with RECOMMENDED values /// '
                    hFileExport = hExportAsPDFmulti (3, TRUE,  sName, FALSE, TRUE, 1, 1)
    end select
    kontext
    if active.exists(5) then
        try
            printlog active.getText
            active.ok
            warnLog "i26820 - errormessage about saving"
        catch
            printlog "pdf unexpected error in hFileExport()"
        endcatch
    endif
end function

'-------------------------------------------------------------------------

function hExportAsPDFmulti (iTypeOfCall as integer, bExecute as boolean, sFileName as string, bAutoExtension as boolean, bOverwriteFile as boolean, iRange as integer, iConpression as integer, optional sRange as string) as boolean
    '/// Export a document to PDF with various options.
    '///+ INPUT
    '///+<ul><li>iTypeOfCall<ol><li>1: via  the icon in the functionbar (no options selectable, since only file dialog comes up!)</li>
    '///+<li>2: via File->Send->Document As PDF Attachment... (makes no sense either, because after the mail window comes up... (you can't handle by the testtool))</li>
    '///+<li>3 vai File->Export As PDF... (RECOMMENDED)</li></ol></li>
    '///+<li>bExecute: Shall all dialogs left with OK? TRUE (RECOMMENDED) / FALSE</li>
    '///+<li>sFileName: Filename to use</li>
    '///+<li>bAutoExtension: Shall the file extension be chosen by StarOffice? TRUE / FALSE (RECOMMENDED)</li>
    '///+<li>bOverwriteFile: If filename already exists should it be overwritten? TRUE (RECOMMENDED) / FALSE</li>
    '///+<li>iRange:<ol><li>1: All (RECOMMENDED)</li>
    '///+<li>2: Pages: The range is set in the optional parameter 'sRange' at the end</li>
    '///+<li>3: Selection</li></ol></li>
    '///+<li>iConpression:<ol><li>1: JpegCompression check and ReduceImageResolution check</li>
    '///+<li>2: JpegCompression check and ReduceImageResolution uncheck</li>
    '///+<li>3: LosslessCompression check and ReduceImageResolution uncheck</li></ol></li>
    '///+<li>sRange: Optional parameter only used for iRange=2; takes the page range as text</li>
    '///+<li>RETURN: Any Errors? TRUE / FALSE</li></ul>
    dim sPDF as string
    dim sTemp as string
    dim iTemp as integer
    dim sTFileName as string
    dim iCount as integer

    sPDF = "PDF - Portable Document Format (.pdf)"
    hExportAsPDFmulti = TRUE ' optimistic
    iTemp = 0

    select case (iTypeOfCall)
        case 1 : '/// click the button 'Export Directly as PDF' on the Functionbar ///'
            kontext "Standardbar"
            try
                ExportAsPDF.click
            catch
                Warnlog "Button 'Export directly as PDF' not accessible!"
                hExportAsPDFmulti = FALSE
                exit function
            endcatch
        case 2 : '/// File->Send->Document As PDF Attachment... ///'
            try
                FileSendDocumentAsPDF
            catch
                Warnlog "'Export as PDF' not accessible!"
                hExportAsPDFmulti = FALSE
                exit function
            endcatch
        case 3 : '/// File->Export As PDF... ///'
            try
                FileExportAsPDF ' works in draw/impress, too but is not 'legal' in the UI :-)
            catch
                Warnlog "Button 'Export as PDF' not accessible!"
                hExportAsPDFmulti = FALSE
                exit function
            endcatch
    end select
   
    ' only if the type is 1 OR 3 then the File Save dialog appear
    if (iTypeOfCall = 1 OR iTypeOfCall = 3) then
        kontext "ExportAsPDFDlg"
        try
            Dateityp.Select sPDF
        catch
            Warnlog "Unable to select filter: '" + sPDF + "'"
            ExportAsPDFDlg.Cancel
            hExportAsPDFmulti = FALSE
            exit function
        endcatch

        sTemp = Dateityp.GetSelText
        if (sTemp <> sPDF) then
            Warnlog "filter for PDF export is missing :-( '" + sPDF + "'"
        end if
        '/// set Textbox 'File name' ///'
        Dateiname.SetText sFileName
        '/// uncheck the checkbox 'Automatic file name extension' ///'
        if (bAutoExtension) then
            AutomatischeDateinamenserweiterung.Check
        else
            AutomatischeDateinamenserweiterung.UnCheck
            'if the file has no pdf extension then add the extension
            if (lCase(right(sFileName, 4))=".pdf") then
                sTFileName = sFileName
            else
                sTFileName = sFileName + ".pdf"
            endif
        end if
        '/// click on the button 'Export...' ///'
        if (bExecute) then
            Export.Click
            kontext "AlienWarning"
            if AlienWarning.exists(5) then
                warnlog "#i41983# Alien Warning on export not allowed."
                AlienWarning.OK
            endif
            if (iTypeOfCall = 1) then ''Export Directly as PDF'
                iCount = 0
                ' wait until file exists for max 5 minutes
                while ((dir(sTFileName)="") AND (iCount < 30))
                    sleep 10
                    inc iCount
                wEnd
            endif
        else
            ExportAsPDFDlg.Cancel
        end if

        ' if file exists, there is a message...
        Kontext
        if messagebox.exists (5) then
            if (bOverwriteFile) then
                messagebox.Yes
            else
                messagebox.No
                kontext "ExportAsPDFDlg"
                    ExportAsPDFDlg.Cancel
                    hExportAsPDFmulti = FALSE
            end if
        end if
    end if
    
    ' only if the type is 2 OR 3 then the PDF option dialog appear
    if (iTypeOfCall = 2 OR iTypeOfCall = 3) then
        kontext "PDFOptions"
        select case (iRange)
            case 1 : '/// check radiobutton 'All' ///'
                try
                    RangeAll.Check
                catch
                    Warnlog "Radiobutton 'All' not accessible!"
                    PDFOptions.Cancel
                    hExportAsPDFmulti = FALSE
                    exit function
                endcatch
            case 2 : '/// check radiobutton 'Pages' ///'
                try
                    RangePages.Check
                catch
                    Warnlog "Radiobutton 'Range' not accessible!"
                    PDFOptions.Cancel
                    hExportAsPDFmulti = FALSE
                    exit function
                endcatch
                if isMissing(sRange) then
                    Warnlog "parameter 'sRange' in function 'hExportAsPDFmulti' is not optional if 'iRange' = 2"
                    hExportAsPDFmulti = FALSE
                else
                    '/// set range textbox the given value ///'
                    RangePagesEdit.SetText sRange
                end if
            case 3 : '/// check radiobutton 'Selection' (not enabled in math!) ///'
                try
                    if (RangeSelection.IsEnabled <> TRUE)then
                        Warnlog "RangeSelection is disabled :-("
                    else
                        RangeSelection.Check
                    end if
                catch
                    Warnlog "Radiobutton 'Selection' not accessible!"
                    PDFOptions.Cancel
                    hExportAsPDFmulti = FALSE
                    exit function
                endcatch
        end select
        
        select case (iConpression)
            case 1 : '/// JpegCompression check and ReduceImageResolution check///'
                try
                    JpegCompression.Check
                    ReduceImageResolution.Check
                catch
                    Warnlog "Radiobutton 'Reduce Image Resolution' not accessible!"
                    PDFOptions.Cancel
                    hExportAsPDFmulti = FALSE
                    exit function
                endcatch
            case 2 : '/// JpegCompression check and ReduceImageResolution uncheck ///'
                try
                    JpegCompression.Check
                    ReduceImageResolution.UnCheck
                catch
                    Warnlog "Radiobutton 'Jpeg Compression' not accessible!"
                    PDFOptions.Cancel
                    hExportAsPDFmulti = FALSE
                    exit function
                endcatch
            case 3 : '/// LosslessCompression check and ReduceImageResolution uncheck ///'
                try
                    LosslessCompression.Check
                    ReduceImageResolution.UnCheck
                catch
                    Warnlog "Radiobutton 'Lossless Compression' not accessible!"
                    PDFOptions.Cancel
                    hExportAsPDFmulti = FALSE
                    exit function
                endcatch
        end select
        if (bExecute) then
            try
                PDFOptions.OK
            catch
                qaErrorlog "ImprovementOfSave: PDF export loops?"
            endcatch
        else
            PDFOptions.Cancel
        end if
    end if
end function

'-------------------------------------------------------------------------

function hFileOpenWithFilter ( DocName$, Filter$, optional UpdateLinks as Boolean  ) as boolean
'/// Open a file with a filter
'///+INPUT:<ul><li>DocName$: Filename with path</li>
'///+<li>Filter$: Which filter should be used?</li>
'///+<li>optional UpdateLinks: How should the question 'should all links be updated?' be handled TRUE (DEFAULT)/ FALSE</li></ul>
'///+RETURN: Success with loading the document ? TRUE / FALSE</ul>
   hFileOpenWithFilter = hDateiOeffnenMitFilter ( DocName$, Filter$, UpdateLinks )
end function
