'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_pkgmgr.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/16 14:45:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description :
'*
'*******************************************************************************
' **
' #1 tUpdt_packagemanager 'Update test for the Package Manager GUI
' **
'\******************************************************************************



testcase tUpdt_packagemanager

    '///<h1>Update test for the Package Manager GUI</h1>
    '///<ul>
    
    dim sPackage as String
        sPackage = "framework\update\input\basic\Basic_Addon.zip"
        sPackage = convertpath( gTesttoolpath & sPackage )
    dim brc 
        
    printlog( "" )
    printlog( "add, disable, re-enable, export and remove a Package" )
    printlog( "" )
    
    '///<li>Open the Package-Manager-UI</li>
    brc = hOpenPackageManager() 
    if ( not brc ) then
        warnlog( "Failed to open Package Manager GUI, aborting test" )
        goto endsub
    endif

    call dialogtest( PackageManager )
    
    '///<li>Add a Package</li>
    '///<li>Check if the package is liste in the treelist</li>
    hAddPackage( sPackage )
    
    '///<li>Check if disable/enable of the Package works</li>
    checkEnableDisable()
    
    '///<li>Browse through the package to see if all components are present:</li>
    '///<ul>
    '///<li>Addons.xcu</li>
    '///<li>MyLib</li>
    '///</ul>
    browsePackage()
    
    '///<li>Export the package to a new name and delete the exported package</li>
    exportPackage()
    
    '///<li>Remove the Package from the Treelist in the Package-Manager-UI</li>
    '///<li>Close the Package-Manager-UI</li>
    hRemovePackage( "Basic_Addon.zip" )

    hClosePackageManager()
    '///</ul>

endcase

'*******************************************************************************

sub checkEnableDisable

    '///<h3>Disable/enable a package</h3>
    '///<i>Starting point: Package Manager GUI, testpackage is installed</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    printlog( " * Checking if disabling and enabling a package works")
    'set kontext to PackageManager

    '///+<li>Context to Package Manager GUI</li>
    kontext "packagemanager"
    'check, if the installed package is not enabled ==> it should be enabled!

    '///+<li>Cross-check: Package is enabled - disable button must be active</li>
    if ( enable.isEnabled() and not disable.isEnabled() ) then
        'in this case the installed package is not enabled!
        warnlog( "UI does not reflect the expected package status" )
    endif

    '///+<li>disable the package</li>
    Disable.click()
    sleep(4)
    'check if disabling worked: ==> Enable should be active,
    '                               Disable should be inactive

    '///+<li>Cross check: Package is disabled - enable button must be active</li>
    if ( enable.isEnabled() and not disable.isEnabled() ) then
        'in this case the package is disabled
        printlog( "   * Disabling the package..." )
    else
        warnlog( "Disable is inactive -> the package cannot be disabled" )
    endif

    '///+<li>re-enable the package</li>
    Enable.click()
    sleep(4)
    'check if re-enabling worked: ==> Enable should be inactive,
    '                                 Disable should be active

    '///+<li>Cross-check: Package is enabled - disable button must be active</li>
    if ( disable.isEnabled() and not enable.isEnabled() ) then
        'in this case the package is enabled
        printlog( "   * Enabling the package..." )
    else
        warnlog( "Enable is inactive -> the package cannot be enabled" )
    endif
    '///</ul>

end sub

'*******************************************************************************

sub browsePackage

    '///<h3>Browse through the entries for a package</h3>
    '///<i>Starting point: Package Manager GUI, testpackage is installed</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    printlog( " * Browse through the package")
    
    '///+<li>set kontext to PackageManager</li>
    kontext "packagemanager"
    
    '///+<li>select the first entry in that package: It should be "Addons.xcu"</li>
    BrowsePackages.typeKeys( "<RIGHT>" )
    wait( 500 )
    BrowsePackages.typeKeys( "<DOWN>" )
    wait( 500 )
    
    '///+<li>check if the selected entry is "Addons.xcu"</li>
    if ( BrowsePackages.getText() <> "Addons.xcu" ) then
        'in this case the first entry is wrong!
        warnlog( "Incorrect Package or package not imported" )
    else
        'in this case adding workde as expected
        printlog( "   * Addons.xcu  successfully added" )
    endif

    '///+<li>select the second entry: it should be "MyLib"</li>
    BrowsePackages.typeKeys( "<DOWN>" )
    wait( 500 )
    
    '///+<li>check if the selected entry is "MyLib"</li>
    if ( BrowsePackages.getText() <> "MyLib" ) then
        warnlog( "Incorrect Package or package not imported" )
    else
        printlog( "   * MyLib successfully added" )
    endif
    '///</ul>

end sub

'*******************************************************************************

sub exportPackage

    '///<h3>Export a package, delte it using export-dialog</h3>
    '///<i>Starting point: Package Manager GUI, testpackage is installed</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    dim sOutPath as string
        sOutPath = hGetWorkFile( "AddOns.zip" )
        
    dim iFileCount as integer          ' Count of ListItems
    dim iCurrentFile as integer        ' "running" variable starting with 1
    printlog( " * Try to export a package")
    
    '///+<li>Set kontext to PackageManager</li>
    kontext "packagemanager"
    
    '///+<li>Select the Package itself...</li>
    BrowsePackages.typeKeys( "<UP>" )
    wait( 500 )
    BrowsePackages.typeKeys( "<UP>" )
    wait( 500 )
    
    '///+<li>Click &quot;Export...&quot;</li>
    Export.click()
    sleep(2)

    '///+<li>Name the file, save it to the local work directory</li>
    kontext "speicherndlg"

    Dateiname.setText( sOutPath )
    sleep(2)
    printlog( "   * Exporting package" )
    Speichern.click()
    printlog( "   * Exporting package   ok" )

    kontext "active"

    '///+<li>Check for unexpected messageboxes</li>
    if ( active.exists( 1 ) ) then
        warnlog( "Unexpected Active: " & active.gettext() )

        try
            active.yes()
        catch
            Active.ok()

            kontext "speicherndlg"
            SpeichernDlg.cancel()
        endcatch

    endif

    sleep(2)
    printlog( " * Try to delete the exported package")
    
    '///+<li>Set kontext to PackageManager</li>
    kontext "packagemanager"
    Export.click()
    sleep(2)
    
    '///+<li>Use the export dialog to find the package and to delete it...</li>
    kontext "speicherndlg"
    DateiAuswahl.select(1)
    iCurrentFile  = 1
    iFileCount = DateiAuswahl.getItemCount()
    DateiAuswahl.typekeys( "<UP>" )
    wait(500)

    while (DateiAuswahl.getText <> "AddOns.zip" and iCurrentFile <= iFileCount)
        DateiAuswahl.typekeys( "<DOWN>" )
        iCurrentFile = iCurrentFile + 1
        sleep(1)
    wend          'End of while...

    '///+<li>Delete the file AddOns.zip: Press DEL</li>
    if (DateiAuswahl.getText = "AddOns.zip") then
        DateiAuswahl.typekeys( "<DELETE>" )

        kontext "confirmdelete"
        
        '///+<li>Confirm deletion</li>
        Delete.click()
        sleep(3)
    else
        warnlog( " * Deleting exported package: File could not be found!!" )
    endif

    '///+<li>Leave Export dialog with cancel</li>
    Kontext "SpeichernDlg"
    SpeichernDlg.cancel()
    
    '///+<li>Verify that the exported package has been deleted</li>
    hDeleteFile( sOutPath )
    
    '///</ul>
    

end sub

