'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: stringtools.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/11 15:24:18 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Functions for manipulation of strings
'*
'*******************************************************************************
'**
' #1 hRemoveLineBreaks  ' Remove linebreaks and tabs from a string
' #1 hCompareSubStrings ' compare two strings (exact or as substring)
'**
'\******************************************************************************

function hRemoveLineBreaks( cString as string ) as string

    '///<h3>Remove linebreaks and tabs from a string</h3>
    '///<i>Used to &quot;beautify&quot; content of messageboxes when printed to the log</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Content of a messagebox as captured with .getText() (string)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>A string without tabs, linebreaks and linefeed (string)</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    '///+<li>Walk through the string, replace linebreaks, tabs etc. with spaces</li>

    ' Function (undocumented) to remove LF and CR from strings.
    ' When a messagebox appears with multiple lines of text this usually
    ' breaks the output of the printlog into multiple lines making it
    ' hard to read. So this function puts the entire text in one line.

    dim iCharPos as integer
    dim cCurrentChar as string
    dim cNewString as string

    ' walk through the string character by character and replace those
    ' characters that break the line. Tabs and linebreaks become spaces
    for iCharPos = 1 to len( cString ) 

        cCurrentChar = mid( cString , iCharPos , 1 )

        select case cCurrentChar
        case CHR$(13) : cNewString = cNewString & " " ' replace linebreak
        case CHR$(10) : ' Simply ignore linefeed
        case CHR$(09) : cNewString = cNewString & " " ' replace tab with space
        case else     : cNewString = cNewString & cCurrentChar ' append char
        end select
        
     next iCharPos

     hRemoveLineBreaks() = cNewString
     '///</ul>

end function

'*******************************************************************************

function hCompareSubStrings( cRef as string, cSub as string ) as integer

    '///<h3>Find substring in a reference string</h3>
    '///<i>Used to determine that we are on &quot;The first doc!&quot;</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Term to search for (string)</li>
    '///+<li>Term to be searched (string)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcode (integer)</li>
    '///<ul>
    '///+<li>-1: Invalid parameter(s)</li>
    '///+<li>0: Strings do not match</li>
    '///+<li>1: Term is exact match</li>
    '///+<li>2: Term is a substring</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hCompareSubStrings::"

    '///+<li>Test function parameters</li>
    if ( ( cRef = "" ) or ( cSub = "" ) ) then
        warnlog( CFN & "invalid parameter(s): Empty string passed." )
        hCompareSubStrings() = -1
        exit function
    endif
    
    dim irc as integer

    '///+<li>Test if we have a substring</li>
    if ( instr( cRef, cSub ) > 0 ) then
        irc = 2
    else
        irc = 0
    endif

    '///+<li>Test if we have an exact match</li>
    if ( irc = 2 ) then
        if ( ( cRef = cSub ) and ( len( cRef ) = len( cSub ) ) ) then
            irc = 1
        endif
    endif
    
    select case irc
    case 0 : printlog( CFN & "No matching substring found" )
    case 1 : printlog( CFN & "Strings are identical" )
    case 2 : printlog( CFN & "String is substring" )
    end select
    
    hCompareSubStrings() = irc
    '///</ul>
    
end function

