'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: pkgmgr_tools.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/16 14:45:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools used for the PackageManager-UI
'*
'*******************************************************************************
'**
' #1 hAddPackage             ' Add a package vie Package-Manager-UI
' #1 hRemovePackage          ' Remove a package from the Package-Manager-UI
' #1 hopenPackageManager     ' open the Package Manager GUI
'**
'\******************************************************************************

function hAddPackage( cFile as string, optional bClose as boolean ) as string

    '///<h3>Add a package to "My Macros" using the Package-Manager-UI</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Full path to package (string)</li>
    '///+<li>Close Package Manager GUI afterwards (boolean, Optional)</li>
    '///<ul>
    '///+<li>TRUE: Close dialog</li>
    '///+<li>FALSE: Leave dialog open</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Name of the package (string)</li>
    '///<ul>
    '///+<li>On success: The display name of the package is returned</li>
    '///+<li>On error the function returns an empty string</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    '///<ul>

    const CFN = "hAddPackage::"    
    dim iWait as integer ' increment-variable 
    dim cPkgName as string
    dim brc as boolean
    
    ' Do not close the Dialog by default
    if ( ismissing( bClose ) ) then bClose = false
    
    '///+<li>Open the Package-Manager UI</li>
    printlog( CFN & "Open the Package-Manager-UI" )
    brc = hOpenPackageManager()
    if ( not brc ) then
        warnlog( CFN & "Package Manager is not open, aborting test" )
        hAddPackage = ""
        exit function
    endif
    
    BrowsePackages.select( 1 )
    BrowsePackages.typeKeys( "<UP>" )
    
    '///+<li>Click the 'Add' button</li>
    printlog( CFN & "Click the 'Add' button" )
    Add.click()
    sleep( 1 )

    '///+<li>Insert the full path to the package</li>
    kontext "generalfiledialog"
    Dateiname.setText( cFile )
    sleep( 1 )
    
    '///+<li>Click the Open-Button</li>
    printlog( CFN & "Click the 'Open' button" )
    oeffnen.click()
    
    '///+<li>Wait for the package to be added, this may take a few seconds</li>
    printlog( CFN & "Importing package, allowing 15 seconds for that" )
    for iWait = 1 to 15 
        try
            ' handle errors such as "package already installed"
            printlog( CFN & "Look for any messagebox" )
            kontext "active" 
            if ( active.exists() ) then
                warnlog( CFN & "Unexpected Active: " & active.gettext() )
                active.ok()
            endif
            
            ' try to access the treelist. If this works, the dialog has the focus
            printlog( CFN & "Walk upwards in the packages-list" )
            kontext "packagemanager"
            BrowsePackages.typeKeys( "<UP>" )
            brc = true
            printlog( CFN & "Importing package has finished." )
        catch
            printlog( CFN & "Importing package: Waiting another second to complete" )
            brc = false
            sleep( 1 )
        endcatch

        if ( brc ) then
            exit for
        endif

    next iWait
    
    if ( not brc ) then
        warnlog( CFN & "Could not add package within the given timeframe, aborting" )
        call ExitRestartTheOffice()
        hAddPackage() = ""
        exit function
     endif
    
    kontext "packagemanager"
    wait( 100 )
    
    '///+<li>check whether the package has been added or not</li>
    printlog( CFN & "Select the first node below 'My Macros'" )
    BrowsePackages.TypeKeys( "<RIGHT>" )
    wait( 100 )
    BrowsePackages.TypeKeys( "<DOWN>" )
    wait( 100 )
    
    cPkgName = BrowsePackages.getText() 
    printlog( CFN & "Name of the package: " & cPkgName )
    hAddPackage() = cPkgName
    
    ' the package should be enabled by default. if this is not the case,
    ' try to set it enabled and warn. 
    if ( enable.isEnabled() ) then  
        enable.click()
	warnlog( CFN & "Apparently the package was installed with the DISABLED " & _
	         "attribute by default. This should not happen" )
    endif
        		 

    
    '///+<li>Optional: Close the Package Manager if needed</li>
    if ( bClose ) then
        brc = hClosePackageManager()
    endif
    
    '///</ul>
     
end function

'*******************************************************************************

function hRemovePackage( cName as string ) as boolean

    '///<h3>Remove a specific package from the Package Manager GUI</h3>
    '///<i>Starting point: Package Manager GUI, package must exist</i><br>
    '///<i>Important: Refer to inline documentation, expect the unexpected.</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of the package to be removed (string)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE: Package has been deleted</li>
    '///+<li>FALSE: Anything went wrong</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    
    const CFN = "hRemovePackage::"
    dim brc as boolean    ' true if deletig worked
    dim cItemName as string   ' Name of the current item in the pkgmgr UI

    '///+<li>Context to Package manager GUI</li>
    kontext "packagemanager"
    
    '///+<li>Enter the treelistbox to select the package which shall be removed</li>
    ' NOTE: This is not a very safe way to find the correct item as it only 
    '       expands the first node and selects the second item. TODO
    BrowsePackages.select(1)
    wait( 500 )
    BrowsePackages.typeKeys( "<UP>" )
    wait( 500 )
    BrowsePackages.typeKeys( "<RIGHT>" )
    wait( 500 )
    BrowsePackages.typeKeys( "<DOWN>" )
    sleep( 5 )         'the added package should now be selected...
    
    '///+<li>get the name of the currently selected item</li>
    cItemName = BrowsePackages.getText()
    
    '///+<li>if this is the correct item, try to delete the package</li> 
    if ( cItemName = cName ) then
        remove.click()
        printlog( CFN & "Package has been deleted" )
        brc = true
    else
        warnlog( CFN & "An unknown package is selected for deletion, aborting" )
        brc = false
    endif
    
    hRemovePackage() =  brc
    '///</ul>
    
end function

'*******************************************************************************

function hOpenPackageManager() as boolean

    '///<h3>Open the package Manager using the slot</h3>
    '///<i>Starting point: Any document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE on success</li>
    '///+<li>FASLE on error</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>


    const CFN = "hOpenPackageManager::"
    dim brc as boolean

    '///+<li>open the package manager using the slot</li>
    ToolsPackageManager
    
    '///+<li>Verify that the Package Manager GUI is really open</li>
    kontext "packagemanager"
    if ( PackageManager.exists() ) then
        printlog( CFN & "Package Manager GUI is open" )
        brc = true
    else
        printlog( CFN & "Package manager GUI is not open" )
        brc = false
    endif
    
    hOpenPackageManager() = brc
    '///</ul>
    
end function

'*******************************************************************************

function hClosePackageManager() as boolean

    '///<h3>Close the Package Manager GUI</h3>
    '///<i>Starting point: Package Manager GUI is open</i><br>
    '///<i>Important: Evaluate returncode, the function does not warn</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE on success</li>
    '///+<li>False on any other condition</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hClosePackageManager::"
    dim brc as boolean
    
    '///+<li>Set context to Package Manager GUI</li>
    kontext "packagemanager"
    if ( PackageManager.exists() ) then
    
        '///+<li>Try to close it using &quot;Close&quot;</li>
        try
            PackageManager.close()
            printlog( CFN & "Closed Package Manager GUI" )
            brc = true
            
            '///+<li>Verify that the Package Manager GUI is indeed closed</li>
            kontext "packagemanager"
            if ( PackageManager.exists() ) then
                brc = false
            endif
        catch
            printlog( CFN & "Failed to close Package Manager GUI" )
            brc = false
        endcatch
    else
        printlog( CFN & "The Package Manager does not exist" )
        brc = false
    endif
    
    hClosePackageManager() = brc
    '///</ul>
    
end function
