'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_tools.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: jsk $ $Date: 2006/02/01 13:22:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : Tools to handle templates and samples
'*
'************************************************************************
'*
' #1 hCompareStylesAndFormats ' Compare styles and formats against a reference
' #1 hApplyBlackList          ' Identify files not to be loaded
' #1 siSpracheSetzen          ' convert langcode to two char string (1 -> 01)
'*
'\***********************************************************************

function hCompareStylesAndFormats( sFormatListFromGUI() as string, _
                                                 iIndex as integer, _
                                               iVariant as integer ) as boolean
                                               
    '///<h3>Compare styles and formats (drawing objects) to a reference</h3>
    '///<ul>

    dim sFileName as string
    dim sFileOut as string
    dim sFormatListFromFile( 1000 ) as string
    dim cPrefix as string
        cPrefix = gTesttoolpath & "framework\extras\input\formats\"
    dim brc as boolean
    dim irc as integer
    const CSUFFIX = ".txt"
    sFormatListFromFile ( 0 ) = 0

    '///+<li>Create filenames for:</li>
    '///<ul>
    select case iIndex
     
    '///+<li>Line styles ( standard.sod, *.sod )</li>
    case 1

        select case iVariant
        case 1 : sFileName = cPrefix  & "lines\stand" & siSprache
        case 2 : sFileName = cPrefix  & "lines\styles" & siSprache
        end select

    '///+<li>Line ends ( arrows ) ( standard.sow, *.soe )</li>
    case 2  

        select case iVariant
        case = 1 : sFileName = cPrefix  & "arrows\stand" & siSprache
        case = 2 : sFileName = cPrefix  & "arrows\arrow" & siSprache
        end select

    '///+<li>Colors ( standard.soc, *.soc )</li>
    case 3  

        select case iVariant
        case 1 : sFileName = cPrefix  & "colors\stand" & siSprache
        case 2 : sFileName = cPrefix  & "colors\palet"
        case 3 : sFileName = cPrefix  & "colors\cmyk"
        case 4 : sFileName = cPrefix  & "colors\web"
        case 5 : sFileName = cPrefix  & "colors\html"
        case 6 : sFileName = cPrefix  & "colors\gall"
        case 7 : sFileName = cPrefix  & "colors\sun"
        end select

    '///+<li>Gadients ( Standard.sog, *.sog )</li>
    case 4

        select case iVariant
        case 1 : sFileName = cPrefix  & "gradient\stand"  & siSprache
        case 2 : sFileName = cPrefix  & "gradient\class"  & siSprache
        case 3 : sFileName = cPrefix  & "gradient\modern" & siSprache
        end select

    '///+<li>Hatchings = standard.soh</li>
    case 5  

        select case iVariant
        case 1 : sFileName = cPrefix  & "hatching\stand" & siSprache
        case 2 : sFileName = cPrefix  & "hatching\hatch" & siSprache
        end select

    '///+<li>Bitmap = standard.soh</li>
    case 6 

        select case iVariant
        case 1 : sFileName = cPrefix  & "bitmap\stand" & siSprache
        end select

    '///+<li>Name of Table-formats ( internal )</li>
    case 7
    
        sFileName = cPrefix  & "tables\table" & siSprache
        
    '///+<li>Name of Label-formats</li>
    case 8
    
        sFileName = cPrefix  & "labels\lab" & iVariant & siSprache
        
    end select
    '///</ul>

    '///+<li>Create filenames (inluding paths) for input and output</li>
    sFileName = sFileName & CSUFFIX
    sFileOut = hGetWorkPath & sFileName
    sFileName = convertpath( sFileName )
    
    '///+<li>Compare the lists or create a new one if it does not exist</li>
    irc = hManageComparisionList( sFileName, sFileOut, sFormatListFromGUI() )
    if ( irc <> 0 ) then
        warnlog( "Comparision failed!" )
        brc = false
    else
        brc = true
    endif
    
    '///+<li>Return TRUE if comparision succeeded with no errors</li>
    hCompareStylesAndFormats() = brc
    '///</ul>

end function

'*******************************************************************************

function hApplyBlackList( sFileName as string ) as boolean

    const CFN = "hApplyBlackList::"
    '///<h3>Function to identify blacklisted files that will not be tested</h3>
    '///<ul>
    '///+<li>Make sure we have a valid functionparameter</li>

    if ( sFileName = "" ) then
        warnlog( CFN & "Empty filename passed to function" )
        hApplyBlackList() = false
        exit function
    endif

    dim sExtension as string
    dim brc as boolean
    
    '///+<li>idxexample.sxw is not a regular document and should not be loaded.</li>
    if ( instr( sFileName , "idxexample.odt" ) > 0 ) then
        printlog( CFN & "Skipping idxexample.odt" )
        hApplyBlackList() = true
        exit function
    endif

    '///+<li>files with the suffix .table are to be skipped as well.</li>
    if ( instr( sFileName , ".table" ) > 0 ) then
        printlog( "" )
        printlog( CFN & "Skipping .table" )
        hApplyBlackList() = true
        exit function
    endif

    '///+<li>Test the suffix and skip graphics files (.gif, .jpg, .bmp)</li>
    brc = hFileHasThreeCharSuffix( sFileName )

    if ( brc ) then
        sExtension = hGetSuffixFromFileName( sFilename )

        if ( sExtension = ".bmp" OR sExtension = ".gif" OR sExtension = ".jpg" ) then
            printlog( CFN & "Skipping bmp, gif or jpg graphic" )
            hApplyBlackList() = true
            exit function
        endif

    endif

    printlog( CFN & "No rules apply" )
    hApplyBlackList() = false
    '///</ul>

end function

'*******************************************************************************

sub siSpracheSetzen

    '///<h3>Make a 2-Character string out of 1 digit (integer) language-code</h3>
    '///<i>Prerequisite: Variable siSprache must be set globally</i><br>
    '///<u>Deprecated, avoid using it</u>

   if iSprache < 10 then ' make a 2 digit language-Id from the internal language-Id
      siSprache = "0" & iSprache
   else
      siSprache = iSprache
   end if
   
end sub


