'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ftpserver1.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:18 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( extended tests )
'*
'*******************************************************************************
'**
' #1 tFTPConnection      ' establishes a ftp-connection with a valid user
' #1 tFTPPasswordDialog  ' checks the password dialog for ftp-connections
' #1 tFTPServerProxies   ' test loadbahavior w/wo proxies
'**
'\******************************************************************************

testcase tFTPConnection( cFTPServer, cLogin, cPassword as string )

   ' This small test checks if logging in to a ftp server as anonymous
   ' or with a valid account works.

   dim cServerURL as string

   '///Test the connection policies (connection as anonymous + valid user)
   printlog( CHR$(13) + "Testing FTP-Server: " + cFTPServer )
   
   '///+Disable the proxies
   printlog( CHR$(13) + " - disable the Proxies" )
   call DisableProxies()
   
   '///+Open connection to the ftp-server as anonymous (no loginname provided)
   ' This is expected to work. The "FTPServerrConnect" should end up loading 
   ' the directory for the user 'anonymous' into the FileOpen dialog.
   ' CancelFileOpen() closes it and brings the test back into neutral state.
   printlog( " - trying login as anonymous" )
   cServerURL = "ftp://" + cFTPServer
   call FTPServerConnect( cServerURL , TRUE ) '-> stops on FileOpen dialog
   call CancelFileOpen()

   '///+Open connection to the ftp-server with a valid account
   ' This is expected to work. The "FTPServerrConnect" should end up loading 
   ' the directory for the user 'cLogin' into the FileOpen dialog.
   ' CancelFileOpen() closes it and brings the test back into neutral state.
   printlog( " - trying login with valid user/password" )
   cServerURL = "ftp://" + cLogin + ":" + cPassword + "@" + cFTPServer 
   call FTPServerConnect( cServerURL , TRUE ) '-> stops on FileOpen dialog
   call CancelFileOpen()
   
   '///+Re-enable the proxies
   printlog( " - enable the Proxies" )
   call EnableProxies()
   
   '///+Restart the office
   call ExitRestartTheOffice()
   
   printlog( "" )

endcase

'*******************************************************************************

testcase tFTPPasswordDialog( cFTPServer, cLogin, cPassword as string )

   '///Test the password dialog for FTP  
   printlog( CHR$(13) + "Testing FTP-Server: " + cFTPServer )

   ' This small test checks the password dialog that pops up when connecting to 
   ' a ftp-server without login (anonymous on servers that do not allow
   ' anonymous access) or with invalid username/password
   
   '///Test the "Enter Password" dialog for FTP 
   
   const CINVALIDPWD = "blubb234"
   const CINVALIDUSR = "snort"
   
   dim cServerURL as string
   
   '///+Disable the proxies
   printlog( CHR$(13) + " - disable the Proxies" )
   call DisableProxies()   
   
   '///+Open connection to the ftp-server as anonymous
   ' After a FTPServerConnect() the Password dialog for FTP should be open
   ' Here we only cancel the dialog.
   printlog( " - trying login as anonymous" )
   cServerURL = "ftp://" + cFTPServer 
   call FTPServerConnect( cServerURL , FALSE )
   call FTPCancelPasswordDialog( FALSE ) 

   '///+Open connection to the ftp-server with a valid user but no password
   ' After a FTPServerConnect() the Password dialog for FTP should be open
   ' A valid password is entered into this dialog
   printlog( " - trying login with valid user and no password" )
   cServerURL = "ftp://" + cLogin + "@" + cFTPServer 
   call FTPServerConnect( cServerURL , FALSE )
   call FTPEnterValidPassword( cPassword )

   '///+Open connection to the ftp-server with valid user and invalid password
   ' After a FTPServerConnect() the Password dialog for FTP should be open
   ' A valid password is entered into this dialog
   printlog( " - trying login with valid user and invalid password" )
   cServerURL = "ftp://" + cLogin + ":" + CINVALIDPWD + "@" + cFTPServer 
   call FTPServerConnect( cServerURL , FALSE )
   call FTPEnterValidPassword( cPassword )

   '///+Open connection to the ftp-server with invalid user/password
   ' After a FTPServerConnect() the Password dialog for FTP should be open
   ' Since we cannot login (invalid user) we can just enter anything as 
   ' password. The dialog will then ask to retry, this time the dialog
   ' is cancelled. FTPEnterInvalidPassword() does this.
   printlog( " - trying login with invalid user and invalid password" )
   cServerURL = "ftp://" + CINVALIDUSR + ":" + CINVALIDPWD + "@" + cFTPServer 
   call FTPServerConnect( cServerURL , FALSE )
   call FTPEnterInValidPassword( cPassword )

   '///+Re-eanble the proxies
   printlog( " - enable the Proxies" )
   call EnableProxies()
   
   '///+Exit and restart the office
   ' The office might have remembered some access-data, restarting the 
   ' application makes it forget
   call ExitRestartTheOffice()
   
   printlog( "" )

endcase

'*******************************************************************************

testcase tFTPServerProxies( cFTPServer as String )

   ' This is a small test that connects to a ftp-server and gets the directory-list.
   ' With proxies enabled, the list is loaded into a new writer document,
   ' saving files will fail.
   ' With proxies disabled, the directory is listed within the file-open dialog
   ' and saving/loading/deleting files will succeed.

   '///Test FTP Server.
   printlog( CHR$(13) + "Testing FTP-Server: " + cFTPServer )

   const MYWORKFILE = "testfile.sxw"

   dim cFullPath as string
       cFullPath = cFTPServer + MYWORKFILE

   '///+Enable Proxies for FTP in Tools/Options (Internet/Proxy)
   call EnableProxies()

   '///+Open a directory on a FTP Server with proxies enabled -> opens document
   call FTPLoadFileExpectSuccess( cFTPServer )

   '///+Save a new document to the ftp server (proxies enabled) -> failure
   call FTPSaveFileExpectFailure( cFullPath )

   '///+Disable Proxies (Tools/Options/Internet/Proxies)
   call DisableProxies()

   '///+Save a new file to the ftp-server (proxies disabled) -> success
   call FTPSaveFileExpectSuccess( cFullPath )

   '///+Close and reload the file (proxies disabled) -> success
   call FTPLoadFileExpectSuccess( cFullPath )

   '///+Close and delete the file (poxies disabled) -> success
   call FTPDeleteFileExpectSuccess( cFTPServer , MYWORKFILE )

   '///+Re-enable the proxies
   call EnableProxies()

   '///+Restart the office   
   call ExitRestartTheOffice()
   

endcase


