'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filename_tools.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: jsk $ $Date: 2005/12/20 14:24:10 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( extended tests )
'*
'*******************************************************************************
'**
' #1 LoadFileExpectSuccess   ' try to load a file - success expected
' #1 LoadFileExpectFailure   ' try to read a file - failure expected
' #1 SaveFileExpectSuccess   ' try to save a file - success expected
' #1 SaveFileExpectFailure   ' try to save a file - failure expected
' #1 CreateNewDirectory      ' create a new directory using FileOpen
' #1 hGetFileCount           ' gets the number of files in the current workdir
' #0 hNameGen_append  ' generates filenames with ASCII/UNICODE chars
' #0 hNameGen_lead    ' generates filenames with ASCII/UNICODE chars
' #0 hCloseDocument128307 ' temporary and local  replacement for hCloseDocument
'**
'\******************************************************************************

sub SaveLoadDelSuccess( cFile as string )

    ' This sub tries to save a document to the given filename, to reload and
    ' after completion to delete the file via FileOpen.
    ' All actions are supposed to complete without errors.

    SaveFileExpectSuccess( cFile , TRUE ) ' save and overwrite
    LoadFileExpectSuccess( cFile )        ' load
    DeleteFileExpectSuccess( cFile )

    sleep( 1 )
    kontext "active"
    if ( active.exists() ) then
        qaerrorlog( "#i33946# Unexpected active: " & active.gettext() )
        active.ok()
    endif

end sub

'*******************************************************************************

sub LoadFileExpectSuccess( fpath as string )

    const ICWAIT as Integer = 1

    printlog( " * Trying (load-success): " & fpath )
    FileOpen    
    sleep( ICWAIT )

    'printlog( " - Type the filepath/name into the entryfield" )
    Kontext "OeffnenDLG"
    DateiName.setText( fpath )

    'printlog( " - Click 'Open'" )
    oeffnen.click()    
    sleep( ICWAIT * 2 )

    Kontext "Active"
    if ( Active.Exists() ) then
        warnlog( "An unexpected messagebox came up and will be closed:" )
        printlog( Active.getText() )
        Active.OK()

        Kontext "OeffnenDLG"
        OeffnenDLG.cancel()
        exit sub
    endif

    ' try to recover in case of failure so the test can continue.
    Kontext "OeffnenDLG"
    if ( Oeffnen.Exists() ) then
        warnlog( "The file was not opened, it doesn't appear to exist" )
        OeffnenDLG.cancel()
        exit sub
    endif

    IsItLoaded

    if ( getDocumentCount < 2 ) then
        warnlog( "Document missing" )
    endif
    
    '///+Close the document
    printlog( " - Close the document" )
    'hDestroyDocument()
    hCloseDocument128307
    
end sub

'*******************************************************************************

sub LoadFileExpectFailure( fpath as string )

    const ICWAIT as Integer = 1
    dim brc as boolean

    printlog( " *  Trying (load-failure): " & fpath )

    FileOpen    
    Kontext "OeffnenDLG"

    'printlog( " - type the filepath/name into the entryfield" )
    DateiName.setText( convertpath( fpath ) )

    'printlog( " - Click 'Open'" )
    oeffnen.click()

    Kontext "Active"
    if Active.Exists() then
        printlog( " - Close warning dialog" )
        Active.OK()

        Kontext "OeffnenDLG"
        OeffnenDLG.cancel()
        exit sub
    endif

    Kontext "OeffnenDLG"
    if ( Oeffnen.Exists() ) then
        printlog( " - File is not loaded, still in File/Open. Good, cancelling" )
        OeffnenDLG.cancel()
        exit sub
    endif

    IsItLoaded
    warnlog( "The file appears to have loaded correctly. Not good" )

    ' try to recover from previous errors so the test can continue
    Kontext "Active"
    if Active.Exists() then
        printlog( " - Close warning dialog" )
        Active.OK()

    endif

    '///+Close the document
    'printlog( " - Close the document" )
    brc = hDestroyDocument()
    
end sub

'*******************************************************************************

sub SaveFileExpectSuccess( fpath as string , replacefile as boolean )

    ' Saves a file using FileSaveAs. Existing files can be replaced

    const ICWAIT as Integer = 1
    dim brc as boolean

    hCreateDocument()

    printlog( " * Trying (save-success): " & fpath  )
    FileSaveAs    'sleep( ICWAIT )

    'printlog( " - Enter filename" )
    Kontext "SpeichernDlg"
    Dateiname.setText( fpath )

    'printlog( " - Uncheck automatic filename extension" )
    automatischedateinamenserweiterung.uncheck()

    'printlog( " - Press 'Save'" )
    speichern.click()

    sleep( ICWAIT * 2 )

    if ( replacefile = true ) then
        Kontext "Active"
        if ( active.exists() ) then
            printlog( " - Overwrite file" )
            active.yes()
        endif
    endif

    Kontext "Active"
    if ( active.exists() ) then
        warnlog( "Unexpected errormessage came up, closing" )
        printlog( active.getText() )
        sleep( ICWAIT )

        active.ok()
    endif

    if( getDocumentCount < 2 ) then        
        warnlog( "Document missing" )
    endif
    
    '///+Close the document
    'printlog( "Close the document" )
    brc = hDestroyDocument()

end sub

'*******************************************************************************

sub SaveFileExpectFailure( fpath as string , errortype as integer )

    ' currently we have two different kinds of failure
    ' 1. File cannot be saved due to invalid character(s)
    '    This is the default, errortype = 0
    ' 2. File cannot be saved because the given name is interpreted as device
    '    This is errortype = 1
    ' This sequence tries to save a document with an invalid name. The errormsg
    ' is closed, the filedialog cancelled and the file closed. We should be back
    ' to "The first doc" after completion

    const ICWAIT as Integer = 1
    dim brc as boolean

    call hCreateDocument()
    printlog( " * Trying (save-failure): " & fpath  )
    FileSaveAs
    
    'printlog( " - Enter filename" )
    Kontext "SpeichernDlg"
    Dateiname.setText( fpath )

    'printlog( " - Uncheck automatic filename extension" )
    automatischedateinamenserweiterung.uncheck()

    'printlog( " - Press 'Save'" )
    speichern.click()
    sleep( ICWAIT )

    ' special treatment for names containing ':', "\" or "/"
    if ( errortype = 1 ) then

        Kontext "Active"
        if ( Active.exists() ) then
            printlog( " - Close errormessage for '/', '\' or ':' " )
            Active.OK()
            sleep( ICWAIT )

            Kontext "SpeichernDLG"
            SpeichernDLG.cancel()
            sleep( ICWAIT )
        else
            warnlog( "Errormessage for '/', '\' or ':' is missing" )
        endif

    elseif ( errortype = 0 ) then

        Kontext "Active"
        if ( Active.Exists() ) then
            printlog( " - Close the expected warning" )
            try
                Active.OK()
            catch
                printlog( "hSaveFileExpectFailure::" & active.getText() )
                Active.Yes()
                sleep( 2 )
                kontext "Active"
                Active.OK()

            endcatch
        else
            warnlog( "Warning missing: Unable to write file" )
        endif

    endif

    '///+Close the document
    'printlog( " - close the document" )
    brc = hDestroyDocument()
end sub

'*******************************************************************************

sub CreateDirectoryExpectSuccess( dirname as string )

    ' This sub creates a directory and returns to the file-open dialog

    FileOpen    
    sleep( ICWAIT )

    Kontext "OeffnenDlg"
    dateiname.setText( location )
    oeffnen.click()    
    NeuerOrdner.click()

    Kontext "NeuerOrdner"
    OrdnerName.setText( dirname )
    NeuerOrdner.OK()

    Kontext "Active"
    if Active.Exists() then
        warnlog( "An unexpected messagebox came up and will be closed" )
        printlog( "Text: " & Active.getText() )
        try
            Active.YES()
        catch
            Active.OK()
        endcatch
    endif

end sub

'*******************************************************************************

sub DeleteFileExpectSuccess( cFile as String )

    ' This sub deletes a file by name. No errors or warnings are expected.
    ' if everything goes well,  we're back to the originating document after
    ' completion.

    dim iFilesBeforeDelete as integer
    dim iFilesAfterDelete as integer
    dim iCurrentFile as integer
    const ICWAIT as Integer = 1

    ' FileOpen
    FileOpen
    
    ' get the current number of files in the filelist
    Kontext "OeffnenDLG"
    iFilesBeforeDelete = DateiAuswahl.getItemCount()

    ' delete the file specified in cFile using stringcompare in "Dateiauswahl"
    ' NOTE: In some cases this might fail (e.g. truncated spaces)
    for iCurrentFile = 1 to iFilesBeforeDelete

        if ( DateiAuswahl.getItemText( iCurrentFile ) = cFile ) then
            printlog( " * Deleting file: " & DateiAuswahl.getItemText( iCurrentFile ) )
            DateiAuswahl.Select( iCurrentFile )
            DateiAuswahl.TypeKeys( "<DELETE>" )
            sleep( ICWAIT )

            ' confirm deletion
            Kontext "ConfirmDelete"
            Delete.click()

            ' break the loop
            iCurrentFile = iFilesBeforeDelete + 1
        endif

    next iCurrentFile

    Kontext "Active"
    if( Active.exists( 1 ) = true ) then
        Active.OK()
        warnlog( "#i26796# Unexpected dialog before cancel" )
    endif

    ' The testtool internally does not refresh the list so restarting the dialog
    ' is required to get the new number of files in the list.
    Kontext "OeffnenDLG"
    OeffnenDLG.cancel()
    sleep( ICWAIT )

    ' check if the filecount has decreased by one. If not, the file has not been
    ' deleted. This might happen for some chars, so this is only a qaerrorlog
    FileOpen    
    
    Kontext "OeffnenDLG"
    iFilesAfterDelete = Dateiauswahl.getItemCount()
    if ( iFilesAfterDelete <> ( iFilesBeforeDelete - 1 )) then
        printlog( "The File: " & cFile & " has not been deleted. Please check." )
    endif

    OeffnenDLG.cancel()

end sub

'******************************************************************************

function hGetFileCount() as integer

    '///get the number of files currently listed in the filepicker
    const ICWAIT as integer = 1

    FileOpen
    Kontext "OeffnenDLG"
    hGetFileCount = DateiAuswahl.getItemCount()

    OeffnenDLG.cancel()

end function

'*******************************************************************************

function hNameGen_append( iDecChar as long , bSuf as boolean ) as string

    ' returns a filename that contains an ASCII/UNICODE character before the 
    ' (optional) dot + suffix
    dim cFile as string

    cFile = "test" & CHR$( iDecChar )

    if ( bSuf ) then        
        cFile = cFile & hGetSuffix( "current" ) 
    endif

    hNameGen_append() = cFile

end function

'*******************************************************************************

function hNameGen_lead( iDecChar as long , bSuf as boolean ) as string

    ' returns a filename that contains a leading ASCII/UNICODE character infront
    ' of the optional dot + suffix
    dim cFile as string

    cFile = CHR$( iDecChar ) & "test"

    if ( bSuf ) then   
        cFile = cFile & hGetSuffix( "current" )
    endif    

    hNamegen_lead() = cFile

end function

'*******************************************************************************

sub hCloseDocument128307 ( optional bANewDoc )
' As workaround for crash 128307 (internal tracker)
'/// hCloseDocument : close a document without saving ///'
'///+ all documents will be closed without saving ///'
   Dim sFehler$

   if IsMissing ( bANewDoc ) <> TRUE then
      if bANewDoc = TRUE then
         gNoNewDoc = FALSE
      else
         gNoNewDoc = TRUE
      end if
   end if

   ' if no new document was created, it isn't closed
   if gNoNewDoc = TRUE then
      exit sub        
   end if

   Sleep 3
   try
      FileClose
   catch
      qaErrorLog "#128307# crash on FileClose"
      sleep 10
      hStartTheOffice
      exit sub
   endcatch

   Sleep 1
   Kontext "Active"
   if Active.Exists(2) then
      try
         Active.No
      catch
         Active.Click ( 202 )
      endcatch
   end if
   Sleep (2)
end sub

