'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_ftpfolders.bas,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:12 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
' **
' ** owner : joerg.skottke@sun.com
' **
' ** short description : check special filenames and destinations
' **
'\******************************************************************************

sub main

   ' Tested ok on Win 03/09/29

   use "framework\filedlg\inc\FTPServer_tools.inc"
   use "framework\filedlg\inc\ftpserver2.inc"
   use "framework\filedlg\inc\namegen.inc"

   ' A FTP server that does not allow anonymous access (Solaris default)
   const CFTPSRV1    = "so-renoir/" ' server without ftp://
   const CFTPUSR1    = "autojsk"    ' loginname (valid!)
   const CFTPPWD1    = "autojsk"    ' password (valid!)
   const CFTPSERVER1 = "ftp://autojsk:autojsk@so-renoir/" 'sol. sparc

   dim iDocType as integer ' documenttype represented as int (WRITER etc.)

   call hStatusIn ( "framework", "filedlg_ftpfolders.bas", "test ftp-server/folders" )

   dim starttime
       starttime = now()

   'Stopping execution for OpenOffice.org if servers have not been set.
   if ( gOOO = TRUE AND CFTPSRV1 = "so-renoir/" ) then

      warnlog( "You have not defined a valid ftp-server" )
      printlog( "* Please edit the filedlg_ftpaccess.bas file to reflect your"
      printlog( "* testing environment. You need to specify a server, login "
      printlog( "* and a password. " )

   else

      for iDocType = 1 to 6

         printlog( hNumericDoctype( iDocType ) )

         ' create a folder, save a file to it,
         ' delete the file, delete the dir
         ' cycle through applications (WRITER, CALC, IMPRESS...)
         call tFTPServerDirectories1( CFTPSERVER1 )

         ' create a folder, save a file to it, try to delete the directory (fails),
         ' delete the file, then the directory (works)
         call tFTPServerDirectories2( CFTPSERVER1 )

         call ExitRestartTheOffice

      next iDocType

   endif

   printlog Chr(13) + "End : " + WieLange ( starttime )

   call hStatusOut()

end sub

' ****************************************

sub LoadIncludeFiles

   use "global\system\inc\master.inc"
   use "global\system\inc\gvariabl.inc"
   gApplication = "WRITER"
   Call GetUseFiles

end sub
