'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_so7_pp1_ibis.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'**
'** owner : peter.junge@Sun.COM
'**
'** short description :  Test fixes for IBIS Bugs
'**
'************************************************************************
' **
' #1 ibisPP1                ' Initial routine
' #1 tIBIS111099            ' Disable design mode of form controls after loading excel file
' #1 tIBIS111158            ' Lost properties of form controls
' #1 tIBIS111711            ' Crash when deleting chart in Menu->Window->New Window
' **
'\***********************************************************************

sub ibisPP1

Printlog Chr(13) + "--------- IBIS Bugs fixed? ---------"

         call tIBIS111099
         call tIBIS111158
         call tIBIS111711

end sub

'**************************************************************************************************

testcase tIBIS111099

Dim testdoc$

testdoc$ = convertpath(gTesttoolpath & "calc\special\input\111099.xls")

'/// Open test document
Call hDateioeffnen(testdoc$)
sleep(2)

'/// Invoke Control Toolbar
'/// + Try to click control 'Push Button'
'/// + -> Click successful - BUG #111099#
'/// + -> Click fails - document opened as expected in non-design mode
  Kontext "FormControls"
  if Not FormControls.Exists then
     Call hToolbarSelect("CONTROLS", true)
  end if
  Kontext "FormControls"
  if SwitchControlDesignMode.getState(2) = 0 then 
      printlog "OK, design mode is disabled"
  else
      warnlog "Document is opened in design mode -> #111099#"
  endif 
    
call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tIBIS111158

Dim testdoc$, testString$

testdoc$ = convertpath(gTesttoolpath & "calc\special\input\111158.xls")
    
'/// Open test document
Call hDateioeffnen(testdoc$)
sleep(2)

'/// Invoke form navigator
'/// + Quit if #111099# isn't fixed
  Kontext "FormControls"
  if Not FormControls.Exists then
     Call hToolbarSelect("CONTROLS", true)
  end if
  sleep(2)
  Kontext "FormControls"
  try
      SwitchControlDesignMode.click
      sleep(2)
      FormDesignTools.Click
      sleep(2)
  catch
      QAErrorlog "Document is opened in design mode -> #111099#"
      QAErrorlog "No need to test if that one isn't fixed -> aborted"
      goto endsub
  endcatch

  Kontext "FormDesignTools"
'  FormDesignTools.undock
'  FormDesignTools.move (20,20)
  ShowFmExplorer.Click
  
'/// Select control to be tested
'/// + invoke context menu
Kontext "FormularNavigator"
  Liste.TypeKeys "<HOME>" , true
  sleep(1)
  Liste.TypeKeys "<DOWN>" , 9 , true
  sleep(1)
  Liste.OpenContextmenu
  sleep(2)
  hMenuSelectNr(5)
  sleep(2)
  
'/// Define a help ID for control
'/// + this makes the control accessible for the testtool
  Kontext "ControlPropertiesDialog"
    ControlPropertiesTabControl.SetPage TabGeneralControl
    Kontext "TabGeneralControl"
      TabGeneralControl.TypeKeys "<TAB>" , true 
      HelpURL.setText "HID:123456"
'/// Close all disturbing menus
  Kontext "ControlPropertiesDialog" 
    ControlPropertiesDialog.close
    sleep(2)
  Kontext "FormularNavigator"
    FormularNavigator.close
  Kontext "FormDesignTools"
    FormDesignTools.close
  Kontext "FormControls"
    SwitchControlDesignMode.click
    FormControls.close
    
'    Formsbar.close - different behaviour after CWS 'docking1'
'/// Check for right initial string in control
  Kontext "MSC_Special_Dialog"
    testString$ = MSC_Special_Dialog.getSelText
    if testString$ = "Please select one:" then
       printlog "OK, the right string was found in control"
    else
       warnlog "Wrong string found in Control: " & testString$
    endif

call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tIBIS111711

printlog "IBIS Task 111711"

'/// open new document
call hNewDocument
sleep(2)

'/// enter some numbers as content
Kontext "DocumentCalc"
  DocumentCalc.typekeys "1<RETURN>2<RETURN><UP>"
  sleep(2)

'/// create a chart from the content
'/// + NOTE: Do NOT leave the Implace mode
InsertChartCalc
Kontext "AutoFormatDiagrammBeginn"
  Fertigstellen.Click
  sleep(2)

'/// Call slot Window->New Window
Kontext "DocumentCalc"
DocumentCalc.typekeys "<ESCAPE>"
  WindowNewWindow
  sleep(2)
  call gMouseClick(95,95)

'/// Select chart in new window
Kontext "DocumentCalc"
  call selectFirstOLE
  sleep(2)
  
'/// Delete chart in new window ...
'/// ... and check for crash
Kontext "DocumentCalc"
try  
  DocumentCalc.typekeys "<DELETE>"
  sleep (2)
  printlog "OK, there are still " & hWindowGetCount & " documents open"
catch 
   warnlog "Probably the office did crash -> #111711#"
   goto endsub
endcatch  

call hCloseDocument
endcase


